/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.web.TomcatDeploymentConfig;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.startup.ContextConfig;

public class WebModuleContextConfig
extends ContextConfig {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    public static final int CHILDREN = 0;
    public static final int SERVLET_MAPPINGS = 1;
    public static final int LOCAL_EJBS = 2;
    public static final int EJBS = 3;
    public static final int ENVIRONMENTS = 4;
    public static final int ERROR_PAGES = 5;
    public static final int FILTER_DEFS = 6;
    public static final int FILTER_MAPS = 7;
    public static final int APPLICATION_LISTENERS = 8;
    public static final int RESOURCES = 9;
    public static final int APPLICATION_PARAMETERS = 10;
    public static final int MESSAGE_DESTINATIONS = 11;
    public static final int MESSAGE_DESTINATION_REFS = 12;
    public static final int MIME_MAPPINGS = 13;
    protected File file;
    private WebBundleDescriptor webBundleDescriptor;

    public void setDescriptor(WebBundleDescriptor wbd) {
        this.webBundleDescriptor = wbd;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected synchronized void start() {
        try {
            TomcatDeploymentConfig.configureWebModule((WebModule)this.context, this.webBundleDescriptor);
        }
        catch (Throwable t) {
            this.context.setAvailable(false);
            Object[] objs = new Object[]{this.context.getName(), t};
            logger.log(Level.SEVERE, "webModuleContextConfig.webModuleDisabled", objs);
        }
        this.context.setConfigured(false);
        this.authenticatorConfig();
        this.managerConfig();
        this.context.setConfigured(true);
    }

    protected synchronized void authenticatorConfig() {
        Pipeline pipeline;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline2 != null) {
                Valve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        Realm rlm = this.context.getRealm();
        if (rlm == null) {
            logger.log(Level.SEVERE, "webModuleContextConfig.missingRealm");
            this.ok = false;
            return;
        }
        rlm.setRealmName(loginConfig.getRealmName(), loginConfig.getAuthMethod());
        Valve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (Valve)this.customAuthenticators.get(loginConfig.getAuthMethod());
        }
        if (authenticator == null) {
            if (authenticators == null) {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
                    if (is == null) {
                        logger.log(Level.SEVERE, "webModuleContextConfig.authenticatorResources");
                        this.ok = false;
                        return;
                    }
                    authenticators = new Properties();
                    authenticators.load(is);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "webModuleContextConfig.authenticatorResources", e);
                    this.ok = false;
                    return;
                }
            }
            String authenticatorName = null;
            String authMethod = loginConfig.getAuthMethod();
            if (authMethod == null) {
                authMethod = "NONE";
            }
            if ((authenticatorName = authenticators.getProperty(authMethod)) == null) {
                logger.log(Level.SEVERE, "webModuleContextConfig.authenticatorMissing", loginConfig.getAuthMethod());
                this.ok = false;
                return;
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (Valve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "webModuleContextConfig.authenticatorInstantiate", authenticatorName);
                logger.log(Level.SEVERE, "webModuleContextConfig.authenticatorInstantiate", t);
                this.ok = false;
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).addValve(authenticator);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "webModuleContextConfig.authenticatorConfigured", loginConfig.getAuthMethod());
            }
        }
    }

    protected void defaultConfig() {
    }
}

