/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Date;
import org.apache.catalina.util.ServerInfo;

public class HtmlHelper {
    private static CharBuffer reponseBuffer = CharBuffer.allocate(4096);
    private static CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
    private static String NEWLINE = "\r\n";
    public static final String OK = "HTTP/1.1 200 OK" + NEWLINE;
    public static final String BAD_REQUEST = "HTTP/1.1 400 Bad Request" + NEWLINE;

    public static synchronized ByteBuffer getErrorPage(String message, String code) throws IOException {
        String body = HtmlHelper.prepareBody(message);
        reponseBuffer.clear();
        reponseBuffer.put(code);
        HtmlHelper.appendHeaderValue("Content-Type", "text/html");
        HtmlHelper.appendHeaderValue("Content-Length", body.getBytes().length + "");
        HtmlHelper.appendHeaderValue("Date", new Date().toString());
        HtmlHelper.appendHeaderValue("Connection", "Close");
        HtmlHelper.appendHeaderValue("Server", ServerInfo.getServerInfo());
        reponseBuffer.put(NEWLINE);
        reponseBuffer.put(body);
        reponseBuffer.flip();
        return encoder.encode(reponseBuffer);
    }

    private static void appendHeaderValue(String name, String value) {
        reponseBuffer.put(name);
        reponseBuffer.put(": ");
        reponseBuffer.put(value);
        reponseBuffer.put(NEWLINE);
    }

    private static String prepareBody(String message) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><title>");
        sb.append(ServerInfo.getServerInfo());
        sb.append("</title>");
        sb.append("<style><!--");
        sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}");
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("<h1>");
        sb.append(message);
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade>");
        sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        sb.append("</body></html>");
        return sb.toString();
    }
}

