/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.handlers.NoParsingHandler;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;

public class ReadBlockingTask
extends ReadTask {
    protected PipelineStatistic pipelineStat;
    private NoParsingHandler handler;

    public ReadBlockingTask() {
        this.type = 1;
        this.taskContext = new TaskContext();
        this.taskEvent = new TaskEvent<TaskContext>(this.taskContext);
        this.taskEvent.setStatus(0);
    }

    public void attachProcessor(ProcessorTask processorTask) {
        this.handler = new NoParsingHandler(this.selectorThread.getPort());
        this.processorTask = processorTask;
        processorTask.useAlternateKeepAlive(false);
        processorTask.setHandler(this.handler);
    }

    public void doTask() throws IOException {
        Socket socket = this.processorTask.getSocket();
        this.selectorThread.setSocketOptions(socket);
        if (this.selectorThread.getSecure()) {
            try {
                this.selectorThread.getServerSocketFactory().handshake(socket);
            }
            catch (Throwable ex) {
                ReadBlockingTask readBlockingTask = this;
                readBlockingTask.selectorThread.logger().log(Level.FINE, "selectorThread.sslHandshakeException", ex);
                this.taskEvent.setStatus(2);
                this.taskEvent(this.taskEvent);
                return;
            }
        }
        this.processorTask.addTaskListener(this);
        this.addTaskListener(this.processorTask);
        this.handler.attachChannel(this.processorTask.getSocket().getChannel());
        this.fireTaskEvent(this.taskEvent);
    }

    public void recycle() {
        this.clearTaskListeners();
        this.taskEvent.setStatus(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishConnection() {
        Socket socket = this.processorTask.getSocket();
        if (this.selectorThread.getSSLImplementation() == null) {
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.isMonitoringEnabled()) {
                this.getRequestGroupInfo().decreaseCountOpenConnections();
            }
        }
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2) {
            this.finishConnection();
            if (this.recycle) {
                this.processorTask.recycle();
                this.recycle();
                this.selectorThread.returnTask(this);
            }
        }
    }

    protected Socket getSocket() {
        return this.processorTask.getSocket();
    }

    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }
}

