/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.PEWebContainer;
import java.util.ArrayList;

public class VirtualServerReconfig
implements HSVirtualServerEventListener {
    private static PEWebContainer webContainer = (PEWebContainer)PEWebContainer.getInstance();

    public void handleCreate(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigAdd configAdd = null;
            ArrayList configChangeList = event.getConfigChangeList();
            VirtualServer vsBean = null;
            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                Object configObject = configChangeList.get(i);
                if (!(configObject instanceof ConfigAdd) || (xpath = (configAdd = (ConfigAdd)configObject).getXPath()) == null) continue;
                ConfigBean object = configContext.exactLookup(xpath);
                if (object instanceof VirtualServer) {
                    vsBean = (VirtualServer)object;
                    webContainer.createHost(vsBean, configContext, true);
                    continue;
                }
                if (!(object instanceof ElementProperty)) continue;
                xpath = xpath.substring(0, xpath.lastIndexOf("/"));
                vsBean = (VirtualServer)configContext.exactLookup(xpath);
                elementProperty = (ElementProperty)object;
                webContainer.updateHostProperties(vsBean, elementProperty.getName(), elementProperty.getValue(), config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleUpdate(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigChange configChange = null;
            ArrayList configChangeList = event.getConfigChangeList();
            VirtualServer vsBean = null;
            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configChange = (ConfigChange)configChangeList.get(i);
                xpath = configChange.getXPath();
                if (xpath == null) continue;
                ConfigBean object = configContext.exactLookup(xpath);
                if (object instanceof VirtualServer) {
                    vsBean = (VirtualServer)object;
                    webContainer.updateHost(vsBean, config.getHttpService(), serverBean);
                    continue;
                }
                if (!(object instanceof ElementProperty)) continue;
                xpath = xpath.substring(0, xpath.lastIndexOf("/"));
                vsBean = (VirtualServer)configContext.exactLookup(xpath);
                elementProperty = (ElementProperty)object;
                webContainer.updateHostProperties(vsBean, elementProperty.getName(), elementProperty.getValue(), config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext;
            Config config;
            if (event != null && (config = ServerBeansFactory.getConfigBean(configContext = event.getConfigContext())) != null) {
                webContainer.deleteHost(config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }
}

