/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.web.stats.StatsUtil;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class HTTPListenerStatsImpl
implements HTTPListenerStats {
    private static Logger _logger = null;
    private GenericStatsImpl baseStatsImpl;
    private MBeanServer server;
    private ObjectName tpName;
    private ObjectName grpName;
    private MutableCountStatistic bytesReceived;
    private MutableCountStatistic bytesSent;
    private MutableCountStatistic errorCount;
    private MutableCountStatistic maxTime;
    private MutableCountStatistic processingTime;
    private MutableCountStatistic requestCount;
    private MutableCountStatistic curThreadCount;
    private MutableCountStatistic curThreadsBusy;
    private MutableCountStatistic maxThreads;
    private MutableCountStatistic maxSpareThreads;
    private MutableCountStatistic minSpareThreads;
    private MutableCountStatistic count2xx;
    private MutableCountStatistic count3xx;
    private MutableCountStatistic count4xx;
    private MutableCountStatistic count5xx;
    private MutableCountStatistic countOther;
    private MutableCountStatistic count200;
    private MutableCountStatistic count302;
    private MutableCountStatistic count304;
    private MutableCountStatistic count400;
    private MutableCountStatistic count401;
    private MutableCountStatistic count403;
    private MutableCountStatistic count404;
    private MutableCountStatistic count503;
    private MutableCountStatistic countOpenConnections;
    private MutableCountStatistic maxOpenConnections;

    public HTTPListenerStatsImpl(String domain, int port) {
        String msg;
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        this.baseStatsImpl = new GenericStatsImpl(HTTPListenerStats.class, (Object)this);
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        String objNameStr = domain + ":type=Selector,name=http" + port;
        try {
            this.tpName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            msg = _logger.getResourceBundle().getString("webcontainer.objectNameCreationError");
            msg = MessageFormat.format(msg, objNameStr);
            _logger.log(Level.SEVERE, msg, t);
        }
        objNameStr = domain + ":type=GlobalRequestProcessor" + ",name=http" + port;
        try {
            this.grpName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            msg = _logger.getResourceBundle().getString("webcontainer.objectNameCreationError");
            msg = MessageFormat.format(msg, objNameStr);
            _logger.log(Level.SEVERE, msg, t);
        }
        this.initializeStatistics();
    }

    public CountStatistic getBytesReceived() {
        this.bytesReceived.setCount(this.getBytesReceivedLong());
        return (CountStatistic)this.bytesReceived.unmodifiableView();
    }

    public CountStatistic getBytesSent() {
        this.bytesSent.setCount(this.getBytesSentLong());
        return (CountStatistic)this.bytesSent.unmodifiableView();
    }

    public CountStatistic getProcessingTime() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "processingTime");
        this.processingTime.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.processingTime.unmodifiableView();
    }

    public CountStatistic getRequestCount() {
        this.requestCount.setCount(this.getRequestCountLong());
        return (CountStatistic)this.requestCount.unmodifiableView();
    }

    public CountStatistic getErrorCount() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "errorCount");
        this.errorCount.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.errorCount.unmodifiableView();
    }

    public CountStatistic getMaxTime() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "maxTime");
        this.maxTime.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.maxTime.unmodifiableView();
    }

    public CountStatistic getCount2xx() {
        this.count2xx.setCount(this.getCount2xxLong());
        return (CountStatistic)this.count2xx.unmodifiableView();
    }

    public CountStatistic getCount3xx() {
        this.count3xx.setCount(this.getCount3xxLong());
        return (CountStatistic)this.count3xx.unmodifiableView();
    }

    public CountStatistic getCount4xx() {
        this.count4xx.setCount(this.getCount4xxLong());
        return (CountStatistic)this.count4xx.unmodifiableView();
    }

    public CountStatistic getCount5xx() {
        this.count5xx.setCount(this.getCount5xxLong());
        return (CountStatistic)this.count5xx.unmodifiableView();
    }

    public CountStatistic getCountOther() {
        this.countOther.setCount(this.getCountOtherLong());
        return (CountStatistic)this.countOther.unmodifiableView();
    }

    public CountStatistic getCount200() {
        this.count200.setCount(this.getCount200Long());
        return (CountStatistic)this.count200.unmodifiableView();
    }

    public CountStatistic getCount302() {
        this.count302.setCount(this.getCount302Long());
        return (CountStatistic)this.count302.unmodifiableView();
    }

    public CountStatistic getCount304() {
        this.count304.setCount(this.getCount304Long());
        return (CountStatistic)this.count304.unmodifiableView();
    }

    public CountStatistic getCount400() {
        this.count400.setCount(this.getCount400Long());
        return (CountStatistic)this.count400.unmodifiableView();
    }

    public CountStatistic getCount401() {
        this.count401.setCount(this.getCount401Long());
        return (CountStatistic)this.count401.unmodifiableView();
    }

    public CountStatistic getCount403() {
        this.count403.setCount(this.getCount403Long());
        return (CountStatistic)this.count403.unmodifiableView();
    }

    public CountStatistic getCount404() {
        this.count404.setCount(this.getCount404Long());
        return (CountStatistic)this.count404.unmodifiableView();
    }

    public CountStatistic getCount503() {
        this.count503.setCount(this.getCount503Long());
        return (CountStatistic)this.count503.unmodifiableView();
    }

    public CountStatistic getCountOpenConnections() {
        this.countOpenConnections.setCount(this.getCountOpenConnectionsLong());
        return (CountStatistic)this.countOpenConnections.unmodifiableView();
    }

    public CountStatistic getMaxOpenConnections() {
        this.maxOpenConnections.setCount(this.getMaxOpenConnectionsLong());
        return (CountStatistic)this.maxOpenConnections.unmodifiableView();
    }

    public CountStatistic getCurrentThreadCount() {
        Object countObj = StatsUtil.getStatistic(this.server, this.tpName, "currentThreadCountStats");
        this.curThreadCount.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.curThreadCount.unmodifiableView();
    }

    public CountStatistic getCurrentThreadsBusy() {
        Object countObj = StatsUtil.getStatistic(this.server, this.tpName, "currentThreadsBusyStats");
        this.curThreadsBusy.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.curThreadsBusy.unmodifiableView();
    }

    public CountStatistic getMaxSpareThreads() {
        Object countObj = StatsUtil.getStatistic(this.server, this.tpName, "maxSpareThreadsStats");
        this.maxSpareThreads.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.maxSpareThreads.unmodifiableView();
    }

    public CountStatistic getMaxThreads() {
        Object countObj = StatsUtil.getStatistic(this.server, this.tpName, "maxThreadsStats");
        this.maxThreads.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.maxThreads.unmodifiableView();
    }

    public CountStatistic getMinSpareThreads() {
        Object countObj = StatsUtil.getStatistic(this.server, this.tpName, "minSpareThreadsStats");
        this.minSpareThreads.setCount(StatsUtil.getLongValue(countObj));
        return (CountStatistic)this.minSpareThreads.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    long getBytesReceivedLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "bytesReceived");
        return StatsUtil.getLongValue(countObj);
    }

    long getBytesSentLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "bytesSent");
        return StatsUtil.getLongValue(countObj);
    }

    long getRequestCountLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "requestCount");
        return StatsUtil.getLongValue(countObj);
    }

    long getCountOpenConnectionsLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "countOpenConnections");
        return StatsUtil.getLongValue(countObj);
    }

    long getMaxOpenConnectionsLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "maxOpenConnections");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount2xxLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count2xx");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount3xxLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count3xx");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount4xxLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count4xx");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount5xxLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count5xx");
        return StatsUtil.getLongValue(countObj);
    }

    long getCountOtherLong() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "countOther");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount200Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count200");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount302Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count302");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount304Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count304");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount400Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count400");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount401Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count401");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount403Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count403");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount404Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count404");
        return StatsUtil.getLongValue(countObj);
    }

    long getCount503Long() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "count503");
        return StatsUtil.getLongValue(countObj);
    }

    String getLastRequestURI() {
        return (String)StatsUtil.getStatistic(this.server, this.grpName, "lastRequestURI");
    }

    String getLastRequestMethod() {
        return (String)StatsUtil.getStatistic(this.server, this.grpName, "lastRequestMethod");
    }

    long getLastRequestCompletionTime() {
        Object countObj = StatsUtil.getStatistic(this.server, this.grpName, "lastRequestCompletionTime");
        return StatsUtil.getLongValue(countObj);
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("BytesReceived");
        this.bytesReceived = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("BytesSent");
        this.bytesSent = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("ErrorCount");
        this.errorCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxTime", "milliseconds");
        this.maxTime = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("ProcessingTime", "milliseconds");
        this.processingTime = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("RequestCount");
        this.requestCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CurrentThreadCount");
        this.curThreadCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CurrentThreadsBusy");
        this.curThreadsBusy = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxThreads");
        this.maxThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxSpareThreads");
        this.maxSpareThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MinSpareThreads");
        this.minSpareThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count2xx");
        this.count2xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count3xx");
        this.count3xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count4xx");
        this.count4xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count5xx");
        this.count5xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountOther");
        this.countOther = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count200");
        this.count200 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count302");
        this.count302 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count304");
        this.count304 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count400");
        this.count400 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count401");
        this.count401 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count403");
        this.count403 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count404");
        this.count404 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count503");
        this.count503 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountOpenConnections");
        this.countOpenConnections = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxOpenConnections");
        this.maxOpenConnections = new MutableCountStatisticImpl((CountStatistic)c);
    }
}

