/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.webservice.Ejb3MessageDispatcher;
import com.sun.enterprise.webservice.EjbMessageDispatcher;
import com.sun.enterprise.webservice.JAXWSSystemHandlerDelegateFactory;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import com.sun.enterprise.webservice.WebServiceContextImpl;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.WSRtObjectFactory;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.MessageContext;

public class EjbRuntimeEndpointInfo {
    protected static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected WebServiceEndpoint endpoint;
    protected StatelessSessionContainer container;
    protected Object webServiceEndpointServant;
    protected ServerAuthConfig serverAuthConfig;
    protected InvocationManager invManager;
    private WSRtObjectFactory rpcFactory = WSRtObjectFactory.newInstance();
    private RuntimeEndpointInfo jaxWSRuntimeInfo = null;
    private boolean handlersConfigured = false;
    protected EjbMessageDispatcher messageDispatcher = null;

    public EjbRuntimeEndpointInfo(WebServiceEndpoint webServiceEndpoint, StatelessSessionContainer ejbContainer, Object servant) {
        this.endpoint = webServiceEndpoint;
        this.container = ejbContainer;
        this.webServiceEndpointServant = servant;
        Switch theSwitch = Switch.getSwitch();
        this.invManager = theSwitch.getInvocationManager();
        try {
            this.serverAuthConfig = ServerAuthConfig.getConfig("SOAP", this.endpoint.getMessageSecurityBinding(), WSSCallbackHandler.getInstance());
        }
        catch (AuthException ae) {
            logger.log(Level.SEVERE, "EJB Webservice security configuration Failure", ae);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ServerAuthConfig getServerAuthConfig() {
        return this.serverAuthConfig;
    }

    public String getEndpointAddressUri() {
        return this.endpoint.getEndpointAddressUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeEndpointInfo prepareInvocation(boolean doPreInvoke) throws Exception {
        EjbRuntimeEndpointInfo ejbRuntimeEndpointInfo;
        if (this.jaxWSRuntimeInfo == null) {
            ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (this.jaxWSRuntimeInfo == null) {
                    this.populateRuntimeEndpointInfo();
                }
            }
        }
        if (doPreInvoke) {
            Invocation inv = new Invocation();
            inv.isWebService = true;
            inv.container = this.container;
            inv.transactionAttribute = 0;
            inv.securityPermissions = 0;
            MessageContext msgCtxt = this.rpcFactory.createMessageContext();
            this.jaxWSRuntimeInfo.getWebServiceContext().setMessageContext(msgCtxt);
            inv.setContextData(this.jaxWSRuntimeInfo.getWebServiceContext());
            this.invManager.preInvoke(inv);
        }
        if (!this.handlersConfigured && doPreInvoke) {
            ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (!this.handlersConfigured) {
                    new WsUtil().configureJAXWSServiceHandlers(this.endpoint, this.jaxWSRuntimeInfo);
                    this.jaxWSRuntimeInfo.init();
                    this.handlersConfigured = true;
                }
            }
        }
        return this.jaxWSRuntimeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeEndpointInfo initRuntimeInfo() throws Exception {
        try {
            RuntimeEndpointInfo runtimeEndpointInfo = this.prepareInvocation(true);
            return runtimeEndpointInfo;
        }
        finally {
            this.invManager.postInvoke(this.invManager.getCurrentInvocation());
        }
    }

    private void populateRuntimeEndpointInfo() {
        if (this.jaxWSRuntimeInfo == null) {
            this.jaxWSRuntimeInfo = this.rpcFactory.createRuntimeEndpointInfo();
            this.jaxWSRuntimeInfo.setPortName(this.endpoint.getWsdlPort());
            this.jaxWSRuntimeInfo.setServiceName(this.endpoint.getServiceName());
            String implClassName = this.endpoint.getEjbComponentImpl().getEjbClassName();
            try {
                Class<?> clazz = this.container.getClassLoader().loadClass(implClassName);
                this.jaxWSRuntimeInfo.setImplementorClass(clazz);
            }
            catch (Exception cnfe) {
                logger.severe("Cannot load or instanciate " + implClassName);
            }
            this.jaxWSRuntimeInfo.setImplementor(this.webServiceEndpointServant);
            WebServiceContextImpl wsc = null;
            EjbDescriptor ejbDesc = this.endpoint.getEjbComponentImpl();
            for (ResourceReferenceDescriptor r : ejbDesc.getResourceReferenceDescriptors()) {
                if (!r.isWebServiceContext()) continue;
                try {
                    InitialContext ic = new InitialContext();
                    wsc = (WebServiceContext)ic.lookup("java:comp/env/" + r.getName());
                    break;
                }
                catch (Throwable t) {
                }
            }
            if (wsc == null) {
                wsc = new WebServiceContextImpl();
            }
            this.jaxWSRuntimeInfo.setWebServiceContext((WebServiceContext)wsc);
            this.jaxWSRuntimeInfo.setBinding(this.rpcFactory.createBinding(this.endpoint.getProtocolBinding()));
            WsUtil wsu = new WsUtil();
            wsu.setMtom((Binding)this.jaxWSRuntimeInfo.getBinding(), this.endpoint);
            URL catalogURL = null;
            File catalogFile = new File(this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
            if (catalogFile.exists()) {
                try {
                    catalogURL = catalogFile.toURL();
                }
                catch (MalformedURLException mfue) {
                    logger.warning(" Malformed URL " + mfue.getMessage());
                }
            }
            this.jaxWSRuntimeInfo.setWsdlInfo(this.endpoint.getWebService().getWsdlFileUrl(), this.rpcFactory.createEntityResolver(catalogURL));
            JAXWSEndpointImpl endpointImpl = (JAXWSEndpointImpl)this.endpoint.getExtraAttribute("MONITORING_ENDPOINT");
            SystemHandlerDelegate delegate = JAXWSSystemHandlerDelegateFactory.getEjbDelegate(this.serverAuthConfig, this.endpoint, endpointImpl);
            if (endpointImpl != null) {
                endpointImpl.setParent(delegate);
                this.jaxWSRuntimeInfo.getBinding().setSystemHandlerDelegate((SystemHandlerDelegate)endpointImpl);
            } else {
                this.jaxWSRuntimeInfo.getBinding().setSystemHandlerDelegate(delegate);
            }
        }
    }

    public void releaseImplementor() {
        try {
            Invocation inv = (Invocation)this.invManager.getCurrentInvocation();
            if (inv != null) {
                if (inv.ejb != null) {
                    this.container.postInvoke(inv);
                } else {
                    this.invManager.postInvoke(inv);
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "", t);
        }
    }

    public EjbMessageDispatcher getMessageDispatcher() {
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new Ejb3MessageDispatcher();
        }
        return this.messageDispatcher;
    }
}

