/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TransactionState;
import java.util.Collection;
import java.util.Enumeration;
import org.omg.CosTransactions.Status;

public class AdminUtil {
    private static RWLock statisticsLock = new RWLock();
    private static long lSampleStartTime = 0L;
    private static long lSampleEndTime = 0L;
    static boolean bSampling = false;
    private static int iCommits = 0;
    private static int iAborts = 0;
    private static int iUAborts = 0;
    private static int iPending = 0;
    static int iRecCommits = 0;
    static int iRecAborts = 0;
    private static Object lkCommits = new Object();
    private static Object lkAborts = new Object();
    private static Object lkUAborts = new Object();
    private static Object lkPending = new Object();
    static Object lkRecCommits = new Object();
    static Object lkRecAborts = new Object();

    public static void freezeAll() {
        TransactionState.freezeLock.acquireWriteLock();
    }

    public static void unfreezeAll() {
        TransactionState.freezeLock.releaseWriteLock();
    }

    public static boolean isFrozenAll() {
        return TransactionState.freezeLock.isWriteLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSampling() {
        if (!bSampling) {
            try {
                statisticsLock.acquireWriteLock();
                lSampleEndTime = 0L;
                lSampleStartTime = System.currentTimeMillis();
                iCommits = 0;
                iAborts = 0;
                iPending = 0;
                iRecCommits = 0;
                iRecAborts = 0;
                for (CoordinatorImpl coord : AdminUtil.getAllTransactions()) {
                    if (coord.get_status() != Status.StatusPrepared) continue;
                    ++iPending;
                }
                bSampling = true;
            }
            finally {
                statisticsLock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSampling() {
        try {
            statisticsLock.acquireWriteLock();
            lSampleEndTime = System.currentTimeMillis();
            bSampling = false;
        }
        finally {
            statisticsLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementCommitedTransactionCount() {
        try {
            statisticsLock.acquireReadLock();
            Object object = lkCommits;
            synchronized (object) {
                ++iCommits;
            }
        }
        finally {
            statisticsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementAbortedTransactionCount() {
        try {
            statisticsLock.acquireReadLock();
            Object object = lkAborts;
            synchronized (object) {
                ++iAborts;
            }
        }
        finally {
            statisticsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementUnpreparedAbortedTransactionCount() {
        try {
            statisticsLock.acquireReadLock();
            Object object = lkUAborts;
            synchronized (object) {
                ++iUAborts;
            }
        }
        finally {
            statisticsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementPendingTransactionCount() {
        try {
            statisticsLock.acquireReadLock();
            Object object = lkPending;
            synchronized (object) {
                ++iPending;
            }
        }
        finally {
            statisticsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementRecoveryCommitedTransactionCount() {
        try {
            statisticsLock.acquireReadLock();
            Object object = lkRecCommits;
            synchronized (object) {
                ++iRecCommits;
            }
        }
        finally {
            statisticsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementRecoveryAbortedTransactionCount() {
        try {
            statisticsLock.acquireReadLock();
            Object object = lkRecAborts;
            synchronized (object) {
                ++iRecAborts;
            }
        }
        finally {
            statisticsLock.releaseReadLock();
        }
    }

    public static long getCommitedTransactionCount() {
        return iCommits;
    }

    public static long getAbortedTransactionCount() {
        return iAborts;
    }

    public static long getActiveTransactionCount() {
        return (long)RecoveryManager.getCoordsByGlobalTID().size() - AdminUtil.getPendingTransactionCount();
    }

    public static long getPendingTransactionCount() {
        return iPending - iAborts - iCommits + iUAborts;
    }

    public static long getRecoveryCommitedTransactionCount() {
        return iRecCommits;
    }

    public static long getRecoveryAbortedTransactionCount() {
        return iRecAborts;
    }

    public static long getSamplingStartTime() {
        return lSampleStartTime;
    }

    public static long getSamplingEndTime() {
        return lSampleEndTime;
    }

    public static long getSamplingDuration() {
        return lSampleEndTime == 0L && lSampleStartTime != 0L ? System.currentTimeMillis() - lSampleStartTime : lSampleEndTime - lSampleStartTime;
    }

    public static Collection getAllTransactions() {
        return RecoveryManager.getCoordsByGlobalTID().values();
    }

    public static Enumeration getAllTIDs() {
        return RecoveryManager.getCoordsByGlobalTID().keys();
    }
}

