/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.impl.SecurityTokenException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinarySecurityToken
extends SecurityHeaderBlockImpl
implements SecurityToken {
    protected String valueType = null;
    protected String encodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    protected String wsuId = null;
    protected String encodedText = null;
    protected Document soapDoc = null;
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    BinarySecurityToken(Document document, String wsuId, String valueType) throws SecurityTokenException {
        this.soapDoc = document;
        this.wsuId = wsuId;
        this.setValueType(valueType);
        this.setEncodingType(this.encodingType);
    }

    BinarySecurityToken(SOAPElement binTokenSoapElement) throws SecurityTokenException {
        this(binTokenSoapElement, false);
    }

    BinarySecurityToken(SOAPElement binTokenSoapElement, boolean isBSP) throws SecurityTokenException {
        this.setSOAPElement(binTokenSoapElement);
        this.soapDoc = this.getOwnerDocument();
        this.setTextValue(XMLUtil.getFullTextFromChildren((Element)((Object)this)));
        String wsuId = this.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (!"".equals(wsuId)) {
            this.setId(wsuId);
        }
        String valueType = this.getAttribute("ValueType");
        if (isBSP && valueType.length() < 1) {
            log.log(Level.SEVERE, "BSP3031.ValueType.NotPresent");
            throw new SecurityTokenException("Any wsse:BinarySecurityToken in a SECURE_ENVELOPE MUST have an ValueType attribute.");
        }
        if (!"".equals(valueType)) {
            this.setValueType(valueType);
        }
        if (isBSP) {
            String encoding = this.getAttribute("EncodingType");
            if (this.encodingType.length() < 1) {
                log.log(Level.SEVERE, "BSP3029.EncodingType.NotPresent");
                throw new SecurityTokenException("Any wsse:BinarySecurityToken in a SECURE_ENVELOPE MUST have an EncodingType attribute.");
            }
            if (!this.encodingType.equalsIgnoreCase("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary")) {
                log.log(Level.SEVERE, "BSP3030.EncodingType.Invalid");
                throw new SecurityTokenException("EncodingType attribute value in wsse:BinarySecurityToken is invalid.");
            }
            if (!"".equals(encoding)) {
                this.setEncodingType(encoding);
            }
        }
    }

    public String getValueType() {
        return this.valueType;
    }

    protected void setValueType(String valueType) {
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType)) {
            log.log(Level.SEVERE, "WSS0342.valtype.invalid");
            throw new RuntimeException("Unsupported value type: " + valueType);
        }
        this.valueType = valueType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    protected void setEncodingType(String encodingType) {
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(encodingType)) {
            log.log(Level.SEVERE, "WSS0316.enctype.invalid");
            throw new RuntimeException("Encoding type invalid");
        }
        this.encodingType = encodingType;
    }

    public String getId() {
        return this.wsuId;
    }

    protected void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    public byte[] getRawValue() throws SecurityTokenException {
        try {
            return Base64.decode(this.encodedText);
        }
        catch (Base64DecodingException bde) {
            log.log(Level.SEVERE, "WSS0344.error.decoding.bst");
            throw new SecurityTokenException(bde);
        }
    }

    protected void setRawValue(byte[] rawText) {
        this.encodedText = Base64.encode(rawText);
    }

    public String getTextValue() throws XWSSecurityException {
        return this.encodedText;
    }

    protected void setTextValue(String encodedText) {
        this.encodedText = encodedText;
    }

    public SOAPElement getAsSoapElement() throws SecurityTokenException {
        if (null != this.delegateElement) {
            return this.delegateElement;
        }
        try {
            this.setSOAPElement((SOAPElement)this.soapDoc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken"));
            this.addNamespaceDeclaration("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (null != this.valueType) {
                this.setAttribute("ValueType", this.valueType);
            }
            if (this.encodingType != null) {
                this.setAttribute("EncodingType", this.encodingType);
            }
            if (this.wsuId != null) {
                this.setWsuIdAttr((Element)((Object)this), this.wsuId);
            }
            this.addTextNode(this.getTextValue());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0343.error.creating.bst", e.getMessage());
            throw new SecurityTokenException("There was an error in creating the BinarySecurityToken " + e.getMessage());
        }
        return this.delegateElement;
    }
}

