/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ResponseUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardHostValve
extends ValveBase {
    private static Log log = LogFactory.getLog(StandardHostValve.class);
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Valve errorReportValve;

    StandardHostValve() {
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            ((HttpServletResponse)response.getResponse()).sendError(500);
            response.setDetailMessage(sm.getString("standardHost.noContext"));
            return 2;
        }
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        context.getPipeline().invoke(request, response);
        return 2;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        response.setSuspended(false);
        Throwable t = (Throwable)hreq.getAttribute("javax.servlet.error.exception");
        if (t != null) {
            this.throwable(request, response, t);
        } else {
            this.status(request, response);
        }
        Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
        if (this.errorReportValve != null) {
            this.errorReportValve.postInvoke(request, response);
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("standardHost.clientAbort", realError.getCause().getMessage()));
            }
            return;
        }
        ErrorPage errorPage = StandardHostValve.findErrorPage(context, throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = StandardHostValve.findErrorPage(context, realError);
        }
        if (errorPage != null) {
            response.setAppCommitted(false);
            ServletRequest sreq = request.getRequest();
            ServletResponse sresp = response.getResponse();
            sreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)errorPage.getLocation());
            sreq.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)new Integer(1));
            sreq.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
            sreq.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            sreq.setAttribute("javax.servlet.error.exception", (Object)realError);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                sreq.setAttribute("javax.servlet.error.servlet_name", (Object)wrapper.getName());
            }
            sreq.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)sreq).getRequestURI());
            sreq.setAttribute("javax.servlet.error.exception_type", realError.getClass());
            if (this.custom(request, response, errorPage)) {
                try {
                    sresp.flushBuffer();
                }
                catch (IOException e) {
                    this.log("Exception Processing " + errorPage, e);
                }
            }
        } else {
            ServletResponse sresp = (ServletResponse)response;
            ((HttpServletResponse)sresp).setStatus(500);
            response.setError();
            this.status(request, response);
        }
    }

    protected void status(Request request, Response response) {
        if (!(response instanceof HttpResponse)) {
            return;
        }
        HttpResponse hresponse = (HttpResponse)response;
        if (!(response.getResponse() instanceof HttpServletResponse)) {
            return;
        }
        int statusCode = hresponse.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage != null) {
            response.setAppCommitted(false);
            ServletRequest sreq = request.getRequest();
            ServletResponse sresp = response.getResponse();
            sreq.setAttribute("javax.servlet.error.status_code", (Object)new Integer(statusCode));
            String message = RequestUtil.filter(hresponse.getMessage());
            if (message == null) {
                message = "";
            }
            sreq.setAttribute("javax.servlet.error.message", (Object)message);
            sreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)errorPage.getLocation());
            sreq.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)new Integer(1));
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                sreq.setAttribute("javax.servlet.error.servlet_name", (Object)wrapper.getName());
            }
            if (sreq instanceof HttpServletRequest) {
                sreq.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)sreq).getRequestURI());
            }
            if (this.custom(request, response, errorPage)) {
                try {
                    sresp.flushBuffer();
                }
                catch (IOException e) {
                    this.log("Exception Processing " + errorPage, e);
                }
            }
        } else {
            errorPage = ((StandardHost)this.getContainer()).findErrorPage(statusCode);
            if (errorPage != null) {
                try {
                    this.handleHostErrorPage(response, errorPage, statusCode);
                }
                catch (Exception e) {
                    this.log("Exception Processing " + errorPage, e);
                }
            }
        }
    }

    protected static ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    protected boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.debug >= 1) {
            this.log("Processing " + errorPage);
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        ((HttpRequest)request).setPathInfo(errorPage.getLocation());
        try {
            Integer statusCodeObj = (Integer)hreq.getAttribute("javax.servlet.error.status_code");
            int statusCode = statusCodeObj;
            String message = (String)hreq.getAttribute("javax.servlet.error.message");
            ((HttpResponse)response).reset(statusCode, message);
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            rd.forward((ServletRequest)hreq, (ServletResponse)hres);
            response.setSuspended(false);
            return true;
        }
        catch (Throwable t) {
            this.log("Exception Processing " + errorPage, t);
            return false;
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private void handleHostErrorPage(Response response, ErrorPage errorPage, int statusCode) throws Exception {
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        FileReader reader = null;
        BufferedInputStream istream = null;
        IOException ioe = null;
        String message = errorPage.getReason();
        if (message != null) {
            ((HttpResponse)response).reset(statusCode, message);
        }
        try {
            ostream = response.getResponse().getOutputStream();
        }
        catch (IllegalStateException e) {
            writer = response.getResponse().getWriter();
        }
        if (writer != null) {
            reader = new FileReader(errorPage.getLocation());
            ioe = ResponseUtil.copy(reader, writer);
            try {
                reader.close();
            }
            catch (Throwable t) {}
        } else {
            istream = new BufferedInputStream(new FileInputStream(errorPage.getLocation()));
            ioe = ResponseUtil.copy(istream, ostream);
            try {
                istream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    void setErrorReportValve(Valve errorReportValve) {
        this.errorReportValve = errorReportValve;
    }
}

