/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.ArithmeticFunctionNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class LocateNode
extends ArithmeticFunctionNode {
    private Node find = null;
    private Node findIn = null;
    private Node startPosition = null;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.findIn != null) {
            this.findIn.validate(context);
            this.findIn.validateParameter(context, typeHelper.getStringType());
        }
        if (this.find != null) {
            this.find.validate(context);
            this.find.validateParameter(context, typeHelper.getStringType());
        }
        if (this.startPosition != null) {
            this.startPosition.validate(context);
            this.startPosition.validateParameter(context, typeHelper.getIntType());
        }
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getFindIn().generateExpression(context);
        Expression findExpr = this.getFind().generateExpression(context);
        whereClause = this.startPosition != null ? whereClause.locate(findExpr, this.getStartPosition().generateExpression(context)) : whereClause.locate(findExpr);
        return whereClause;
    }

    public Node getFind() {
        return this.find;
    }

    public Node getFindIn() {
        return this.findIn;
    }

    public void setFind(Node newFind) {
        this.find = newFind;
    }

    public void setFindIn(Node newFindIn) {
        this.findIn = newFindIn;
    }

    public Node getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(Node newStartPosition) {
        this.startPosition = newStartPosition;
    }
}

