/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.ModelTypeMap;
import com.iplanet.jato.ModelTypeMapBase;
import com.iplanet.jato.RequestCompletionListener;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.ClassUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class ModelManager
implements RequestCompletionListener {
    private Map instanceMap = new HashMap();
    private RequestContext requestContext;
    private ModelTypeMap typeMap = null;
    private List sessionableModels = new LinkedList();

    public ModelManager(RequestContext requestContext) {
        this(requestContext, null);
    }

    public ModelManager(RequestContext requestContext, ModelTypeMap typeMap) {
        if (requestContext == null) {
            throw new IllegalArgumentException("Parameter \"requestContext\" cannot be null");
        }
        if (typeMap == null) {
            typeMap = new ModelTypeMapBase();
        }
        this.requestContext = requestContext;
        this.typeMap = typeMap;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    public Model getModel(String className) throws ClassNotFoundException {
        Class clazz = ClassUtil.getClass(className);
        return this.getModel(clazz);
    }

    public Model getModel(String className, String instanceName) throws ClassNotFoundException {
        Class clazz = ClassUtil.getClass(className);
        return this.getModel(clazz, instanceName);
    }

    public Model getModel(String className, String instanceName, boolean lookInSession) throws ClassNotFoundException {
        Class clazz = ClassUtil.getClass(className);
        return this.getModel(clazz, instanceName, lookInSession);
    }

    public Model getModel(String className, String instanceName, boolean lookInSession, boolean storeInSession) throws ClassNotFoundException {
        Class clazz = ClassUtil.getClass(className);
        return this.getModel(clazz, instanceName, lookInSession, storeInSession);
    }

    public Model getModel(Class modelClass) {
        return this.getModel(modelClass, this.getDefaultModelInstanceName(modelClass), false);
    }

    public Model getModel(Class modelClass, String instanceName) {
        return this.getModel(modelClass, instanceName, false);
    }

    public Model getModel(Class modelClass, String instanceName, boolean lookInSession) {
        return this.getModel(modelClass, instanceName, lookInSession, false);
    }

    public Model getModel(Class modelClass, String instanceName, boolean lookInSession, boolean storeInSession) {
        Model model = null;
        model = (Model)this.instanceMap.get(instanceName);
        if (model == null) {
            if (lookInSession) {
                model = (Model)this.getRequestContext().getRequest().getSession(true).getAttribute(instanceName);
            }
            if (model == null) {
                Class implClass = this.typeMap.getModelImplClass(modelClass);
                if (implClass == null) {
                    throw new Error("Implementation class for model interface \"" + modelClass + "\" not found in type map");
                }
                try {
                    model = (Model)implClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new Error("Error insantiating class \"" + implClass.getName() + "\": " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new Error("Error accessing class \"" + implClass.getName() + "\": " + e.getMessage());
                }
            }
            this.instanceMap.put(instanceName, model);
            model.setName(instanceName);
            if (model instanceof RequestParticipant) {
                ((RequestParticipant)((Object)model)).setRequestContext(this.requestContext);
            }
            if (model instanceof RequestCompletionListener) {
                this.requestContext.addRequestCompletionListener((RequestCompletionListener)((Object)model));
            }
            if (storeInSession) {
                this.addToSession(model);
            }
        }
        return model;
    }

    public void addToSession(Model model) {
        if (this.sessionableModels.size() == 0) {
            this.getRequestContext().addRequestCompletionListener(this);
        }
        this.sessionableModels.add(model);
    }

    public void removeFromSession(Model model) {
        this.sessionableModels.remove(model);
        HttpSession session = this.getRequestContext().getRequest().getSession(true);
        session.removeAttribute(model.getName());
    }

    public ModelTypeMap getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(ModelTypeMap value) {
        this.typeMap = value;
    }

    public String getDefaultModelInstanceName(String modelClassName) {
        return modelClassName;
    }

    public String getDefaultModelInstanceName(Class modelClass) {
        return this.getDefaultModelInstanceName(modelClass.getName());
    }

    public final void notifyRequestCompletionListeners() {
    }

    public void requestComplete() {
        HttpSession session = this.getRequestContext().getRequest().getSession(false);
        if (session == null) {
            return;
        }
        Iterator i = this.sessionableModels.iterator();
        while (i.hasNext()) {
            Model model = (Model)i.next();
            String name = model.getName();
            if (name == null) {
                name = this.getDefaultModelInstanceName(model.getClass());
                model.setName(name);
            }
            session.setAttribute(name, (Object)model);
        }
    }
}

