/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelFieldGroup;

public abstract class DatasetModelBase
implements DatasetModel {
    public static final int LOCATION_BEFORE_FIRST = -1;
    private String name;
    private ModelFieldGroup fieldGroup;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ModelFieldGroup getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(ModelFieldGroup value) {
        this.fieldGroup = value;
    }

    public abstract int getSize() throws ModelControlException;

    public abstract void setSize(int var1) throws ModelControlException;

    public abstract int getLocationOffset();

    public abstract int getLocation() throws ModelControlException;

    public abstract void setLocation(int var1) throws ModelControlException;

    public void beforeFirst() throws ModelControlException {
        this.setLocation(-1);
    }

    public boolean first() throws ModelControlException {
        int maxLength = this.getSize();
        if (maxLength > 0) {
            this.setLocation(0);
            return true;
        }
        this.setLocation(-1);
        return false;
    }

    public boolean next() throws ModelControlException {
        int maxLength = this.getSize();
        if (maxLength == 0) {
            return false;
        }
        int index = this.getLocation() + 1;
        if (index < maxLength) {
            this.setLocation(index);
            return true;
        }
        return false;
    }

    public boolean previous() throws ModelControlException {
        int maxLength = this.getSize();
        if (maxLength == 0) {
            return false;
        }
        int index = this.getLocation() - 1;
        if (index >= -1) {
            this.setLocation(index);
            return true;
        }
        return false;
    }

    public boolean last() throws ModelControlException {
        int maxLength = this.getSize();
        if (maxLength == 0) {
            return false;
        }
        this.setLocation(maxLength - 1);
        return true;
    }

    public abstract Object getValue(String var1);

    public abstract Object[] getValues(String var1);

    public abstract void setValue(String var1, Object var2);

    public abstract void setValues(String var1, Object[] var2);

    static {
        LOCATION_BEFORE_FIRST = -1;
    }
}

