/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.html;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.taglib.AbstractVisualTag;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.CommandSourceTargetPair;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.Button;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.iplanet.jato.view.html.StaticTextField;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;

public class ButtonTag
extends AbstractVisualTag {
    static /* synthetic */ Class class$com$iplanet$jato$view$CommandField;

    protected void generateTagContent(NonSyncStringBuffer buffer) throws JspException {
        ContainerView parentContainer = this.getParentContainerView();
        View child = parentContainer.getChild(this.getName());
        this.checkChildType(child, class$com$iplanet$jato$view$CommandField == null ? (class$com$iplanet$jato$view$CommandField = ButtonTag.class$("com.iplanet.jato.view.CommandField")) : class$com$iplanet$jato$view$CommandField);
        CommandField field = (CommandField)child;
        Object value = field.getValue();
        if (value == null) {
            value = this.getDefaultValue();
        }
        if (value == null) {
            value = "Submit";
        }
        buffer.append("<input");
        if (this.getSrc() != null) {
            buffer.append(" type=\"image\" src=\"").append(this.getSrc()).append("\"");
        } else {
            buffer.append(" type=\"submit\"");
        }
        buffer.append(" name=\"").append(field.getQualifiedName()).append("\" value=\"").append(HtmlUtil.escapeQuotes(value.toString())).append("\"");
        this.appendCommonHtmlAttributes(buffer);
        this.appendJavaScriptAttributes(buffer);
        this.appendStyleAttributes(buffer);
        if (field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)((Object)field), buffer);
        }
        buffer.append(">");
        this.appendExtraValues(field, buffer);
    }

    protected void appendExtraValues(CommandField field, NonSyncStringBuffer buffer) throws JspException {
        Map values = field.getExtraValuesMap();
        if (values == null) {
            return;
        }
        this.addSourceTargetValues(field, values);
        if (values.size() == 0) {
            return;
        }
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = values.get(key);
            if (value == null) continue;
            buffer.append("<input type=\"hidden\" name=\"");
            buffer.append(key);
            buffer.append("\" value=\"");
            buffer.append(value.toString());
            buffer.append("\">");
        }
    }

    private void addSourceTargetValues(CommandField field, Map extraValues) throws JspException {
        if (field.getCommandFieldDescriptor() == null) {
            return;
        }
        CommandSourceTargetPair[] pairs = field.getCommandFieldDescriptor().getSourceTargetPairs();
        int i = 0;
        while (i < pairs.length) {
            CommandSourceTargetPair nextPair = pairs[i];
            String strValue = "";
            String[] sourcePath = nextPair.getSourcePath();
            boolean skipValue = true;
            switch (nextPair.getSourceType()) {
                case 1: 
                case 2: {
                    Model sourceModel = this.getParentViewBean().getModel(nextPair.getSourceClass());
                    Object objValue = sourceModel.getValue(sourcePath[1]);
                    if (objValue != null) {
                        strValue = objValue.toString();
                    }
                    skipValue = false;
                    break;
                }
                case 3: {
                    DisplayField child = this.getDisplayField(sourcePath);
                    if (!(child instanceof StaticTextField)) break;
                    strValue = ((StaticTextField)child).stringValue();
                    skipValue = false;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (!skipValue) {
                extraValues.put(Button.getSourceTargetParameterName(field.getName(), i), strValue);
            }
            ++i;
        }
    }

    private DisplayField getDisplayField(String[] namePath) throws JspException {
        ContainerView parentView = this.getParentViewBean();
        int j = 1;
        while (j < namePath.length - 1) {
            parentView = (ContainerView)parentView.getChild(namePath[j]);
            ++j;
        }
        return (DisplayField)parentView.getChild(namePath[namePath.length - 1]);
    }

    public String getSrc() {
        return (String)this.getValue("src");
    }

    public void setSrc(String value) {
        this.setValue("src", value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

