/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.provider.ASInputStream;
import com.sun.enterprise.server.ss.provider.ASOutputStream;
import com.sun.enterprise.server.ss.spi.ASSocketFacadeUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class ASClientSocketImpl
extends SocketImpl {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private SocketChannel sc;
    private Socket sock;
    private InputStream is;

    ASClientSocketImpl() {
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        if (this.sock != null) {
            block8: {
                block7: {
                    try {
                        this.sock.shutdownOutput();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINER)) break block7;
                        logger.log(Level.FINER, "" + e.getMessage(), e);
                    }
                }
                try {
                    this.sock.close();
                    this.sc.close();
                }
                catch (IOException ie) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "" + ie.getMessage(), ie);
                    }
                }
                catch (Error er) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, "" + er.getMessage(), er);
                }
            }
            this.is = null;
        }
    }

    public int getLocalPort() {
        try {
            return this.getClientSocket().getLocalPort();
        }
        catch (IOException ie) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "" + ie.getMessage(), ie);
            }
            return super.getLocalPort();
        }
    }

    public int getPort() {
        try {
            return this.getClientSocket().getPort();
        }
        catch (IOException ie) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "" + ie.getMessage(), ie);
            }
            return super.getPort();
        }
    }

    public void shutdownInput() throws IOException {
        this.getClientSocket().shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.getClientSocket().shutdownOutput();
    }

    public boolean supportsUrgentData() {
        return true;
    }

    public void sendUrgentData(int i) throws IOException {
        this.getClientSocket().sendUrgentData(i);
    }

    public void listen(int i) throws IOException {
        throw new UnsupportedOperationException("listen() not supported in ASClientSocketImpl");
    }

    public void create(boolean stream) throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new ASInputStream(this.getClientSocketChannel(), this.getClientSocket());
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        return new ASOutputStream(this.getClientSocketChannel(), this.getClientSocket());
    }

    public void bind(InetAddress ia, int port) throws IOException {
        InetSocketAddress isa = new InetSocketAddress(ia, port);
        this.getClientSocket().bind(isa);
    }

    public void connect(String host, int port) throws IOException {
        InetSocketAddress isa = new InetSocketAddress(host, port);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASClientSocketImpl.connect, host = " + host + " port = " + port);
        }
        this.connect(isa);
    }

    public void connect(InetAddress ia, int port) throws IOException {
        InetSocketAddress isa = new InetSocketAddress(ia, port);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASClientSocketImpl.connect, host = " + ia.getHostName() + " port = " + port);
        }
        this.connect(isa);
    }

    private void connect(InetSocketAddress isa) throws IOException {
        this.connect(isa, 0);
    }

    public void connect(SocketAddress sa, int timeout) throws IOException {
        if (sa == null || !(sa instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress addr = (InetSocketAddress)sa;
        if (addr.isUnresolved()) {
            throw new UnknownHostException(addr.getHostName());
        }
        this.port = addr.getPort();
        this.address = addr.getAddress();
        boolean waitForStartupReqd = !ASSocketFacadeUtils.getASSocketService().socketServiceNotified(this.port);
        SocketChannel ch = this.getClientSocketChannel();
        boolean connected = ch.connect(sa);
        if (!connected) {
            this.waitForSelect(timeout);
            if (!ch.finishConnect()) {
                throw new IOException("Connection timed out");
            }
        }
        Socket connectedSocket = this.sc.socket();
        if (waitForStartupReqd) {
            ASSocketFacadeUtils.getASSocketService().waitOnClientConnection(connectedSocket);
        }
        ASSocketFacadeUtils.getASSocketService().clientSocketConnected(this.sc.socket());
    }

    public void accept(SocketImpl si) throws IOException {
        throw new UnsupportedOperationException("accept() not supported in ASClientSocketImpl");
    }

    public void setOption(int opt, Object val) throws SocketException {
        try {
            switch (opt) {
                case 128: {
                    if (val == null || !(val instanceof Integer) && !(val instanceof Boolean)) {
                        throw new SocketException("Bad parameter for option");
                    }
                    if (val instanceof Boolean) {
                        if (((Boolean)val).booleanValue()) {
                            throw new SocketException("Bad parameter for option");
                        }
                        this.getClientSocket().setSoLinger(false, 0);
                        break;
                    }
                    this.getClientSocket().setSoLinger(true, (Integer)val);
                    break;
                }
                case 4102: {
                    if (val == null || !(val instanceof Integer)) {
                        throw new SocketException("Bad parameter for SO_TIMEOUT");
                    }
                    int tmp = (Integer)val;
                    if (tmp < 0) {
                        throw new IllegalArgumentException("timeout < 0");
                    }
                    this.getClientSocket().setSoTimeout(tmp);
                    break;
                }
                case 3: {
                    if (val == null || !(val instanceof Integer)) {
                        throw new SocketException("bad argument for IP_TOS");
                    }
                    int trafficClass = (Integer)val;
                    this.getClientSocket().setTrafficClass(trafficClass);
                    break;
                }
                case 15: {
                    throw new SocketException("Cannot re-bind socket");
                }
                case 1: {
                    if (val == null || !(val instanceof Boolean)) {
                        throw new SocketException("bad parameter for TCP_NODELAY");
                    }
                    this.getClientSocket().setTcpNoDelay((Boolean)val);
                    break;
                }
                case 4097: {
                    if (val == null || !(val instanceof Integer) || (Integer)val <= 0) {
                        throw new SocketException("bad parameter for SO_SNDBUF ");
                    }
                    this.getClientSocket().setSendBufferSize((Integer)val);
                    break;
                }
                case 4098: {
                    if (val == null || !(val instanceof Integer) || (Integer)val <= 0) {
                        throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
                    }
                    this.getClientSocket().setReceiveBufferSize((Integer)val);
                    break;
                }
                case 8: {
                    if (val == null || !(val instanceof Boolean)) {
                        throw new SocketException("bad parameter for SO_KEEPALIVE");
                    }
                    this.getClientSocket().setKeepAlive((Boolean)val);
                    break;
                }
                case 4099: {
                    if (val == null || !(val instanceof Boolean)) {
                        throw new SocketException("bad parameter for SO_OOBINLINE");
                    }
                    this.getClientSocket().setOOBInline((Boolean)val);
                    break;
                }
                case 4: {
                    if (val == null || !(val instanceof Boolean)) {
                        throw new SocketException("bad parameter for SO_REUSEADDR");
                    }
                    this.getClientSocket().setReuseAddress((Boolean)val);
                    break;
                }
                default: {
                    throw new SocketException("unrecognized TCP option: " + opt);
                }
            }
        }
        catch (IOException ioex) {
            if (ioex instanceof SocketException) {
                throw (SocketException)ioex;
            }
            throw (SocketException)new SocketException().initCause(ioex);
        }
    }

    public Object getOption(int opt) throws SocketException {
        switch (opt) {
            case 128: {
                return new Integer(this.sock.getSoLinger());
            }
            case 4102: {
                return new Integer(this.sock.getSoTimeout());
            }
            case 3: {
                return new Integer(this.sock.getTrafficClass());
            }
            case 15: {
                return this.sock.getInetAddress();
            }
            case 1: {
                return new Boolean(this.sock.getTcpNoDelay());
            }
            case 4097: {
                return new Integer(this.sock.getSendBufferSize());
            }
            case 4098: {
                return new Integer(this.sock.getReceiveBufferSize());
            }
            case 8: {
                return new Boolean(this.sock.getKeepAlive());
            }
            case 4099: {
                return new Boolean(this.sock.getOOBInline());
            }
            case 4: {
                return new Boolean(this.sock.getReuseAddress());
            }
        }
        throw new SocketException("unrecognized TCP option: " + opt);
    }

    private Socket getClientSocket() throws IOException {
        if (this.sock == null) {
            this.createSocket();
        }
        return this.sock;
    }

    private SocketChannel getClientSocketChannel() throws IOException {
        if (this.sc == null) {
            this.createSocket();
        }
        return this.sc;
    }

    private void createSocket() throws IOException {
        this.sc = SocketChannel.open();
        this.sc.configureBlocking(false);
        this.sock = this.sc.socket();
    }

    private void waitForSelect(long timeout) throws IOException {
        block7: {
            Selector selector;
            block6: {
                selector = Selector.open();
                this.sc.register(selector, 8);
                try {
                    int n;
                    while ((n = selector.select(timeout)) != 0 || !this.sc.finishConnect()) {
                        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            SelectionKey selKey = it.next();
                            if (!selKey.isValid() || !selKey.isConnectable()) continue;
                            it.remove();
                            break block6;
                        }
                    }
                }
                catch (Exception e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
            try {
                selector.close();
            }
            catch (IOException ie) {
                if (!logger.isLoggable(Level.FINE)) break block7;
                logger.log(Level.FINE, ie.getMessage(), ie);
            }
        }
    }

    void setClientSocket(Socket s) throws IOException {
        this.sock = s;
        this.sc = this.sock.getChannel();
        this.sc.configureBlocking(false);
        this.localport = this.sock.getLocalPort();
        this.port = this.sock.getPort();
        this.address = this.sock.getInetAddress();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

