/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCNavigationModelInterface;
import java.util.ArrayList;
import java.util.List;

public abstract class CCNavigationModel
extends DefaultModel
implements CCNavigationModelInterface {
    protected List nodes = null;
    protected CCNavNodeInterface selectedNode = null;

    public void addNode(CCNavNodeInterface node) {
        this.getNodes().add(node);
    }

    public boolean removeNode(CCNavNodeInterface node) {
        int index = this.getNodes().indexOf(node);
        if (index < 0) {
            return false;
        }
        this.getNodes().remove(index);
        return true;
    }

    public CCNavNodeInterface getSelectedNode() {
        if (this.selectedNode != null && !this.containsNode(this.selectedNode)) {
            this.selectedNode = null;
        }
        return this.selectedNode;
    }

    public void setSelectedNode(CCNavNodeInterface node) {
        this.selectedNode = node;
    }

    public void setSelectedNode(int id) {
        this.setSelectedNode(this.getNodeById(id));
    }

    public CCNavNodeInterface getNodeById(int id) {
        CCNavNodeInterface node = null;
        List nodes = this.getNodes();
        int numNodes = this.getNodes().size();
        for (int i = 0; i < numNodes && (node = ((CCNavNodeInterface)nodes.get(i)).hasDescendant(id)) == null; ++i) {
        }
        return node;
    }

    public void removeAllNodes() {
        this.nodes = new ArrayList();
        this.selectedNode = null;
    }

    public List getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
        }
        return this.nodes;
    }

    public void setNodes(List nodes) {
        this.nodes = nodes;
    }

    public int getNodeCount() {
        int size;
        List nodes = this.getNodes();
        int numNodes = size = nodes.size();
        for (int i = 0; i < size; ++i) {
            numNodes += ((CCNavNodeInterface)nodes.get(i)).getNumDescendants();
        }
        return numNodes;
    }

    protected boolean containsNode(CCNavNodeInterface aNode) {
        CCNavNodeInterface node;
        List nodes = this.getNodes();
        int size = nodes.size();
        boolean found = false;
        for (int i = 0; i < size && !(found = (node = (CCNavNodeInterface)nodes.get(i)).isNodeDescendant(aNode)); ++i) {
        }
        return found;
    }

    public int getMaxDepth() {
        int maxDepth = -1;
        int depth = -1;
        int size = this.getNodes().size();
        for (int i = 0; i < size; ++i) {
            depth = this.findMaxDepth((CCNavNodeInterface)this.getNodes().get(i));
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private int findMaxDepth(CCNavNodeInterface node) {
        int depth = node.getLevel();
        int newDepth = 0;
        int size = node.getChildren().size();
        for (int i = 0; i < size; ++i) {
            newDepth = this.findMaxDepth((CCNavNodeInterface)node.getChildren().get(i));
            if (newDepth <= depth) continue;
            depth = newDepth;
        }
        return depth;
    }

    public int getVisibleMaxDepth() {
        int visibleMaxDepth = -1;
        int size = this.getNodes().size();
        for (int i = 0; i < size; ++i) {
            int curDepth = this.findMaxVisibleDepth((CCNavNodeInterface)this.getNodes().get(i));
            if (curDepth <= visibleMaxDepth) continue;
            visibleMaxDepth = curDepth;
        }
        return visibleMaxDepth;
    }

    private int findMaxVisibleDepth(CCNavNodeInterface node) {
        int visibleDepth = node.getLevel();
        int newVisibleDepth = 0;
        if (node.getExpanded() || node.isRoot()) {
            int size = node.getChildren().size();
            for (int i = 0; i < size; ++i) {
                newVisibleDepth = this.findMaxVisibleDepth((CCNavNodeInterface)node.getChildren().get(i));
                if (newVisibleDepth <= visibleDepth) continue;
                visibleDepth = newVisibleDepth;
            }
        }
        return visibleDepth;
    }
}

