/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCManageChild;
import com.sun.web.ui.taglib.common.CCDisplayFieldTagBase;
import com.sun.web.ui.taglib.html.CCImageTag;
import com.sun.web.ui.taglib.html.CCLabelTag;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCOptionImage;
import com.sun.web.ui.view.html.CCRadioButton;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCRadioButtonTag
extends CCDisplayFieldTagBase {
    protected static final String ATTRIB_DYNAMIC = "dynamic";
    protected static final String ATTRIB_LAYOUT = "layout";
    protected static final String ATTRIB_STYLE_LEVEL = "styleLevel";
    protected static final String ATTRIB_TITLE = "title";
    protected static final String ATTRIB_TITLE_DISABLED = "titleDisabled";
    protected static final String ATTRIB_ESCAPE = "escape";
    protected static final String ATTRIB_LABELFORNONESELECTED = "labelForNoneSelected";
    private SelectableGroup field = null;
    private boolean noneSelected = true;

    public void reset() {
        super.reset();
        this.field = null;
        this.noneSelected = true;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, SelectableGroup.class);
        this.field = (SelectableGroup)view;
        if (this.field instanceof CCManageChild) {
            ((CCManageChild)this.field).beginDisplay();
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        this.appendOptions(buffer);
        NonSyncStringBuffer tmpBuffer = new NonSyncStringBuffer();
        this.appendNoneSelectedOption(tmpBuffer, this.noneSelected);
        buffer.insert(0, tmpBuffer.toString());
        if (this.isTrue(this.getDynamic())) {
            this.appendHiddenFields(buffer);
            this.includeDynamicJS();
        }
        return buffer.toString();
    }

    private void appendHiddenFields(NonSyncStringBuffer buffer) throws JspException {
        if (!(this.field instanceof CCRadioButton)) {
            return;
        }
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "ValueDisabledHiddenField", this.getValue()));
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "DisabledHiddenField", this.getDisabled()));
        if (this.getTitleDisabled() == null) {
            return;
        }
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "TitleEnabledHiddenField", this.getMessage(this.getTitle())));
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "TitleDisabledHiddenField", this.getMessage(this.getTitleDisabled())));
    }

    private void appendLabel(NonSyncStringBuffer buffer, String value, String elementId) throws JspException {
        String html;
        CCLabel child = new CCLabel((ContainerView)this.field.getParent(), this.field.getName() + ".Label", null);
        CCLabelTag ccLabelTag = new CCLabelTag();
        child.setValue(value);
        ccLabelTag.setBundleID(this.getBundleID());
        ccLabelTag.setStyleLevel(this.getStyleLevel());
        ccLabelTag.setElementId(elementId != null ? elementId : this.field.getQualifiedName());
        if (this.getEscape() != null) {
            ccLabelTag.setEscape(this.getEscape());
        }
        buffer.append((html = ccLabelTag.getHTMLString(this.getParent(), this.pageContext, (View)child)) != null ? html : "");
    }

    private void appendNoneSelectedOption(NonSyncStringBuffer buffer, boolean noneSelected) throws JspException {
        if (this.getLabelForNoneSelected() != null) {
            this.appendOpeningTag(buffer, "", this.getElementId());
            if (noneSelected) {
                CCRadioButtonTag.appendAttribute(buffer, "checked", "checked");
            }
            buffer.append(" />");
            String elementId = this.getElementId() != null ? this.getElementId() : this.field.getQualifiedName();
            this.appendLabel(buffer, this.getLabelForNoneSelected(), elementId);
            if (!this.isHorizontalLayout()) {
                buffer.append("<br />");
            }
            buffer.append("\n");
        }
    }

    private void appendOpeningTag(NonSyncStringBuffer buffer, String value, String elementId) {
        buffer.append("<input");
        CCRadioButtonTag.appendAttribute(buffer, "type", "radio");
        CCRadioButtonTag.appendAttribute(buffer, "name", this.field.getQualifiedName());
        CCRadioButtonTag.appendAttribute(buffer, "id", elementId);
        CCRadioButtonTag.appendAttribute(buffer, "value", value);
        CCRadioButtonTag.appendAttribute(buffer, ATTRIB_TITLE, this.isTrue(this.getDisabled()) && this.getTitleDisabled() != null ? this.getMessage(this.getTitleDisabled()) : this.getMessage(this.getTitle()));
        if (this.isGecko()) {
            CCRadioButtonTag.appendAttribute(buffer, "class", this.isTrue(this.getDisabled()) ? "RbDis" : "Rb");
        }
    }

    private void appendOptions(NonSyncStringBuffer buffer) throws JspException {
        this.addAutoSubmitJavascript();
        Option[] options = this.field.getOptions().toOptionArray();
        for (int i = 0; i < options.length; ++i) {
            String elementId;
            boolean isSelected = this.field.isSelected(options[i].getValue());
            if (isSelected) {
                this.noneSelected = false;
            }
            String string = elementId = this.getElementId() != null ? this.getElementId() : this.field.getQualifiedName();
            if (this.getLabelForNoneSelected() != null) {
                elementId = elementId + (i + 2);
            } else if (i > 0) {
                elementId = elementId + (i + 1);
            }
            this.appendOpeningTag(buffer, options[i].getValue(), elementId);
            if (isSelected) {
                CCRadioButtonTag.appendAttribute(buffer, "checked", "checked");
            }
            this.appendCommonHtmlAttributes(buffer);
            this.appendJavaScriptAttributes(buffer);
            if (this.field instanceof HtmlDisplayField) {
                this.appendExtraHtml((HtmlDisplayField)this.field, buffer);
            }
            buffer.append(" />");
            this.appendOptionImage(buffer, options[i]);
            if (options[i].getLabel() != null) {
                this.appendLabel(buffer, options[i].getLabel(), elementId);
            }
            if (!this.isHorizontalLayout() && i + 1 < options.length) {
                buffer.append("<br />");
            }
            if (i + 1 >= options.length) continue;
            buffer.append("\n");
        }
    }

    private void appendOptionImage(NonSyncStringBuffer buffer, Option option) throws JspException {
        if (!(option instanceof CCOptionImage)) {
            return;
        }
        ContainerView view = (ContainerView)this.field.getParent();
        View child = view != null ? view.getChild(((CCOptionImage)option).getName()) : null;
        buffer.append(new CCImageTag().getHTMLString(this.getParent(), this.pageContext, child));
    }

    private void addAutoSubmitJavascript() {
        if (this.isIe() || this.isNav4()) {
            return;
        }
        String keyCode = this.isNav() ? "event.which" : "event.keyCode";
        NonSyncStringBuffer buffer = new NonSyncStringBuffer("javascript: ");
        if (this.getOnKeyPress() != null) {
            buffer.append(this.getOnKeyPress()).append(";");
        }
        buffer.append(" if (").append(keyCode).append(" == 13) return false");
        this.setOnKeyPress(buffer.toString());
    }

    private String getValue() {
        return this.field.getValue() != null ? this.field.getValue().toString() : "";
    }

    private boolean isHorizontalLayout() throws JspException {
        return this.getLayout() != null && this.getLayout().startsWith("h");
    }

    protected void setAttributes() {
        if (this.field.getLabelForNoneSelected() != null && this.field.getLabelForNoneSelected().length() > 0) {
            this.setLabelForNoneSelected(this.field.getLabelForNoneSelected());
        }
        if (this.field instanceof CCRadioButton) {
            CCRadioButton child = (CCRadioButton)this.field;
            if (child.getDisabled() != null) {
                this.setDisabled(child.getDisabled().toString());
            }
            if (child.getDynamic() != null) {
                this.setDynamic(child.getDynamic().toString());
            }
            if (child.getElementId() != null) {
                this.setElementId(child.getElementId());
            }
            if (child.getLayout() != null) {
                this.setLayout(child.getLayout());
            }
            if (child.getStyleLevel() != null) {
                this.setStyleLevel(child.getStyleLevel());
            }
            if (child.getTitle() != null) {
                this.setTitle(child.getTitle());
            }
            if (child.getTitleDisabled() != null) {
                this.setTitleDisabled(child.getTitleDisabled());
            }
            if (child.getEscape() != null) {
                this.setEscape(child.getEscape().toString());
            }
        }
        this.noneSelected = true;
    }

    public String getDynamic() {
        return (String)this.getValue(ATTRIB_DYNAMIC);
    }

    public void setDynamic(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_DYNAMIC, value);
    }

    public String getLayout() {
        return (String)this.getValue(ATTRIB_LAYOUT);
    }

    public void setLayout(String value) {
        if (value != null && !value.equals("horizontal") && !value.equals("vertical")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_LAYOUT, value);
    }

    public String getLabelForNoneSelected() {
        return (String)this.getValue(ATTRIB_LABELFORNONESELECTED);
    }

    public void setLabelForNoneSelected(String value) {
        this.setValue(ATTRIB_LABELFORNONESELECTED, value);
    }

    public String getStyleLevel() {
        return this.getValue(ATTRIB_STYLE_LEVEL) != null ? (String)this.getValue(ATTRIB_STYLE_LEVEL) : "2";
    }

    public void setStyleLevel(String value) {
        if (!(value == null || value.equals("1") || value.equals("2") || value.equals("3"))) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_STYLE_LEVEL, value);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIB_TITLE);
    }

    public void setTitle(String value) {
        this.setValue(ATTRIB_TITLE, value);
    }

    public String getTitleDisabled() {
        return (String)this.getValue(ATTRIB_TITLE_DISABLED);
    }

    public void setTitleDisabled(String value) {
        this.setValue(ATTRIB_TITLE_DISABLED, value);
    }

    public String getEscape() {
        return (String)this.getValue(ATTRIB_ESCAPE);
    }

    public void setEscape(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_ESCAPE, value);
    }
}

