/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.ServiceEntry;
import com.sun.messaging.jmq.io.ServiceTable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class ClusterDiscoveryProtocol {
    public static final int CLUSTER_DISCOVERY_VERSION = 210;
    public static final String SERVICE_NAME = "cluster_discovery";
    public static final String END_TOKEN = "END\r\n";
    public static final String VERSION = "version";
    public static final String OPERATION_TYPE = "operation_type";
    public static final String BROKER_NAME = "broker_name";
    public static final String BROKER_VERSION = "broker_version";
    public static final String ACTIVE_BROKER = "active_broker";
    public static final String REMOTE_SERVICES = "remote_services";
    public static final String LOCAL_SERVICES = "local_services";

    public static void sendRequest(OutputStream outputStream) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(VERSION, Integer.toString(210));
        properties.setProperty(OPERATION_TYPE, "REQUEST");
        properties.save(outputStream, null);
        outputStream.write(END_TOKEN.getBytes("ASCII"));
        outputStream.flush();
    }

    public static Properties receiveRequest(InputStream inputStream) throws IOException {
        return ClusterDiscoveryProtocol.receivePacket(inputStream);
    }

    public static void sendResponse(ServiceTable serviceTable, OutputStream outputStream) throws IOException {
        String string;
        Enumeration<Object> enumeration;
        Hashtable hashtable;
        Properties properties = new Properties();
        properties.setProperty(VERSION, Integer.toString(210));
        properties.setProperty(OPERATION_TYPE, "RESPONSE");
        properties.setProperty(BROKER_NAME, serviceTable.getBrokerInstanceName());
        properties.setProperty(BROKER_VERSION, serviceTable.getBrokerVersion());
        String string2 = serviceTable.getActiveBroker();
        if (string2 != null) {
            properties.setProperty(ACTIVE_BROKER, string2);
        }
        if ((hashtable = serviceTable.getRemoteServices()).size() > 0) {
            enumeration = hashtable.keys();
            string = (String)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                string = string + "," + enumeration.nextElement();
            }
            properties.setProperty(REMOTE_SERVICES, string);
        }
        enumeration = serviceTable.getServices().elements();
        string = null;
        while (enumeration.hasMoreElements()) {
            ServiceEntry serviceEntry = (ServiceEntry)enumeration.nextElement();
            String string3 = "local." + serviceEntry.getName();
            properties.setProperty(string3 + ".type", serviceEntry.getType());
            properties.setProperty(string3 + ".protocol", serviceEntry.getProtocol());
            properties.setProperty(string3 + ".address", serviceEntry.getAddress());
            if (string == null) {
                string = serviceEntry.getName();
                continue;
            }
            string = string + "," + serviceEntry.getName();
        }
        if (string != null) {
            properties.setProperty(LOCAL_SERVICES, string);
        }
        properties.save(outputStream, null);
        outputStream.write(END_TOKEN.getBytes("ASCII"));
        outputStream.flush();
    }

    public static ServiceTable receiveResponse(InputStream inputStream) throws IOException {
        String string;
        StringTokenizer stringTokenizer;
        Properties properties = ClusterDiscoveryProtocol.receivePacket(inputStream);
        ServiceTable serviceTable = new ServiceTable();
        serviceTable.setBrokerInstanceName(properties.getProperty(BROKER_NAME));
        serviceTable.setBrokerVersion(properties.getProperty(BROKER_VERSION));
        String string2 = properties.getProperty(ACTIVE_BROKER);
        if (string2 != null) {
            serviceTable.setActiveBroker(string2);
        }
        if ((string2 = properties.getProperty(REMOTE_SERVICES)) != null) {
            stringTokenizer = new StringTokenizer(string2, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                serviceTable.addRemoteService(string);
            }
        }
        if ((string2 = properties.getProperty(LOCAL_SERVICES)) != null) {
            stringTokenizer = new StringTokenizer(string2, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                String string3 = "local." + string;
                String string4 = properties.getProperty(string3 + ".type");
                String string5 = properties.getProperty(string3 + ".protocol");
                String string6 = properties.getProperty(string3 + ".address");
                ServiceEntry serviceEntry = new ServiceEntry();
                serviceEntry.setName(string);
                serviceEntry.setType(string4);
                serviceEntry.setProtocol(string5);
                serviceEntry.setAddress(string6);
                serviceTable.add(serviceEntry);
            }
        }
        return serviceTable;
    }

    private static Properties receivePacket(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[5];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            int n;
            if ((n = bufferedInputStream.read()) == -1) {
                throw new IOException("Premature end of input stream");
            }
            byteArrayOutputStream.write(n);
            if (n != 10) continue;
            int n2 = bufferedInputStream.read(byArray);
            if (n2 < byArray.length) {
                throw new IOException("Premature end of input stream");
            }
            if (byArray[0] == 69 && byArray[1] == 78 && byArray[2] == 68 && byArray[3] == 13 && byArray[4] == 10) break;
            byteArrayOutputStream.write(byArray);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        properties.load(byteArrayInputStream);
        int n = 0;
        try {
            n = Integer.parseInt(properties.getProperty(VERSION));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == 0 || n > 210) {
            throw new IOException("Bad cluster discovery version number: " + n + " Expecting: " + 210);
        }
        return properties;
    }
}

