/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.JMSException;

public abstract class ConsumerReader
implements Runnable,
Traceable {
    protected Thread sessionThread = null;
    protected ProtocolHandler protocolHandler = null;
    protected ConnectionImpl connection = null;
    protected SessionQueue sessionQueue = null;
    protected boolean isSuspended = false;
    protected boolean isAlive = false;
    protected boolean isPaused = false;
    protected static int nextReaderID = 0;
    protected int readerID = 0;
    protected static final String imqConsumerReader = "imqConsumerReader-";
    private boolean messageSuspended = false;
    MessageImpl currentMessage = null;
    protected boolean debug = Debug.debug;
    protected long timeout = 0L;

    public ConsumerReader(ConnectionImpl connectionImpl, SessionQueue sessionQueue) {
        this.connection = connectionImpl;
        this.sessionQueue = sessionQueue;
        this.readerID = ConsumerReader.getNextReaderID();
        this.init();
    }

    protected static synchronized int getNextReaderID() {
        return nextReaderID++;
    }

    protected void setTimeout(long l) {
        this.timeout = l;
    }

    public void init() {
        this.protocolHandler = this.connection.getProtocolHandler();
    }

    public synchronized void start() {
        if (this.sessionThread == null) {
            if (this.debug) {
                Debug.println("starting new sessionThread ...");
            }
            this.sessionThread = new Thread(this);
            if (this.connection.hasDaemonThreads()) {
                this.sessionThread.setDaemon(true);
            }
            this.sessionThread.setName(imqConsumerReader + this.connection.getLocalID() + "-" + this.connection.getConnectionID() + "-" + this.readerID);
            this.setIsAlive(true);
            this.setIsSuspended(false);
            this.sessionThread.start();
        } else {
            if (this.debug) {
                Debug.println("sessionThread was started already ...");
            }
            this.resume();
        }
    }

    public void run() {
        ReadOnlyPacket readOnlyPacket = null;
        Thread thread = Thread.currentThread();
        if (this.debug) {
            Debug.println("**** Consumer Reader wait timeout: " + this.timeout);
        }
        while (this.sessionThread == thread) {
            try {
                readOnlyPacket = (ReadOnlyPacket)this.sessionQueue.dequeueWait(this.timeout);
                if (this.connection.isBroken()) {
                    this.sessionThread = null;
                    this.sessionQueue.close();
                    continue;
                }
                if (readOnlyPacket != null) {
                    if (!this.getIsAlive()) continue;
                    if (this.debug) {
                        Debug.println(this);
                    }
                    this.deliver(readOnlyPacket);
                    continue;
                }
                this.deliver();
            }
            catch (Exception exception) {
                if (this.connection.isBroken()) {
                    this.sessionThread = null;
                    this.sessionQueue.close();
                    continue;
                }
                if (this.connection.getRecoverInProcess()) {
                    this.sessionQueue.clear();
                    continue;
                }
                Debug.printStackTrace(exception);
            }
            catch (Error error) {
                this.connection.readChannel.setFatalError(error);
                return;
            }
        }
        if (this.debug) {
            Debug.println("sessionReader closed ...");
        }
    }

    protected abstract void deliver(ReadOnlyPacket var1) throws IOException, JMSException;

    protected abstract void deliver() throws IOException, JMSException;

    protected synchronized void stop() {
        if (this.debug) {
            Debug.println("session reader stopped ...");
        }
        this.setIsSuspended(true);
    }

    protected synchronized void suspend() {
        if (this.debug) {
            Debug.println("session reader suspended ...");
        }
        this.setIsSuspended(true);
    }

    protected synchronized void resume() {
        if (this.debug) {
            Debug.println("session reader resumed ...");
        }
        this.setIsSuspended(false);
        this.notifyAll();
    }

    protected synchronized void close() {
        this.setIsAlive(false);
        this.setIsSuspended(false);
        this.sessionThread = null;
        this.sessionQueue.close();
    }

    protected synchronized boolean getIsSuspended() {
        return this.isSuspended;
    }

    protected synchronized boolean getIsAlive() {
        return this.isAlive;
    }

    protected synchronized void setIsSuspended(boolean bl) {
        this.isSuspended = bl;
    }

    protected synchronized void setIsAlive(boolean bl) {
        this.isAlive = bl;
    }

    protected synchronized void setIsPaused(boolean bl) {
        this.isPaused = bl;
    }

    protected synchronized boolean getIsPaused() {
        return this.isPaused;
    }

    public void dump(PrintStream printStream) {
        printStream.println("is alive: " + this.isAlive);
        printStream.println("is suspended: " + this.isSuspended);
    }
}

