/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageQueue;
import java.util.LinkedList;

class PriorityQueue
implements MessageQueue {
    protected static final int ARRAY_SIZE = 10;
    private LinkedList[] qlist = null;
    protected int qsize = 0;

    public PriorityQueue() {
        this.init();
    }

    protected void init() {
        this.qlist = new LinkedList[10];
        for (int i = 0; i < 10; ++i) {
            this.qlist[i] = null;
        }
    }

    public synchronized int size() {
        return this.qsize;
    }

    public synchronized boolean isEmpty() {
        return this.qsize == 0;
    }

    public synchronized void clear() {
        for (int i = 0; i < 10; ++i) {
            this.qlist[i] = null;
        }
        this.qsize = 0;
    }

    public synchronized void enqueue(Object object) {
        int n = this.getPriority(object);
        if (this.qlist[n] == null) {
            this.qlist[n] = new LinkedList();
        }
        this.qlist[n].add(object);
        ++this.qsize;
    }

    protected int getPriority(Object object) {
        int n = 0;
        try {
            if (object instanceof ReadOnlyPacket) {
                n = ((ReadOnlyPacket)object).getPriority();
            } else if (object instanceof MessageImpl) {
                n = ((MessageImpl)object).getJMSPriority();
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return n;
    }

    public synchronized Object dequeue() {
        Object var1_1 = null;
        for (int i = 9; i >= 0; --i) {
            if (this.qlist[i] == null || this.qlist[i].isEmpty()) continue;
            var1_1 = this.qlist[i].removeFirst();
            --this.qsize;
            i = -1;
        }
        return var1_1;
    }

    public synchronized Object[] toArray() {
        LinkedList linkedList = new LinkedList();
        for (int i = 9; i >= 0; --i) {
            if (this.qlist[i] == null || this.qlist[i].isEmpty()) continue;
            int n = this.qlist[i].size();
            for (int j = 0; j < n; ++j) {
                linkedList.add(this.qlist[i].get(j));
            }
        }
        return linkedList.toArray();
    }

    public synchronized boolean remove(Object object) {
        boolean bl = false;
        for (int i = 9; i >= 0 && !bl; --i) {
            if (this.qlist[i] == null || this.qlist[i].isEmpty() || !this.qlist[i].contains(object)) continue;
            bl = this.qlist[i].remove(object);
            --this.qsize;
        }
        return bl;
    }
}

