/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.SessionAdapter;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForMC
implements XAResource {
    private ConnectionImpl raConnection;
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private ManagedConnection mc;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    protected boolean active = false;

    public XAResourceForMC(ManagedConnection managedConnection, ConnectionImpl connectionImpl, ConnectionImpl connectionImpl2) throws JMSException {
        this.mc = managedConnection;
        this.id = managedConnection.getMCId();
        this.raConnection = connectionImpl;
        this.epConnection = connectionImpl2;
        if (connectionImpl == null) {
            System.err.println("MQRA:XARFMC:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (connectionImpl._isClosed()) {
            System.err.println("MQRA:XARFMC:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = connectionImpl.getProtocolHandler().generateUID();
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFMC:constr:Exc aquiring RMId:assume distinct");
            }
        }
    }

    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (!this.epConnection._isClosed()) {
                this.epConnection.getProtocolHandler().commit(0L, bl ? 0x40000000 : 0, jMQXid);
                SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
                if (sessionAdapter != null) {
                    sessionAdapter.getXASession()._finishXATransactionForMC();
                }
            } else {
                System.err.println("MQRA:XARFMC:commit:ConnectionClosed:throw XAExc txn:1p=" + bl + ":xid=" + jMQXid.toString());
                XAException xAException = new XAException(bl ? 100 : -7);
                throw xAException;
            }
            this.active = false;
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            this.epConnection.protocolHandler.endTransaction(0L, n, jMQXid);
            SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
            if (sessionAdapter != null) {
                sessionAdapter.getXASession()._finishXATransactionForMC();
            }
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:end:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        this.started = false;
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this.getClass().isInstance(xAResource) ? this.isSameJMQRM((XAResourceForMC)xAResource) : false;
    }

    public boolean isSameJMQRM(XAResourceForMC xAResourceForMC) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xAResourceForMC.getResourceManagerId();
        }
        return false;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (this.epConnection._isClosed()) {
                System.err.println("MQRA:XARFMC:prepare:ConnectionClosed:Rollback txn:xid=" + jMQXid.toString());
                XAException xAException = new XAException(100);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jMQXid);
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:prepare:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        JMQXid[] jMQXidArray = null;
        try {
            if (!this.epConnection._isClosed()) {
                jMQXidArray = this.epConnection.getProtocolHandler().recover(n);
            }
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:recover:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return jMQXidArray;
    }

    public synchronized void rollback(Xid xid) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (!this.epConnection._isClosed()) {
                this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true);
                SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
                if (sessionAdapter != null) {
                    sessionAdapter.getXASession()._finishXATransactionForMC();
                }
            } else {
                System.err.println("MQRA:XARFMC:rollback:ConnectionClosed:Rollback txn:xid=" + jMQXid.toString());
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.active = false;
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            this.transactionID = this.epConnection.protocolHandler.startTransaction(this.transactionID, n, jMQXid);
            this.jmqXid = jMQXid;
            SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
            if (sessionAdapter != null) {
                sessionAdapter.getXASession()._initXATransactionForMC(this.transactionID);
            }
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:start:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        this.started = true;
        this.active = true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }
}

