/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.logging;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class PacketFormatter
extends SimpleFormatter {
    public synchronized String format(LogRecord logRecord) {
        String string = PacketFormatter.doFormat(logRecord);
        if (string == null) {
            string = super.format(logRecord);
        }
        return string;
    }

    public static String doFormat(LogRecord logRecord) {
        String string = null;
        ReadOnlyPacket readOnlyPacket = PacketFormatter.getPacket(logRecord);
        if (readOnlyPacket != null) {
            long l = logRecord.getMillis();
            Date date = new Date();
            date.setTime(l);
            string = date.toString() + "  " + logRecord.getMessage() + "\n";
            string = string + PacketFormatter.formatPkt(readOnlyPacket);
        }
        return string;
    }

    public static ReadOnlyPacket getPacket(LogRecord logRecord) {
        ReadOnlyPacket readOnlyPacket = null;
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof ReadOnlyPacket)) continue;
                readOnlyPacket = (ReadOnlyPacket)objectArray[i];
                break;
            }
        }
        return readOnlyPacket;
    }

    public static String formatPkt(ReadOnlyPacket readOnlyPacket) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            readOnlyPacket.dump(printStream);
            printStream.flush();
            printStream.close();
            byteArrayOutputStream.close();
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

