/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.ByteBufferPool;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerNotification;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.GlobalErrorHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.VMDiagnostics;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.brokerShutdownHook;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.NoCluster;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.cluster.MultibrokerRouter;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.handlers.AckHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.AuthHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ClientIDHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ConsumerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DeliverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.FlowHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.FlowPausedHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GenerateUIDHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GetLicenseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GoodbyeHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.HelloHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.InfoRequestHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.PingHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ProducerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.QBrowseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.RedeliverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.SessionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.StartStopHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.VerifyDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.VerifyTransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.license.LicenseManager;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatService;
import com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.util.Debug;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.Rlimit;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.timer.JMQTimer;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Broker
implements GlobalErrorHandler {
    public static Broker broker = null;
    public boolean allowHA = true;
    public static boolean NO_CLUSTER = false;
    public static boolean NO_HA = false;
    public static boolean DEBUG = false;
    int DEFAULT_CLUSTER_VERSION = 400;
    private ClusterBroadcast mbus = null;
    private static final String MIN_JAVA_VERSION = "1.4";
    private PacketRouter pktrtr = null;
    private PacketRouter admin_pktrtr = null;
    private TransactionList tlist = null;
    private BrokerResources rb = null;
    private Version version = null;
    private Store store = null;
    private boolean clearProps = false;
    private LicenseBase license = null;
    private String licenseToUse = null;
    private Logger logger = null;
    private String adminKeyFile = null;
    private Hashtable debugAliases = null;
    public boolean startupComplete = false;
    public Thread shutdownHook = null;
    private int exitStatus = 0;
    private Object exitStatusLock = new Object();
    private boolean isNTService = false;
    private int diagInterval = -1;
    public boolean silent = false;
    public boolean force = false;
    public boolean background = false;
    public boolean initOnly = false;
    private boolean removeInstance = false;
    private boolean resetStore = false;
    private ByteBufferPool bytepool = null;
    private static BrokerNotification bkrnotify = null;
    private static boolean runningInProcess = false;
    private String dbPWProp = "imq.persist.jdbc.password";
    private String ldapPWProp = "imq.user_repository.ldap.password";
    private String keystorePWProp = "imq.keystore.password";
    private boolean dbPWOverride = false;
    private boolean ldapPWOverride = false;
    private boolean keystorePWOverride = false;
    static final String DEFAULT_PW_CONTENT = "admin:-2d5455c8583c24eec82c7a1e273ea02e:admin:1\nguest:-2c3c4a34aa2c392f39edd112333c230d:anonymous:1\n";
    static final String DEFAULT_ACL_CONTENT = "##########################################################\n# MQ access control file for JMQFileAccessControlModel\n##########################################################\n\nversion=JMQFileAccessControlModel/100\n\n########################################################\n# Please see the MQ Administration Guide for details\n# on how to customize access control\n#\n# (spaces in a rule are significant)\n########################################################\n\n# service connection access control\n##################################\n\nconnection.NORMAL.allow.user=*\nconnection.ADMIN.allow.group=admin\n\n# destination based access control\n##################################\n\nqueue.*.produce.allow.user=*\nqueue.*.consume.allow.user=*\nqueue.*.browse.allow.user=*\ntopic.*.produce.allow.user=*\ntopic.*.consume.allow.user=*\n\n\n# destination auto-create access control\n########################################\n\nqueue.create.allow.user=*\ntopic.create.allow.user=*\n\n# all permissions access control setup sample\n##############################################\n#connection.*.usernames=*\n#\n#queue.*.produce.allow.user=*\n#queue.*.consume.allow.user=*\n#queue.*.browse.allow.user=*\n#topic.*.produce.allow.user=*\n#topic.*.consume.allow.user=*\n\n#queue.create.allow.user=*\n#topic.create.allow.user=*\n##############################################\n";

    public static boolean isInProcess() {
        return runningInProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Broker getBroker() {
        Class clazz = Broker.class;
        synchronized (clazz) {
            if (broker == null) {
                broker = new Broker();
            }
        }
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyBroker(boolean bl) {
        if (broker == null) {
            return;
        }
        if (Globals.getBrokerStateHandler() != null) {
            Globals.getBrokerStateHandler().initiateShutdown("BrokerProcess", 0L, true, 0, false, false, true);
        }
        if (bl) {
            BrokerMonitor.shutdownMonitor();
            Consumer.clearAllConsumers();
            Destination.clearDestinations();
            DestinationUID.clearCache();
            Producer.clearProducers();
            Session.clearSessions();
            Subscription.clearSubscriptions();
            LockFile.clearLock();
            TLSProtocol.destroy();
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.stop();
                agent.unloadMBeans();
            }
            PortMapper portMapper = Globals.getPortMapper();
            portMapper.destroy();
            Globals.cleanup();
            Class clazz = Broker.class;
            synchronized (clazz) {
                broker = null;
            }
        }
        if (bkrnotify != null) {
            bkrnotify.brokerShutdown();
        }
        bkrnotify = null;
    }

    private Broker() {
        this.version = Globals.getVersion();
        this.rb = Globals.getBrokerResources();
    }

    Properties convertArgs(String[] stringArray) throws IllegalStateException, EmptyStackException {
        Properties properties = this.parseArgs(stringArray);
        properties.put("BrokerArgs", this.argsToString(stringArray).trim());
        return properties;
    }

    public static void initializePasswdFile() throws IOException {
        Logger logger = Globals.getLogger();
        BrokerConfig brokerConfig = Globals.getConfig();
        BrokerResources brokerResources = Globals.getBrokerResources();
        File file = new File(Globals.getInstanceEtcDir());
        if (!file.exists()) {
            file.mkdir();
            String string = brokerConfig.getProperty("imq.accesscontrol.file.filename", "accesscontrol.properties");
            File file2 = new File(Globals.JMQ_ETC_HOME + File.separator + string);
            File file3 = new File(file, string);
            String string2 = brokerConfig.getProperty("imq.user_repository.file.filename", "passwd");
            File file4 = new File(Globals.JMQ_ETC_HOME + File.separator + string2);
            File file5 = new File(file, string2);
            if (file2.exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    RandomAccessFile randomAccessFile2 = new RandomAccessFile(file3, "rw");
                    FileChannel fileChannel2 = randomAccessFile2.getChannel();
                    fileChannel2.transferFrom(fileChannel, 0L, randomAccessFile.length());
                    fileChannel.close();
                    fileChannel2.close();
                    randomAccessFile.close();
                    randomAccessFile2.close();
                    randomAccessFile = new RandomAccessFile(file4, "r");
                    fileChannel = randomAccessFile.getChannel();
                    randomAccessFile2 = new RandomAccessFile(file5, "rw");
                    fileChannel2 = randomAccessFile2.getChannel();
                    fileChannel2.transferFrom(fileChannel, 0L, randomAccessFile.length());
                    fileChannel.close();
                    fileChannel2.close();
                    randomAccessFile.close();
                    randomAccessFile2.close();
                    Object[] objectArray = new Object[]{string2, string, Globals.JMQ_ETC_HOME};
                    logger.logToAll(8, "B1119", objectArray);
                }
                catch (IOException iOException) {
                    logger.log(32, "Failed to copy files from the " + Globals.JMQ_ETC_HOME + " directory:", iOException);
                    throw iOException;
                }
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(DEFAULT_ACL_CONTENT.getBytes());
                fileOutputStream.close();
                fileOutputStream = new FileOutputStream(file5);
                fileOutputStream.write(DEFAULT_PW_CONTENT.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                logger.log(32, "Failed to create default files", iOException);
                throw iOException;
            }
        }
    }

    int start(boolean bl, Properties properties, BrokerNotification brokerNotification) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return this.start(bl, properties, brokerNotification, this.initOnly);
    }

    int init(boolean bl, Properties properties, BrokerNotification brokerNotification) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return this.start(bl, properties, brokerNotification, true);
    }

    int start(boolean bl, Properties properties, BrokerNotification brokerNotification, boolean bl2) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        Object object;
        try {
            Password password;
            Object object2;
            HelloHandler helloHandler;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            bkrnotify = brokerNotification;
            runningInProcess = bl;
            if (properties != null) {
                Globals.init(properties, this.clearProps);
            }
            this.logger = Globals.getLogger();
            object = Globals.getInstanceDir();
            File file = new File((String)object);
            if (!file.exists()) {
                while (!file.exists() && (file = file.getParentFile()) != null) {
                    if (!file.exists() || file.canWrite() && file.canRead()) continue;
                    if (!this.silent) {
                        this.printErr(this.rb.getString("B3124", (Object)file, (Object)Globals.getConfigName()));
                    }
                    return 12;
                }
            } else if (!file.canWrite() || !file.canRead()) {
                if (!this.silent) {
                    System.err.println(this.rb.getString("B3124", (Object)file, (Object)Globals.getConfigName()));
                }
                return 12;
            }
            if (this.removeInstance) {
                this.removeInstance();
            }
            try {
                this.parsePassfile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.log(64, "B3037", fileNotFoundException);
                return 1;
            }
            try {
                Debug.setDebug((Properties)Globals.getConfig(), "imq.debug.");
            }
            catch (Exception exception) {
                this.logger.log(16, "B2014", exception);
            }
            try {
                DiagManager.registerClasses((Properties)Globals.getConfig(), "imq.diag.");
            }
            catch (Exception exception) {
                this.logger.log(16, "B2071", exception);
            }
            BrokerConfig brokerConfig = Globals.getConfig();
            BrokerException brokerException = null;
            try {
                this.license = Globals.getCurrentLicense(this.licenseToUse);
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
            }
            String string = this.version.getBanner(false, 0) + this.rb.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home");
            this.logger.logToAll(8, BrokerResources.NL + string);
            try {
                Broker.initializePasswdFile();
            }
            catch (IOException iOException) {
                return 1;
            }
            if (bl2) {
                this.logger.log(8, "B1161");
                return 0;
            }
            try {
                AccessController.setSecurityManagerIfneed();
            }
            catch (Exception exception) {
                this.logger.logStack(32, exception.getMessage(), exception);
                return 1;
            }
            if (!MQAuthenticator.authenticateCMDUserIfset()) {
                this.logger.log(8, "B1047");
                return 1;
            }
            DiagManager.register(new VMDiagnostics());
            if (brokerException != null) {
                this.logger.log(32, brokerException.toString());
                return 1;
            }
            if (this.license.getExpirationDate() != null) {
                object7 = this.license.getExpirationDate();
                object6 = DateFormat.getDateInstance(2);
                this.println(this.rb.getString("B0007", (Object)((DateFormat)object6).format((Date)object7)));
            }
            this.logger.log(8, this.rb.getString("B1138", (Object)this.license.getProperty("description")));
            if (Version.compareVersions(System.getProperty("java.specification.version"), MIN_JAVA_VERSION, true) < 0) {
                this.logger.logToAll(32, "B3154", System.getProperty("java.specification.version"), MIN_JAVA_VERSION);
                return 1;
            }
            object7 = brokerConfig.getProperty("imq.hostname");
            Globals.setHostname((String)object7);
            if (object7 == null || ((String)object7).equals("*")) {
                try {
                    object6 = InetAddress.getLocalHost();
                    Globals.setBrokerInetAddress((InetAddress)object6);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.log(32, "B3152", unknownHostException);
                    this.logger.log(8, "B0010");
                    return 1;
                }
            }
            try {
                object6 = InetAddress.getByName((String)object7);
                Globals.setBrokerInetAddress((InetAddress)object6);
            }
            catch (UnknownHostException unknownHostException) {
                this.logger.log(32, this.rb.getString("B3151", object7, (Object)"imq.hostname"), unknownHostException);
                this.logger.log(8, "B0010");
                return 1;
            }
            object6 = brokerConfig.getProperty("imq.jmx.hostname");
            Globals.setJMXHostname((String)object6);
            if (object6 != null && !((String)object6).equals("*")) {
                try {
                    object5 = InetAddress.getByName((String)object6);
                    Globals.setJMXInetAddress((InetAddress)object5);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.log(32, this.rb.getString("B3151", object7, (Object)"imq.jmx.hostname"), unknownHostException);
                    this.logger.log(8, "B0010");
                    return 1;
                }
            }
            try {
                this.logger.logToAll(8, "   IMQ_HOME=" + new File(Globals.JMQ_HOME).getCanonicalPath());
                this.logger.logToAll(8, "IMQ_VARHOME=" + new File(Globals.JMQ_VAR_HOME).getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logger.logToAll(8, System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " " + Globals.getBrokerHostName() + " " + "(" + Runtime.getRuntime().availableProcessors() + " cpu) " + System.getProperty("user.name"));
            try {
                object5 = Rlimit.get(5);
                this.logger.logToAll(8, this.rb.getString("B1092"), ((Rlimit.Limits)object5).current == -3L ? "unlimited" : String.valueOf(((Rlimit.Limits)object5).current), ((Rlimit.Limits)object5).maximum == -3L ? "unlimited" : String.valueOf(((Rlimit.Limits)object5).maximum));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.logToAll(8, this.rb.getString("B1086"), Long.toString(Runtime.getRuntime().maxMemory() / 1024L), Long.toString(Runtime.getRuntime().totalMemory() / 1024L));
            this.logger.logToAll(8, this.rb.getString("B1055"), properties.get("BrokerArgs"));
            this.bytepool = new ByteBufferPool();
            this.bytepool.setBlockSize(72);
            Packet.setBufferPool(this.bytepool);
            Globals.setGlobalErrorHandler(this);
            object5 = this.getAdminKey(this.adminKeyFile);
            String string2 = "imq.adminkey";
            if (object5 == null || ((String)object5).length() == 0) {
                brokerConfig.remove((Object)string2);
            } else {
                try {
                    brokerConfig.updateProperty(string2, (String)object5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl3 = Globals.getHAEnabled();
            boolean bl4 = NO_HA = !this.allowHA || !this.license.getBooleanProperty("imq.enable_ha", false);
            if (bl3 && NO_HA) {
                this.logger.log(64, Globals.getBrokerResources().getKString("B1189", (Object)Globals.getBrokerResources().getString("B0078")));
                System.exit(1);
            }
            String string3 = Globals.getBrokerID();
            String string4 = Globals.getClusterID();
            if (bl3) {
                if (string3 == null) {
                    this.logger.log(32, "B3197");
                    return 1;
                }
                this.logger.log(8, "B1202", (Object)string3, string4);
            } else if (string3 != null) {
                this.logger.log(8, "B1203", string3);
            }
            PortMapper portMapper = Globals.getPortMapper();
            if (portMapper.getServerSocket() == null) {
                System.err.println(this.rb.getString("B0010"));
                return 1;
            }
            BrokerMQAddress brokerMQAddress = null;
            String string5 = Globals.getBrokerHostName() + ":" + portMapper.getPort();
            try {
                brokerMQAddress = BrokerMQAddress.createAddress((String)string5);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3157", string5, (Throwable)exception);
            }
            try {
                Globals.initClusterManager((MQAddress)brokerMQAddress);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B3198", exception);
                return 1;
            }
            portMapper.updateProperties();
            MQThread mQThread = new MQThread((Runnable)portMapper, "JMQPortMapper");
            mQThread.setDaemon(true);
            mQThread.start();
            LockFile lockFile = null;
            try {
                lockFile = LockFile.getLock((String)brokerConfig.getProperty("imq.varhome"), (String)Globals.getConfigName(), (String)(portMapper.getHostname() == null || portMapper.getHostname().equals("") ? Globals.getBrokerHostName() : portMapper.getHostname()), (int)portMapper.getPort());
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{LockFile.getLockFilePath((String)brokerConfig.getProperty("imq.varhome"), (String)Globals.getConfigName()), exception.toString(), Globals.getConfigName()};
                this.logger.log(32, "B3086", objectArray);
                return 1;
            }
            if (!lockFile.isMyLock()) {
                Object[] objectArray = new Object[]{lockFile.getFilePath(), lockFile.getHost() + ":" + lockFile.getPort(), Globals.getConfigName()};
                this.logger.log(32, "B3087", objectArray);
                return 1;
            }
            if (this.resetStore && bl3) {
                this.logger.log(16, "B2108");
            }
            try {
                this.store = Globals.getStore();
            }
            catch (BrokerException brokerException3) {
                this.logger.log(32, "B3000", brokerException3);
                return 1;
            }
            HAMonitorService hAMonitorService = null;
            if (bl3) {
                this.logger.log(8, "B1204");
                try {
                    hAMonitorService = new HAMonitorService(Globals.getClusterID(), Globals.getMQAddress());
                    Globals.setHAMonitorService(hAMonitorService);
                }
                catch (Exception exception) {
                    this.logger.logStack(32, "B3199", exception);
                    return 1;
                }
                this.logger.log(8, "B1205");
                try {
                    Globals.registerHeartbeatService(new HeartbeatService());
                }
                catch (Exception exception) {
                    this.logger.log(32, "B3200", exception);
                    return 1;
                }
            }
            NO_CLUSTER = !this.license.getBooleanProperty("imq.enable_cluster", false);
            int n = this.license.getIntProperty("imq.max_broker_conns", -1);
            MultibrokerRouter multibrokerRouter = null;
            if (NO_CLUSTER) {
                this.mbus = new NoCluster();
                this.logger.log(64, Globals.getBrokerResources().getKString("B1189", (Object)Globals.getBrokerResources().getString("B0075")));
            } else {
                try {
                    object4 = Class.forName("com.sun.messaging.jmq.jmsserver.core.cluster.ClusterBroadcaster");
                    object3 = new Class[]{Integer.class, Integer.class};
                    helloHandler = object4.getConstructor((Class<?>)object3);
                    object2 = new Object[]{new Integer(n), new Integer(this.DEFAULT_CLUSTER_VERSION)};
                    this.mbus = (ClusterBroadcast)helloHandler.newInstance((Object[])object2);
                    multibrokerRouter = new MultibrokerRouter(this.mbus);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.logStack(4, "B3100", "unable to use cluster broadcaster", (Throwable)classNotFoundException);
                    this.logger.log(8, "B1137");
                    this.mbus = new NoCluster();
                }
                catch (InvocationTargetException invocationTargetException) {
                    object3 = invocationTargetException.getCause();
                    this.logger.logStack(8, "B3100", "unable to use cluster broadcaster", (Throwable)object3);
                    this.logger.log(8, "B1137");
                    this.mbus = new NoCluster();
                }
                catch (Exception exception) {
                    this.logger.logStack(8, "B3100", "unable to use cluster broadcaster", (Throwable)exception);
                    this.logger.log(8, "B1137");
                    this.mbus = new NoCluster();
                }
            }
            Globals.setClusterBroadcast(this.mbus);
            Globals.setClusterRouter(multibrokerRouter);
            Globals.setMyAddress(this.mbus.getMyAddress());
            if (!NO_CLUSTER) {
                object4 = Globals.getClusterDiscoveryService();
                object4.addSelfAddress(this.mbus.getMyAddress());
                object3 = new Thread((Runnable)object4, "ClusterDiscoveryService");
                ((Thread)object3).setDaemon(true);
                ((Thread)object3).start();
            }
            if ((object4 = Globals.getConfig().getProperty("imq.authentication.type")) != null && ((String)(object3 = Globals.getConfig().getProperty("imq.authentication." + (String)object4 + ".user_repository"))).equals("ldap")) {
                helloHandler = Globals.getConfig().getProperty("imq.user_repository." + (String)object3 + ".principal");
                object2 = Globals.getConfig().getProperty("imq.user_repository." + (String)object3 + ".password");
                if (helloHandler != null && helloHandler.trim().length() > 0 && (object2 == null || ((String)object2).trim().length() == 0)) {
                    boolean bl5;
                    password = null;
                    boolean bl6 = bl5 = object2 == null || ((String)object2).equals("");
                    for (int i = 0; object2 == null || ((String)object2).trim().equals("") && i < 5; ++i) {
                        password = new Password();
                        System.err.print(Globals.getBrokerResources().getString("B0031", (Object)helloHandler));
                        System.err.flush();
                        object2 = password.getPassword();
                    }
                    if (object2 == null || ((String)object2).trim().equals("")) {
                        this.logger.log(16, "B2078", object2);
                        Globals.getConfig().put((Object)("imq.user_repository." + (String)object3 + ".principal"), (Object)"");
                    } else if (bl5) {
                        Globals.getConfig().put((Object)("imq.user_repository." + (String)object3 + ".password"), object2);
                    }
                }
            }
            object3 = new ConnectionManager(this.license.getIntProperty("imq.max_client_conns", -1));
            Globals.setConnectionManager((ConnectionManager)object3);
            this.tlist = new TransactionList(this.store);
            Globals.setTransactionList(this.tlist);
            try {
                Destination.init();
                Subscription.initSubscriptions();
                BrokerMonitor.init();
            }
            catch (BrokerException brokerException4) {
                this.logger.logStack(16, "B3101", brokerException4);
            }
            try {
                helloHandler = Class.forName("javax.management.MBeanServer");
                object2 = new Agent();
                Globals.setAgent((Agent)object2);
                object2.start();
            }
            catch (Exception exception) {
                this.logger.log(16, "JMX classes not present - JMX Agent is not created.");
            }
            Selector.setConvertTypes(brokerConfig.getBooleanProperty("imq.selector.convertTypes", false));
            Selector.setShortCircuit(brokerConfig.getBooleanProperty("imq.selector.shortCircuit", true));
            this.pktrtr = new PacketRouter();
            helloHandler = new HelloHandler((ConnectionManager)object3);
            object2 = new GetLicenseHandler();
            GoodbyeHandler goodbyeHandler = new GoodbyeHandler((ConnectionManager)object3);
            password = new StartStopHandler();
            ConsumerHandler consumerHandler = new ConsumerHandler();
            ProducerHandler producerHandler = new ProducerHandler();
            DestinationHandler destinationHandler = new DestinationHandler();
            QBrowseHandler qBrowseHandler = new QBrowseHandler();
            AuthHandler authHandler = new AuthHandler((ConnectionManager)object3);
            SessionHandler sessionHandler = new SessionHandler();
            PingHandler pingHandler = new PingHandler();
            DataHandler dataHandler = new DataHandler(this.tlist);
            AckHandler ackHandler = new AckHandler(this.tlist);
            RedeliverHandler redeliverHandler = new RedeliverHandler();
            DeliverHandler deliverHandler = new DeliverHandler();
            TransactionHandler transactionHandler = new TransactionHandler(this.tlist);
            VerifyDestinationHandler verifyDestinationHandler = new VerifyDestinationHandler();
            ClientIDHandler clientIDHandler = new ClientIDHandler();
            FlowHandler flowHandler = new FlowHandler();
            FlowPausedHandler flowPausedHandler = new FlowPausedHandler();
            GenerateUIDHandler generateUIDHandler = new GenerateUIDHandler();
            InfoRequestHandler infoRequestHandler = new InfoRequestHandler();
            VerifyTransactionHandler verifyTransactionHandler = new VerifyTransactionHandler(this.tlist);
            try {
                this.pktrtr.addHandler(10, (PacketHandler)helloHandler);
                this.pktrtr.addHandler(12, (PacketHandler)authHandler);
                this.pktrtr.addHandler(76, (PacketHandler)object2);
                this.pktrtr.addHandler(14, (PacketHandler)consumerHandler);
                this.pktrtr.addHandler(16, (PacketHandler)consumerHandler);
                this.pktrtr.addHandler(18, (PacketHandler)producerHandler);
                this.pktrtr.addHandler(20, (PacketHandler)password);
                this.pktrtr.addHandler(22, (PacketHandler)password);
                this.pktrtr.addHandler(24, (PacketHandler)ackHandler);
                this.pktrtr.addHandler(26, (PacketHandler)qBrowseHandler);
                this.pktrtr.addHandler(28, (PacketHandler)goodbyeHandler);
                this.pktrtr.addHandler(32, (PacketHandler)redeliverHandler);
                this.pktrtr.addHandler(34, (PacketHandler)destinationHandler);
                this.pktrtr.addHandler(36, (PacketHandler)destinationHandler);
                this.pktrtr.addHandler(40, (PacketHandler)verifyDestinationHandler);
                this.pktrtr.addHandler(42, (PacketHandler)deliverHandler);
                this.pktrtr.addHandler(44, (PacketHandler)transactionHandler);
                this.pktrtr.addHandler(46, (PacketHandler)transactionHandler);
                this.pktrtr.addHandler(48, (PacketHandler)transactionHandler);
                this.pktrtr.addHandler(56, (PacketHandler)transactionHandler);
                this.pktrtr.addHandler(58, (PacketHandler)transactionHandler);
                this.pktrtr.addHandler(60, (PacketHandler)transactionHandler);
                this.pktrtr.addHandler(50, (PacketHandler)clientIDHandler);
                this.pktrtr.addHandler(62, (PacketHandler)generateUIDHandler);
                this.pktrtr.addHandler(3, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(2, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(6, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(27, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(5, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(4, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(1, (PacketHandler)dataHandler);
                this.pktrtr.addHandler(52, (PacketHandler)flowHandler);
                this.pktrtr.addHandler(64, (PacketHandler)flowPausedHandler);
                this.pktrtr.addHandler(68, (PacketHandler)sessionHandler);
                this.pktrtr.addHandler(66, (PacketHandler)producerHandler);
                this.pktrtr.addHandler(70, (PacketHandler)sessionHandler);
                this.pktrtr.addHandler(54, (PacketHandler)pingHandler);
                this.pktrtr.addHandler(72, (PacketHandler)infoRequestHandler);
                this.pktrtr.addHandler(78, (PacketHandler)verifyTransactionHandler);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "adding packet handlers", (Throwable)exception);
            }
            this.admin_pktrtr = new PacketRouter();
            AdminDataHandler adminDataHandler = new AdminDataHandler(this.tlist);
            try {
                this.admin_pktrtr.addHandler(10, (PacketHandler)helloHandler);
                this.admin_pktrtr.addHandler(12, (PacketHandler)authHandler);
                this.admin_pktrtr.addHandler(76, (PacketHandler)object2);
                this.admin_pktrtr.addHandler(14, (PacketHandler)consumerHandler);
                this.admin_pktrtr.addHandler(16, (PacketHandler)consumerHandler);
                this.admin_pktrtr.addHandler(18, (PacketHandler)producerHandler);
                this.admin_pktrtr.addHandler(20, (PacketHandler)password);
                this.admin_pktrtr.addHandler(22, (PacketHandler)password);
                this.admin_pktrtr.addHandler(24, (PacketHandler)ackHandler);
                this.admin_pktrtr.addHandler(26, (PacketHandler)qBrowseHandler);
                this.admin_pktrtr.addHandler(28, (PacketHandler)goodbyeHandler);
                this.admin_pktrtr.addHandler(32, (PacketHandler)redeliverHandler);
                this.admin_pktrtr.addHandler(34, (PacketHandler)destinationHandler);
                this.admin_pktrtr.addHandler(36, (PacketHandler)destinationHandler);
                this.admin_pktrtr.addHandler(40, (PacketHandler)verifyDestinationHandler);
                this.admin_pktrtr.addHandler(42, (PacketHandler)deliverHandler);
                this.admin_pktrtr.addHandler(44, (PacketHandler)transactionHandler);
                this.admin_pktrtr.addHandler(46, (PacketHandler)transactionHandler);
                this.admin_pktrtr.addHandler(48, (PacketHandler)transactionHandler);
                this.admin_pktrtr.addHandler(56, (PacketHandler)transactionHandler);
                this.admin_pktrtr.addHandler(58, (PacketHandler)transactionHandler);
                this.admin_pktrtr.addHandler(60, (PacketHandler)transactionHandler);
                this.admin_pktrtr.addHandler(50, (PacketHandler)clientIDHandler);
                this.admin_pktrtr.addHandler(62, (PacketHandler)generateUIDHandler);
                this.admin_pktrtr.addHandler(3, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(2, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(6, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(27, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(5, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(4, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(1, (PacketHandler)adminDataHandler);
                this.admin_pktrtr.addHandler(52, (PacketHandler)flowHandler);
                this.admin_pktrtr.addHandler(64, (PacketHandler)flowPausedHandler);
                this.admin_pktrtr.addHandler(68, (PacketHandler)sessionHandler);
                this.admin_pktrtr.addHandler(66, (PacketHandler)producerHandler);
                this.admin_pktrtr.addHandler(70, (PacketHandler)sessionHandler);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "adding packet handlers to admin packet router", (Throwable)exception);
            }
            adminDataHandler.setPacketRouter(this.admin_pktrtr);
            PacketRouter[] packetRouterArray = new PacketRouter[]{this.pktrtr, this.admin_pktrtr};
            Globals.setPacketRouters(packetRouterArray);
            TLSProtocol.init();
            ServiceManager serviceManager = new ServiceManager((ConnectionManager)object3);
            Globals.setServiceManager(serviceManager);
            serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 1, false);
            if (this.mbus.waitForConfigSync()) {
                serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 0, true);
                this.logger.log(32, "B1073");
            } else {
                serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 0, false);
            }
            Globals.setBrokerStateHandler(new BrokerStateHandler());
            BrokerStateHandler.shuttingDown = false;
            if (bl || (this.shutdownHook = this.addShutdownHook()) == null) {
                this.logger.log(4, "B1050");
            } else {
                this.logger.log(4, "B1049");
            }
            if (!bl) {
                Globals.getMemManager().startManagement();
            } else {
                Globals.setMemMgrOn(false);
            }
            MetricManager metricManager = new MetricManager();
            Globals.setMetricManager(metricManager);
            metricManager.setParameters((Hashtable)Globals.getConfig());
            Properties properties2 = new Properties();
            properties2.setProperty("imq.autocreate.queue", Globals.getConfig().getProperty("imq.autocreate.queue", "false"));
            properties2.setProperty("imq.autocreate.topic", Globals.getConfig().getProperty("imq.autocreate.topic", "false"));
            int n2 = Queue.getDefaultMaxActiveConsumers();
            int n3 = Queue.getDefaultMaxFailoverConsumers();
            if (n2 == 1 && n3 == 0) {
                properties2.setProperty("imq.queue.deliverypolicy", "single");
            }
            if (n2 == 1 && n3 != 0) {
                properties2.setProperty("imq.queue.deliverypolicy", "failover");
            }
            if ((n2 == -1 || n2 > 1) && n3 == 0) {
                properties2.setProperty("imq.queue.deliverypolicy", "round-robin");
            }
            if (Globals.getClusterID() != null) {
                properties2.setProperty("imq.cluster.clusterid", Globals.getClusterID());
            }
            if (bl3) {
                properties2.setProperty("imq.cluster.ha", Globals.getConfig().getProperty("imq.cluster.ha"));
                properties2.setProperty("imq.cluster.monitor.interval", String.valueOf(hAMonitorService.getMonitorInterval()));
                properties2.setProperty("imq.cluster.heartbeat.class", Globals.getConfig().getProperty("imq.cluster.heartbeat.class"));
                properties2.setProperty("imq.service.activelist", Globals.getConfig().getProperty("imq.service.activelist"));
            } else if (Globals.getConfig().getBooleanProperty("imq.txn.protocol.override")) {
                properties2.setProperty("imq.txn.protocol.override", Globals.getConfig().getProperty("imq.txn.protocol.override"));
            }
            this.mbus.setMatchProps(properties2);
            this.mbus.startClusterIO();
            this.startupComplete = true;
            Object[] objectArray = new Object[]{Globals.getConfigName() + "@" + (portMapper.getHostname() == null || portMapper.getHostname().equals("") ? Globals.getBrokerHostName() : portMapper.getHostname()) + ":" + String.valueOf(portMapper.getPort())};
            this.logger.logToAll(8, "B1039", objectArray);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.loadMBeans();
            }
            if (bkrnotify != null) {
                bkrnotify.brokerStarted();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Globals.handleGlobalError(outOfMemoryError, this.rb.getKString("B0017"));
            return 1;
        }
        if (this.diagInterval > 0) {
            object = Globals.getTimer();
            int n = this.diagInterval * 1000;
            ((JMQTimer)object).schedule((JMQTimerTask)new BrokerDiagTask(), n, (long)n);
        } else if (this.diagInterval == 0) {
            this.logger.log(8, DiagManager.allToString());
        }
        return 0;
    }

    private String argsToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private Properties parseArgs(String[] stringArray) throws IllegalArgumentException, EmptyStackException {
        Properties properties = new Properties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-loglevel")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing log argument");
                }
                try {
                    Logger.levelStrToInt(stringArray[i]);
                    properties.put("imq.log.level", stringArray[i]);
                    bl = true;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.printErr(this.rb.getString("B0003"));
                    throw new IllegalArgumentException("Bad log level");
                }
            }
            if (stringArray[i].equals("-shared")) {
                properties.put("imq.jms.threadpool_model", "shared");
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing debug argument");
                }
                if (!bl) {
                    properties.put("imq.log.level", "DEBUGHIGH");
                }
                if (this.enableDebug(stringArray[i], properties)) continue;
                throw new IllegalArgumentException("bad debug argument");
            }
            if (stringArray[i].equals("-dbuser")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing dbuser argument");
                }
                properties.put("imq.persist.jdbc.user", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-dbpassword")) {
                this.printPasswordError(stringArray[i]);
                throw new IllegalArgumentException("argument unsupported");
            }
            if (stringArray[i].equals("-dbpwd")) {
                this.printPasswordWarning(stringArray[i]);
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing dbpassword argument");
                }
                properties.put(this.dbPWProp, stringArray[i]);
                this.dbPWOverride = true;
                continue;
            }
            if (stringArray[i].equals("-diag")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing diag interval");
                }
                try {
                    this.diagInterval = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("bad diag interval");
                }
            }
            if (stringArray[i].equals("-name")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing broker instancename");
                }
                properties.put("imq.instancename", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-port")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing port");
                }
                properties.put("imq.portmapper.port", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-metrics")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing metrics");
                }
                properties.put("imq.metrics.interval", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-password")) {
                this.printPasswordError(stringArray[i]);
                throw new IllegalArgumentException("argument unsupported");
            }
            if (stringArray[i].equals("-pwd")) {
                this.printPasswordWarning(stringArray[i]);
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing password");
                }
                properties.put(this.keystorePWProp, stringArray[i]);
                this.keystorePWOverride = true;
                continue;
            }
            if (stringArray[i].equals("-ldappassword")) {
                this.printPasswordError(stringArray[i]);
                throw new IllegalArgumentException("argument unsupported");
            }
            if (stringArray[i].equals("-ldappwd")) {
                this.printPasswordWarning(stringArray[i]);
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing ldab password");
                }
                properties.put(this.ldapPWProp, stringArray[i]);
                this.ldapPWOverride = true;
                continue;
            }
            if (stringArray[i].equals("-passfile")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing passfile name");
                }
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("unknown passfile: " + iOException);
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
                continue;
            }
            if (stringArray[i].equals("-backup")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing backup argument");
                }
                properties.put("imq.cluster.masterbroker.backup", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-restore")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing restore argument");
                }
                properties.put("imq.cluster.masterbroker.restore", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-cluster")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing cluster list");
                }
                properties.put("imq.cluster.brokerlist.manual", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-force")) {
                this.force = true;
                continue;
            }
            if (stringArray[i].equals("-silent") || stringArray[i].equals("-s")) {
                properties.put("imq.log.console.output", "NONE");
                this.silent = true;
                continue;
            }
            if (stringArray[i].equals("-tty")) {
                properties.put("imq.log.console.output", "ALL");
                continue;
            }
            if (stringArray[i].startsWith("-D")) {
                int n = 0;
                String string = null;
                String string2 = "";
                n = stringArray[i].indexOf(61);
                if (stringArray[i].length() <= 2) continue;
                if (n < 0) {
                    string = stringArray[i].substring(2);
                } else if (n == stringArray[i].length() - 1) {
                    string = stringArray[i].substring(2, n);
                } else {
                    string = stringArray[i].substring(2, n);
                    string2 = stringArray[i].substring(n + 1);
                }
                properties.put(string, string2);
                continue;
            }
            if (stringArray[i].equals("-varhome") || stringArray[i].equals("-jmqvarhome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-imqhome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-libhome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-javahome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-jrehome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-bgnd")) {
                this.background = true;
                continue;
            }
            if (stringArray[i].equals("-init")) {
                this.initOnly = true;
                continue;
            }
            if (stringArray[i].equals("-version") || stringArray[i].equals("-v")) {
                Globals.pathinit(System.getProperties());
                this.println(this.version.getBanner(true));
                this.println(this.rb.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
                this.println(this.rb.getString("B1054") + System.getProperty("java.class.path"));
                try {
                    this.println("   IMQ_HOME=" + new File(Globals.JMQ_HOME).getCanonicalPath());
                    this.println("IMQ_VARHOME=" + new File(Globals.JMQ_VAR_HOME).getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-ntservice")) {
                this.isNTService = true;
                continue;
            }
            if (stringArray[i].equals("-adminkeyfile")) {
                this.adminKeyFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-help") || stringArray[i].equals("-h")) {
                throw new EmptyStackException();
            }
            if (stringArray[i].equals("-license")) {
                if (++i >= stringArray.length || stringArray[i].startsWith("-")) {
                    this.printLicenses();
                    continue;
                }
                this.licenseToUse = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-remove")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing remove argument");
                }
                if (stringArray[i].equals("instance")) {
                    this.removeInstance = true;
                    properties.put("imq.persist.storeremove.all", "true");
                    continue;
                }
                this.printErr(this.rb.getString("B0028"));
                throw new IllegalArgumentException("unknown remove argument");
            }
            if (stringArray[i].equals("-reset")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing reset argument");
                }
                if (stringArray[i].equals("store")) {
                    properties.put("imq.persist.storereset.all", "true");
                    this.resetStore = true;
                    continue;
                }
                if (stringArray[i].equals("messages")) {
                    properties.put("imq.persist.storereset.messages", "true");
                    continue;
                }
                if (stringArray[i].equals("durables")) {
                    properties.put("imq.persist.storereset.durables", "true");
                    continue;
                }
                if (stringArray[i].equals("props")) {
                    this.clearProps = true;
                    continue;
                }
                this.printErr(this.rb.getString("B0009"));
                throw new IllegalArgumentException("bad reset argument");
            }
            if (stringArray[i].equals("-upgrade-store-nobackup")) {
                properties.put("imq.persist.storeupgrade.nobackup", "true");
                continue;
            }
            if (stringArray[i].equals("-useRmiRegistry")) {
                properties.put("imq.jmx.rmiregistry.use", "true");
                continue;
            }
            if (stringArray[i].equals("-startRmiRegistry")) {
                properties.put("imq.jmx.rmiregistry.start", "true");
                continue;
            }
            if (stringArray[i].equals("-rmiRegistryPort")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException("missing rmi port");
                }
                properties.put("imq.jmx.rmiregistry.port", stringArray[i]);
                continue;
            }
            this.printErr(this.rb.getString("B3058", (Object)stringArray[i]));
            throw new IllegalArgumentException("unknown option " + stringArray[i]);
        }
        return properties;
    }

    private void printPasswordWarning(String string) {
        if (!this.silent) {
            this.printErr(this.rb.getString("B2088", (Object)string));
            this.printErr("");
        }
    }

    private void printPasswordError(String string) {
        if (!this.silent) {
            this.printErr(this.rb.getString("B3217", (Object)string));
            this.printErr("");
        }
        Broker.getBroker().exit(1, this.rb.getString("B3217"), 2);
    }

    private String getAdminKey(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[256];
        File file = new File(string);
        FileInputStream fileInputStream = null;
        int n = 0;
        try {
            fileInputStream = new FileInputStream(file);
            n = fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.log(16, "B2064", (Object)string, (Throwable)fileNotFoundException);
            return null;
        }
        catch (IOException iOException) {
            this.logger.log(16, "B2064", (Object)string, (Throwable)iOException);
            return null;
        }
        String string2 = null;
        try {
            string2 = new String(byArray, 0, n, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.log(16, "B3100", "Could not convert key to String using ASCII encoding ");
        }
        if (!file.delete()) {
            this.logger.log(16, "B2065", string);
        }
        return string2;
    }

    private synchronized boolean enableDebug(String string, Properties properties) {
        String string2;
        String string3 = "imq.debug.com.sun.messaging.jmq.";
        if (this.debugAliases == null) {
            this.debugAliases = new Hashtable();
            this.debugAliases.put("admin", string3 + "jmsserver.data.handlers.admin.AdminCmdHandler");
            this.debugAliases.put("jmx", string3 + "jmsserver.management.agent.Agent");
            this.debugAliases.put("jesmf", string3 + "jmsserver.management.jesmf.JesmfManagerImpl");
            this.debugAliases.put("pkt", "imq.packet.debug.all");
            this.debugAliases.put("pktin", "imq.packet.debug.in");
            this.debugAliases.put("pktout", "imq.packet.debug.out");
            this.debugAliases.put("cluster", "imq.cluster.debug.all");
            this.debugAliases.put("lock", "imq.cluster.debug.lock");
            this.debugAliases.put("clscon", "imq.cluster.debug.conn");
            this.debugAliases.put("clspkt", "imq.cluster.debug.packet");
        }
        if ((string2 = (String)this.debugAliases.get(string)) == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            properties.put(stringTokenizer.nextToken(), "true");
        }
        return true;
    }

    String usage() {
        return this.rb.getString("B0002");
    }

    private void printLicenses() {
        Globals.getLicenseManager();
        LicenseBase[] licenseBaseArray = LicenseManager.loadLicenses();
        if (licenseBaseArray.length == 0) {
            this.println("");
            this.println(this.rb.getString("B1143"));
            this.println("");
        } else {
            this.println(this.rb.getString("B0005"));
            for (int i = 0; i < licenseBaseArray.length; ++i) {
                String string = licenseBaseArray[i].getProperty("imq.license_type");
                String string2 = licenseBaseArray[i].getProperty("description");
                this.println("\t" + string + "\t-  " + string2);
            }
            this.println(this.rb.getString("B0006"));
        }
        Broker.getBroker().exit(0, "Displayed Licenses", 0);
    }

    public Thread addShutdownHook() {
        Method method;
        Runtime runtime = Runtime.getRuntime();
        Class[] classArray = new Class[1];
        try {
            classArray[0] = Class.forName("java.lang.Thread");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printErr("addShutdownHook: can't find java.lang.Thread: " + classNotFoundException);
            return null;
        }
        try {
            method = runtime.getClass().getMethod("addShutdownHook", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Object[] objectArray = new Object[]{new brokerShutdownHook()};
        try {
            method.invoke((Object)runtime, objectArray);
        }
        catch (Exception exception) {
            this.printErr("addShutdownHook: could not call addShutdownHook: " + exception);
            return null;
        }
        return (Thread)objectArray[0];
    }

    public boolean removeShutdownHook(Thread thread) {
        Method method;
        Runtime runtime = Runtime.getRuntime();
        Class[] classArray = new Class[1];
        try {
            classArray[0] = Class.forName("java.lang.Thread");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printErr("removeShutdownHook: can't find java.lang.Thread: " + classNotFoundException);
            return false;
        }
        try {
            method = runtime.getClass().getMethod("removeShutdownHook", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Object[] objectArray = new Object[]{thread};
        try {
            method.invoke((Object)runtime, objectArray);
        }
        catch (Exception exception) {
            this.printErr("removeShutdownHook: could not call removeShutdownHook: " + exception);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Broker broker = Broker.getBroker();
        Properties properties = null;
        Globals.init(System.getProperties(), false);
        try {
            properties = broker.convertArgs(stringArray);
        }
        catch (EmptyStackException emptyStackException) {
            broker.printErr(broker.usage());
            System.exit(0);
        }
        catch (Exception exception) {
            broker.printErr(broker.usage());
            System.exit(1);
        }
        try {
            int n = broker.start(false, properties, null);
            if (n != 0) {
                System.exit(n);
            }
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Exception running broker ", exception);
            System.exit(1);
        }
    }

    public void removeInstance() {
        Object[] objectArray;
        BrokerResources brokerResources = Globals.getBrokerResources();
        Logger logger = Globals.getLogger();
        String string = Globals.getInstanceDir();
        if (!new File(string).exists()) {
            if (!this.silent) {
                System.err.println(brokerResources.getString("B3119", (Object)Globals.getConfigName()));
            }
            Broker.getBroker().exit(10, brokerResources.getString("B3119", (Object)Globals.getConfigName()), 2);
        }
        BrokerConfig brokerConfig = Globals.getConfig();
        LockFile lockFile = null;
        try {
            lockFile = LockFile.getLock((String)brokerConfig.getProperty("imq.varhome"), (String)Globals.getConfigName(), (String)"localhost", (int)0);
        }
        catch (Exception exception) {
            objectArray = new Object[]{LockFile.getLockFilePath((String)brokerConfig.getProperty("imq.varhome"), (String)Globals.getConfigName()), exception.toString(), Globals.getConfigName()};
            logger.log(32, "B3086", objectArray);
            Broker.getBroker().exit(14, brokerResources.getKString("B3086", objectArray), 2);
        }
        if (!lockFile.isMyLock()) {
            Object[] objectArray2 = new Object[]{lockFile.getFilePath(), lockFile.getHost() + ":" + lockFile.getPort(), Globals.getConfigName()};
            logger.log(32, "B3087", objectArray2);
            Broker.getBroker().exit(11, brokerResources.getKString("B3087", objectArray2), 2);
        }
        boolean bl = false;
        try {
            if (!this.force) {
                objectArray = brokerResources.getString("B0029");
                String string2 = brokerResources.getString("B0026");
                String string3 = brokerResources.getString("B0027");
                Object[] objectArray3 = new String[]{Globals.getConfigName(), string2, string3};
                System.out.print(brokerResources.getString("B0025", objectArray3));
                System.out.flush();
                String string4 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!string2.equalsIgnoreCase(string4) && !objectArray.equalsIgnoreCase(string4)) {
                    this.printErr(brokerResources.getString("B1097"));
                    Broker.getBroker().exit(1, brokerResources.getString("B1097"), 0);
                }
            }
            try {
                Globals.getStore();
            }
            catch (BrokerException brokerException) {
                logger.log(32, brokerException.toString());
                Broker.getBroker().exit(13, brokerException.toString(), 4);
            }
            if (!this.silent) {
                this.println(brokerResources.getString("B1096"));
            }
            logger.close();
            bl = true;
            FileUtil.removeFiles(new File(string), true);
            Broker.getBroker().exit(0, brokerResources.getString("B1096"), 0);
        }
        catch (IOException iOException) {
            if (bl) {
                logger.open();
            }
            logger.log(32, iOException.toString());
            Broker.getBroker().exit(14, iOException.toString(), 2);
        }
    }

    public int getDiagInterval() {
        return this.diagInterval;
    }

    private void parsePassfile() throws FileNotFoundException {
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = null;
        String string2 = null;
        if (brokerConfig.getBooleanProperty("imq.passfile.enabled")) {
            string = brokerConfig.getProperty("imq.passfile.dirpath");
            string2 = string != null ? (string = StringUtil.expandVariables(string, (Properties)brokerConfig)) : brokerConfig.getProperty("imq.etchome") + File.separator + "security";
            String string3 = string2 + File.separator + brokerConfig.getProperty("imq.passfile.name");
            File file = new File(string3);
            if (file.exists()) {
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(string3);
                    properties.load(fileInputStream);
                    if (this.dbPWOverride) {
                        properties.put(this.dbPWProp, brokerConfig.getProperty(this.dbPWProp));
                    }
                    if (this.ldapPWOverride) {
                        properties.put(this.ldapPWProp, brokerConfig.getProperty(this.ldapPWProp));
                    }
                    if (this.keystorePWOverride) {
                        properties.put(this.keystorePWProp, brokerConfig.getProperty(this.keystorePWProp));
                    }
                }
                catch (IOException iOException) {
                    this.logger.log(32, this.rb.getKString("B4023"), iOException);
                }
                brokerConfig.putAll((Map)properties);
            } else {
                throw new FileNotFoundException(this.rb.getKString("B3020", (Object)string3));
            }
        }
    }

    public void println(String string) {
        if (!this.silent) {
            System.out.println(string);
        }
    }

    public void printErr(String string) {
        if (!this.silent) {
            System.err.println(string);
        }
    }

    public void exit(int n, String string, int n2) {
        this.exit(n, string, n2, null);
    }

    public void exit(int n, String string, int n2, Throwable throwable) {
        boolean bl;
        Globals.getLogger().log(4, "Broker exiting with status=" + n + " because " + string);
        boolean bl2 = runningInProcess;
        boolean bl3 = bl = !runningInProcess;
        if (bkrnotify != null) {
            bl2 = bkrnotify.exitRequested(n2, string, throwable);
        }
        if (bl2) {
            Broker.destroyBroker(!bl);
        }
        if (bl) {
            System.exit(n);
        }
    }

    public boolean handleGlobalError(Throwable throwable, String string) {
        int n = Globals.getBrokerStateHandler().getRestartCode();
        if (throwable instanceof OutOfMemoryError) {
            this.logger.logStack(32, "Received Out Of Memory Error [" + string + "]", throwable);
            if (bkrnotify != null) {
                Broker.getBroker().exit(n, "Received Out Of Memory Error [" + string + "]", 3, throwable);
            }
            if (!runningInProcess) {
                Globals.getMemManager().forceRedState();
            }
            return true;
        }
        Broker.getBroker().exit(n, "Unexpected Exception " + string, 4, throwable);
        return false;
    }

    class BrokerDiagTask
    extends JMQTimerTask {
        BrokerDiagTask() {
        }

        public void run() {
            String string = DiagManager.allToString();
            if (string != null) {
                Broker.this.logger.log(8, string);
            }
        }
    }
}

