/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.io.VRFileMap;
import com.sun.messaging.jmq.io.VRecordMap;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PHashMapMMF
extends PHashMap {
    static final byte[] CLIENT_DATA_MARKER = new byte[]{37, 67, 68};
    int maxClientDataSize = 0;

    public PHashMapMMF(File file, boolean bl, boolean bl2) throws IOException {
        this(file, 0xA00000L, bl, bl2);
    }

    public PHashMapMMF(File file, long l, boolean bl, boolean bl2) throws IOException {
        super(file, l, bl, bl2);
    }

    protected void initBackingFile(File file, long l) {
        this.backingFile = new VRFileMap(file, l);
    }

    public void intClientData(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid client data size");
        }
        this.maxClientDataSize = n;
    }

    public void load() throws IOException, ClassNotFoundException, PHashMapLoadException {
        Object object = null;
        Set set = this.backingFile.getRecords();
        this.recordMap = new HashMap(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object2;
            VRecordMap vRecordMap = (VRecordMap)iterator.next();
            Object object3 = null;
            Object object4 = null;
            Throwable throwable = null;
            Throwable throwable2 = null;
            IOException iOException = null;
            try {
                object2 = vRecordMap.getBuffer();
                ((ByteBuffer)object2).position(0);
                int n = ((Buffer)object2).limit();
                byte[] byArray = new byte[n];
                ((ByteBuffer)object2).get(byArray);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                try {
                    object3 = objectInputStream.readObject();
                }
                catch (Throwable throwable3) {
                    if (throwable3 instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)throwable3;
                    }
                    throwable = throwable3;
                }
                try {
                    object4 = objectInputStream.readObject();
                }
                catch (Throwable throwable4) {
                    if (throwable4 instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)throwable4;
                    }
                    throwable2 = throwable4;
                }
                if (this.maxClientDataSize > 0) {
                    int n2 = n - byteArrayInputStream.available();
                    ((ByteBuffer)object2).position(n2);
                    ((ByteBuffer)object2).mark();
                }
                objectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (throwable != null || throwable2 != null || iOException != null) {
                object2 = new PHashMapLoadException("Failed to load data in [" + vRecordMap.toString() + "]");
                ((PHashMapLoadException)object2).setKey(object3);
                ((PHashMapLoadException)object2).setValue(object4);
                ((PHashMapLoadException)object2).setKeyCause(throwable);
                ((PHashMapLoadException)object2).setValueCause(throwable2);
                ((PHashMapLoadException)object2).setNextException((PHashMapLoadException)object);
                ((Throwable)object2).initCause(iOException);
                object = object2;
                if (object3 != null) {
                    this.recordMap.put(object3, vRecordMap);
                    this.putInHashMap(object3, object4);
                    continue;
                }
                this.backingFile.free(vRecordMap);
                continue;
            }
            this.recordMap.put(object3, vRecordMap);
            this.putInHashMap(object3, object4);
        }
        this.loaded = true;
        if (object != null) {
            throw object;
        }
    }

    public final Object put(Object object, Object object2) {
        this.checkLoaded();
        try {
            VRecordMap vRecordMap;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.writeObject(object2);
            objectOutputStream.flush();
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            if (this.maxClientDataSize > 0) {
                n += this.maxClientDataSize + CLIENT_DATA_MARKER.length;
            }
            if ((vRecordMap = (VRecordMap)this.recordMap.get(object)) == null) {
                vRecordMap = (VRecordMap)this.backingFile.allocate(n);
            } else if (vRecordMap.getDataCapacity() < n) {
                this.backingFile.free(vRecordMap);
                vRecordMap = (VRecordMap)this.backingFile.allocate(n);
            }
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)vRecordMap.getBuffer();
            mappedByteBuffer.rewind();
            mappedByteBuffer.put(byArray);
            if (this.maxClientDataSize > 0) {
                mappedByteBuffer.mark();
            }
            if (this.safe) {
                vRecordMap.force();
            }
            this.recordMap.put(object, vRecordMap);
            return this.putInHashMap(object, object2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public final Object put(Object object, Object object2, boolean bl) {
        if (bl) {
            return this.put(object, object2);
        }
        this.checkLoaded();
        return this.putInHashMap(object, object2);
    }

    public final void putClientData(Object object, byte[] byArray) {
        this.checkLoaded();
        if (this.maxClientDataSize <= 0) {
            throw new IllegalStateException("Client data size has not been initialized");
        }
        if (byArray.length > this.maxClientDataSize) {
            throw new IllegalArgumentException("Client data size of " + byArray.length + " bytes is larger than the byte limit (maxClientDataSize) of " + this.maxClientDataSize + " [key=" + object + ", cData=" + byArray + "]");
        }
        VRecordMap vRecordMap = (VRecordMap)this.recordMap.get(object);
        if (vRecordMap == null) {
            throw new IllegalStateException("Record not found [key=" + object + ", cData=" + byArray + "]");
        }
        try {
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)vRecordMap.getBuffer();
            try {
                mappedByteBuffer.reset();
            }
            catch (InvalidMarkException invalidMarkException) {
                this.setClientDataMarker(mappedByteBuffer);
            }
            mappedByteBuffer.put(CLIENT_DATA_MARKER);
            mappedByteBuffer.put(byArray);
            if (this.safe) {
                vRecordMap.force();
            }
            this.recordMap.put(object, vRecordMap);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to update client data [key=" + object + ", cData=" + byArray + "]", iOException);
        }
    }

    public final byte[] getClientData(Object object) {
        byte[] byArray;
        block5: {
            byArray = null;
            try {
                VRecordMap vRecordMap;
                if (this.maxClientDataSize <= 0 || (vRecordMap = (VRecordMap)this.recordMap.get(object)) == null) break block5;
                ByteBuffer byteBuffer = vRecordMap.getBuffer();
                try {
                    byteBuffer.reset();
                }
                catch (InvalidMarkException invalidMarkException) {
                    this.setClientDataMarker(byteBuffer);
                }
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                byte by3 = byteBuffer.get();
                if (by == CLIENT_DATA_MARKER[0] && by2 == CLIENT_DATA_MARKER[1] && by3 == CLIENT_DATA_MARKER[2]) {
                    byArray = new byte[this.maxClientDataSize];
                    byteBuffer.get(byArray);
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return byArray;
    }

    private void setClientDataMarker(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit();
        for (int i = 0; i < n; ++i) {
            if (byteBuffer.get(i) != CLIENT_DATA_MARKER[0] || i + 2 >= n || byteBuffer.get(i + 1) != CLIENT_DATA_MARKER[1] || byteBuffer.get(i + 2) != CLIENT_DATA_MARKER[2]) continue;
            byteBuffer.position(i);
            byteBuffer.mark();
            return;
        }
        Object object = null;
        Object object2 = null;
        Throwable throwable = null;
        Throwable throwable2 = null;
        IOException iOException = null;
        try {
            byteBuffer.position(0);
            int n2 = byteBuffer.limit();
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
            try {
                object2 = objectInputStream.readObject();
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
            }
            if (this.maxClientDataSize > 0) {
                int n3 = n2 - byteArrayInputStream.available();
                byteBuffer.position(n3);
                byteBuffer.mark();
            }
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (throwable != null || throwable2 != null || iOException != null) {
            PHashMapLoadException pHashMapLoadException = new PHashMapLoadException("Failed to set client data marker");
            pHashMapLoadException.setKey(object);
            pHashMapLoadException.setValue(object2);
            pHashMapLoadException.setKeyCause(throwable);
            pHashMapLoadException.setValueCause(throwable2);
            pHashMapLoadException.initCause(iOException);
            throw new RuntimeException(pHashMapLoadException);
        }
    }
}

