/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.ObjectName;

public class JVMOptionsHandler {
    public static final String OBJECT_NAME = "objectName";
    public static final String PROPERTY_VALUE = "propertyValue";
    private static final String ATTRIBUTE_NAME = "jvm-options";
    private static final String JVM_OPTION_SECURITY_MANAGER = "-Djava.security.manager";
    private static final String JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL = "-Djava.security.manager=";

    private CCActionTableModelInterface getModel(HandlerContext handlerCtx, ViewDescriptor desc) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
        model.setRowSelectionType("multiple");
        if (model == null) {
            throw new FrameworkException("JVMOptionsHandler.getModel: No Model Specified.", desc, handlerCtx.getView());
        }
        return model;
    }

    private void loadModel(CCActionTableModelInterface model, String[] list) throws ModelControlException {
        model.beforeFirst();
        for (int rowNo = 0; rowNo < list.length; ++rowNo) {
            model.appendRow();
            model.setValue(PROPERTY_VALUE, (Object)list[rowNo]);
            model.setRowSelected(false);
        }
    }

    public void populateModel(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else {
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
            desc = descView.getViewDescriptor();
        }
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String[] jvmOptions = null;
        try {
            jvmOptions = (String[])MBeanUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
        }
        catch (Exception ex) {
            return;
        }
        try {
            CCActionTableModelInterface model = this.getModel(handlerCtx, desc);
            ((DefaultModel)model).clear();
            this.loadModel(model, jvmOptions);
        }
        catch (Exception ex) {
            throw new FrameworkException("populatePropsTableModel: Loading error. ", (Throwable)ex, desc, view);
        }
    }

    public void addProperty(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        try {
            CCActionTableModelInterface model = this.getModel(handlerCtx, vd);
            model.appendRow();
            model.setValue(PROPERTY_VALUE, (Object)"");
            model.beforeFirst();
        }
        catch (Exception ex) {
            throw new FrameworkException("JVMOptionsHandler.addProperty: ", (Throwable)ex, vd, view);
        }
    }

    public void updateOptions(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        CCActionTableModelInterface model = this.getModel(handlerCtx, vd);
        ArrayList<String> options = new ArrayList<String>();
        try {
            model.beforeFirst();
            while (model.next()) {
                String value = (String)model.getValue(PROPERTY_VALUE);
                if (value == null || value.trim().equals("")) continue;
                options.add(value);
                model.setRowSelected(false);
            }
            String[] jvmOptions = options.toArray(new String[0]);
            Attribute attr = new Attribute(ATTRIBUTE_NAME, jvmOptions);
            MBeanUtil.setAttribute(objectName, attr);
            ((DefaultModel)model).clear();
        }
        catch (Exception ex) {
            throw new FrameworkException("JVMOptionsHandler.updateOptions: ", (Throwable)ex, vd, view);
        }
    }

    public void deleteOptions(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String objectName = (String)ctx.getRequest().getAttribute(OBJECT_NAME);
        CCActionTableModelInterface model = this.getModel(handlerCtx, vd);
        ArrayList<String> options = new ArrayList<String>();
        try {
            model.beforeFirst();
            while (model.next()) {
                String value = (String)model.getValue(PROPERTY_VALUE);
                if (value == null || value.trim().equals("") || model.isRowSelected()) continue;
                options.add(value);
            }
            String[] jvmOptions = options.toArray(new String[0]);
            ((DefaultModel)model).clear();
            this.loadModel(model, jvmOptions);
        }
        catch (Exception ex) {
            throw new FrameworkException("JVMOptionsHandler.deleteOptions: ", (Throwable)ex, vd, view);
        }
    }

    public void getSecurityManagerStatus(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        if (objectName == null) {
            throw new FrameworkException("JVMOptionsHandler.getSecurityManagerStatus requires INPUT objectName");
        }
        Boolean status = this.isSecurityManagerEnabled(objectName);
        handlerCtx.setOutputValue("securityManagerEnabled", (Object)status.toString());
    }

    private Boolean isSecurityManagerEnabled(String objectName) {
        String[] jvmOptions = null;
        try {
            jvmOptions = (String[])MBeanUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
            if (jvmOptions != null) {
                for (int i = 0; i < jvmOptions.length; ++i) {
                    if (!jvmOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) && !jvmOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                    return Boolean.TRUE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Boolean.FALSE;
    }

    public void setSecurityManager(RequestContext ctx, HandlerContext handlerCtx) {
        Boolean userValue;
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String value = (String)handlerCtx.getInputValue("value");
        if (objectName == null || value == null) {
            throw new FrameworkException("JVMOptionsHandler.setSecurityManager requires INPUT objectName and value");
        }
        Boolean status = this.isSecurityManagerEnabled(objectName);
        if (status.equals(userValue = new Boolean(value))) {
            return;
        }
        ArrayList<String> newOptions = new ArrayList<String>();
        try {
            int i;
            String[] origOptions = (String[])MBeanUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
            if (userValue.booleanValue()) {
                for (i = 0; i < origOptions.length; ++i) {
                    newOptions.add(origOptions[i]);
                }
                newOptions.add(JVM_OPTION_SECURITY_MANAGER);
            } else {
                for (i = 0; i < origOptions.length; ++i) {
                    if (origOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) || origOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                    newOptions.add(origOptions[i]);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String[] jvmOptions = newOptions.toArray(new String[0]);
        Attribute attr = new Attribute(ATTRIBUTE_NAME, jvmOptions);
        MBeanUtil.setAttribute(objectName, attr);
    }
}

