/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModelImpl;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.tree.MonitorTreeModelImpl;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.web.ui.common.CCI18N;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class Util {
    private static final String SELECTEDNODE = "selectedNode";
    private static final String TREE_MODEL_TYPE = "treeModelType";
    public static final String DEFAULT_TREE_MODEL_TYPE = "index";
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public static String getMessage(String key) {
        CCI18N i18n = null;
        RequestContext ctx = RequestManager.getRequestContext();
        i18n = (CCI18N)ctx.getRequest().getAttribute("__i18nObject");
        if (i18n == null) {
            i18n = new CCI18N(ctx, "com.sun.enterprise.tools.admingui.resources.Resources");
            ctx.getRequest().setAttribute("__i18nObject", (Object)i18n);
        }
        return i18n.getMessage(key);
    }

    public static String getMessage(String key, Object[] args) {
        CCI18N i18n = null;
        RequestContext ctx = RequestManager.getRequestContext();
        i18n = (CCI18N)ctx.getRequest().getAttribute("__i18nObject");
        if (i18n == null) {
            i18n = new CCI18N(ctx, "com.sun.enterprise.tools.admingui.resources.Resources");
            ctx.getRequest().setAttribute("__i18nObject", (Object)i18n);
        }
        return i18n.getMessage(key, args);
    }

    public static void setCurrentTreeModelType(RequestContext rc, String modelType) {
        rc.getRequest().getSession().setAttribute(TREE_MODEL_TYPE, (Object)modelType);
    }

    public static String getCurrentTreeModelType(RequestContext rc) {
        String modelType = (String)rc.getRequest().getSession().getAttribute(TREE_MODEL_TYPE);
        if (modelType == null) {
            modelType = DEFAULT_TREE_MODEL_TYPE;
        }
        return modelType;
    }

    public static IndexTreeModel getCurrentTreeModel() {
        RequestContext rc = RequestManager.getRequestContext();
        String modelType = Util.getCurrentTreeModelType(rc);
        if (modelType.equals(DEFAULT_TREE_MODEL_TYPE)) {
            return IndexTreeModelImpl.getIndexTreeModel(rc);
        }
        if (modelType.equals("monitor")) {
            return MonitorTreeModelImpl.getIndexTreeModel(rc);
        }
        throw new RuntimeException("Invalid model type specified.");
    }

    public static void setCurrentViewURL(String viewName) {
        RequestContext rc = RequestManager.getRequestContext();
        rc.getRequest().getSession().setAttribute(Util.getCurrentTreeModelType(rc), (Object)viewName);
    }

    public static String getCurrentViewURL(RequestContext rc) {
        String view;
        if (rc == null) {
            rc = RequestManager.getRequestContext();
        }
        return (view = (String)rc.getRequest().getSession().getAttribute(Util.getCurrentTreeModelType(rc))) == null ? "" : view;
    }

    public static final IndexTreeNode getSelectedNode() {
        IndexTreeModel model;
        RequestContext rc = RequestManager.getRequestContext();
        IndexTreeNode selectedNode = (IndexTreeNode)rc.getRequest().getSession().getAttribute(Util.getCurrentTreeModelType(rc) + SELECTEDNODE);
        if (selectedNode == null && (selectedNode = (IndexTreeNode)(model = Util.getCurrentTreeModel()).getCurrentNode()) == null) {
            selectedNode = model.getRoot();
        }
        return selectedNode;
    }

    public static void setSelectedNode(IndexTreeNode selectedNode) {
        RequestContext rc = RequestManager.getRequestContext();
        rc.getRequest().getSession().setAttribute(Util.getCurrentTreeModelType(rc) + SELECTEDNODE, (Object)selectedNode);
    }

    public static String URLencode(RequestContext ctx, String str) {
        String encoding = ctx.getResponse().getCharacterEncoding() != null ? ctx.getResponse().getCharacterEncoding() : "ISO-8859-1";
        try {
            str = URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String concatDelimiter(String[] str, String delimiter) {
        StringBuffer retStr = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length; ++i) {
                String element = str[i];
                if (element == null || element.length() == 0) {
                    throw new IllegalArgumentException();
                }
                retStr.append(element);
                if (i >= str.length - 1) continue;
                retStr.append(delimiter);
            }
        }
        return retStr.toString();
    }

    public static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null) {
            if (delimiter == null) {
                delimiter = " ";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                retString[i++] = tokens.nextToken();
            }
        }
        return retString;
    }

    public static HashMap stringArrayToHashMap(String[] str) {
        HashMap<String, String> h = new HashMap<String, String>();
        for (int i = 0; str != null && i < str.length; ++i) {
            h.put(str[i], str[i]);
        }
        return h;
    }

    public static String getDefaultDisplayURL(String url) {
        if (Util.isLoggableFINER()) {
            Util.logFINER("URL = /jsp/" + url);
        }
        return "/jsp/" + url;
    }

    public static String getLocalizedURL(RequestContext rc, String fileName) {
        return Util.getLocalizedURL(rc, fileName, null);
    }

    public static String getLocalizedURL(RequestContext rc, String fileName, Locale locale) {
        if (locale == null) {
            locale = Util.getLocale();
        }
        if (locale.equals(Locale.ENGLISH) || locale.getLanguage().equals("en")) {
            return fileName;
        }
        int lastdot = fileName.lastIndexOf(".");
        String newName = fileName.substring(0, lastdot) + "_" + locale.getLanguage() + fileName.substring(lastdot, fileName.length());
        try {
            Util.verifyClassExists(rc.getServletContext(), newName);
        }
        catch (ClassNotFoundException ex) {
            return fileName;
        }
        return newName;
    }

    public static String getLocalizedString(String key) {
        return key;
    }

    private static void verifyClassExists(ServletContext sc, String fileName) throws ClassNotFoundException {
        String className = null;
        if (fileName.endsWith(".jsp")) {
            className = fileName.substring(0, fileName.lastIndexOf(".jsp")) + "_jsp";
            className = className.replaceAll("/", "._");
            className = "_jasper" + className;
            try {
                Class<?> clazz = Class.forName(className);
                return;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (sc != null) {
            String path = sc.getRealPath(fileName);
            File f = new File(path);
            if (!f.exists()) {
                String msg = "";
                if (className != null) {
                    msg = "Class \"" + className + "\" not found, and";
                }
                msg = msg + "File \"" + path + "\" not found!";
                throw new ClassNotFoundException(msg);
            }
        } else {
            throw new FrameworkException("sc null");
        }
    }

    public static boolean isLoggableSEVERE() {
        return sLogger.isLoggable(Level.SEVERE);
    }

    public static void logSEVERE(String msg) {
        sLogger.log(Level.SEVERE, msg);
    }

    public static void logSEVERE(Throwable ex) {
        Util.logSEVERE("", ex);
    }

    public static void logSEVERE(String msg, Throwable ex) {
        sLogger.log(Level.SEVERE, msg, ex);
    }

    public static boolean isLoggableWARNING() {
        return sLogger.isLoggable(Level.WARNING);
    }

    public static void logWARNING(String msg) {
        sLogger.log(Level.WARNING, msg);
    }

    public static void logWARNING(Throwable ex) {
        Util.logWARNING("", ex);
    }

    public static void logWARNING(String msg, Throwable ex) {
        sLogger.log(Level.WARNING, msg, ex);
    }

    public static boolean isLoggableINFO() {
        return sLogger.isLoggable(Level.INFO);
    }

    public static void logINFO(String msg) {
        sLogger.log(Level.INFO, msg);
    }

    public static void logINFO(Throwable ex) {
        Util.logINFO("", ex);
    }

    public static void logINFO(String msg, Throwable ex) {
        sLogger.log(Level.INFO, msg, ex);
    }

    public static boolean isLoggableCONFIG() {
        return sLogger.isLoggable(Level.CONFIG);
    }

    public static void logCONFIG(String msg) {
        sLogger.log(Level.CONFIG, msg);
    }

    public static void logCONFIG(Throwable ex) {
        Util.logCONFIG("", ex);
    }

    public static void logCONFIG(String msg, Throwable ex) {
        sLogger.log(Level.CONFIG, msg, ex);
    }

    public static boolean isLoggableFINE() {
        return sLogger.isLoggable(Level.FINE);
    }

    public static void logFINE(String msg) {
        sLogger.log(Level.FINE, msg);
    }

    public static void logFINE(Throwable ex) {
        Util.logFINE("", ex);
    }

    public static void logFINE(String msg, Throwable ex) {
        sLogger.log(Level.FINE, msg, ex);
    }

    public static boolean isLoggableFINER() {
        return sLogger.isLoggable(Level.FINER);
    }

    public static void logFINER(String msg) {
        sLogger.log(Level.FINER, msg);
    }

    public static void logFINER(Throwable ex) {
        Util.logFINER("", ex);
    }

    public static void logFINER(String msg, Throwable ex) {
        sLogger.log(Level.FINER, msg, ex);
    }

    public static boolean isLoggableFINEST() {
        return sLogger.isLoggable(Level.FINEST);
    }

    public static void logFINEST(String msg) {
        sLogger.log(Level.FINEST, msg);
    }

    public static void logFINEST(Throwable ex) {
        Util.logFINEST("", ex);
    }

    public static void logFINEST(String msg, Throwable ex) {
        sLogger.log(Level.FINEST, msg, ex);
    }

    public static String getLocalizedHTML(RequestContext rc, String fileName) {
        return Util.getLocalizedHTML(rc, fileName, null);
    }

    public static String getLocalizedHTML(RequestContext rc, String fileName, Locale locale) {
        if (locale == null) {
            locale = Util.getLocale();
        }
        if (locale.equals(Locale.ENGLISH) || locale.getLanguage() == null || locale.getLanguage().equalsIgnoreCase("null") || locale.getLanguage().equals("en")) {
            return fileName;
        }
        int lastdot = fileName.lastIndexOf(".html");
        String newName = fileName.substring(0, lastdot) + "_" + locale.getLanguage() + ".html";
        String path = rc.getServletContext().getRealPath(newName);
        File f = new File(path);
        if (!f.exists()) {
            if (Util.isLoggableWARNING()) {
                Util.logWARNING("AdminGUI: " + path + " File Not Found");
            }
            return fileName;
        }
        return newName;
    }

    public static String getMessage(String baseName, String key, Object[] args) {
        return Util.getMessage(baseName, key, args, null);
    }

    public static String getMessage(String baseName, String key, Object[] args, Locale locale) {
        if (key == null) {
            return null;
        }
        if (locale == null) {
            locale = Util.getLocale();
        }
        ResourceBundle bundle = Util.getResourceBundle(baseName, locale);
        if (args == null) {
            return Util.getMessageFromBundle(key, bundle);
        }
        String pattern = Util.getMessageFromBundle(key, bundle);
        MessageFormat mf = new MessageFormat(pattern);
        Object[] mfArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            mfArgs[i] = Util.getMessageFromBundle(args[i].toString(), bundle);
        }
        key = mf.format(mfArgs);
        return key;
    }

    private static Locale getLocale() {
        RequestContext ctx = RequestManager.getRequestContext();
        Locale locale = null;
        if (ctx != null) {
            HttpServletRequest request = ctx.getRequest();
            try {
                locale = request.getLocale();
            }
            catch (Exception ex) {
                locale = Locale.getDefault();
            }
        }
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String fileReader(String fileName) throws FileNotFoundException, IOException {
        StringWriter sr = new StringWriter();
        try {
            FileReader fr = new FileReader(fileName);
            char[] buf = new char[1024];
            int len = 0;
            while (len != -1) {
                try {
                    len = fr.read(buf, 0, buf.length);
                }
                catch (EOFException eof) {
                    break;
                }
                if (len == -1) continue;
                sr.write(buf, 0, len);
            }
            fr.close();
            sr.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return sr.toString();
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() == 0;
    }

    private static String getMessageFromBundle(String key, ResourceBundle bundle) {
        try {
            key = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return key;
    }

    private static ResourceBundle getResourceBundle(String baseName, Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(baseName, locale);
        }
        catch (MissingResourceException ex) {
            try {
                bundle = ResourceBundle.getBundle(baseName);
            }
            catch (MissingResourceException ex1) {
                bundle = ResourceBundle.getBundle("com.sun.enterprise.tools.admingui.resources.Resources");
            }
        }
        return bundle;
    }

    public static String addHtmlProp(String tag, String addText) {
        int i = tag.indexOf(32);
        if (i < 0) {
            return tag;
        }
        return tag.substring(0, i) + " " + addText + tag.substring(i, tag.length());
    }

    public static String removeHtmlProp(String tag, String prop) {
        int i = tag.indexOf(prop);
        if (i < 0) {
            return tag;
        }
        int j = tag.indexOf(34, i + 2 + prop.length());
        if (j < 0) {
            return tag;
        }
        return tag.substring(0, i) + tag.substring(j + 1, tag.length());
    }

    public static String extractHtmlProp(String tag, String prop) {
        int i = tag.indexOf(prop);
        if (i < 0) {
            return "";
        }
        int j = tag.indexOf(34, i + 2 + prop.length());
        if (j < 0) {
            return "";
        }
        return tag.substring(i + 2 + prop.length(), j);
    }

    public static List parseStringList(String line) {
        return Util.parseStringList(line, null);
    }

    public static List parseStringList(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        Vector<String> tokens = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String getFormattedDate(long time, int dateStyle) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, 2, Util.getLocale());
        String formattedDate = df.format(new Date(time));
        return formattedDate;
    }

    public static String getDomainRoot() {
        String domainRoot = System.getProperty("com.sun.aas.instanceRoot");
        return domainRoot;
    }
}

