/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.BCELCopierGenerator;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierBase;
import com.sun.corba.ee.impl.copyobject.newreflect.PipelineClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import com.sun.corba.ee.spi.orbutil.misc.ORBClassLoader;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.corba.Bridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCopierOrdinaryImpl
extends ClassCopierBase {
    public static final String OS_NAME_KEY = "os.name";
    public static final String MAC_OS_PREFIX = "Mac";
    public static final String VM_NAME_KEY = "java.vm.name";
    public static final String SERVER_VM_NAME = "Java HotSpot(TM) Server VM";
    public static final String CLIENT_VM_NAME = "Java HotSpot(TM) Client VM";
    public static final String VERSION_KEY = "java.version";
    public static final int MINIMUM_SAFE_142_PATCH_LEVEL = 5;
    public static final int MINIMUM_SAFE_MAJOR_VERSION = 5;
    private static final Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Bridge.get();
        }
    });
    private static Map<Class<?>, ClassFieldCopier> classToClassFieldCopier = new WeakHashMap();
    private static Map classToConstructor = new WeakHashMap();
    private PipelineClassCopierFactory classCopierFactory;
    private ClassFieldCopier classFieldCopier;
    private Constructor constructor;
    private Method readResolveMethod;

    public static boolean jdkSupportsUnsafe() {
        return true;
    }

    public static boolean jdkSupportsUnsafe(String vmName, String version, String osName) {
        if (version.startsWith("1.4.2")) {
            StringTokenizer st;
            int numTokens;
            if (osName.startsWith(MAC_OS_PREFIX)) {
                return false;
            }
            if (vmName.equals(SERVER_VM_NAME)) {
                return true;
            }
            int dashIndex = version.indexOf(45);
            if (dashIndex > 0) {
                version = version.substring(0, dashIndex);
            }
            if ((numTokens = (st = new StringTokenizer(version, "_")).countTokens()) != 2) {
                return false;
            }
            st.nextToken();
            try {
                int patch = Integer.parseInt(st.nextToken());
                return patch >= 5;
            }
            catch (Exception exc) {
                return false;
            }
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        int numTokens = st.countTokens();
        if (numTokens != 3) {
            return false;
        }
        st.nextToken();
        int major = Integer.parseInt(st.nextToken());
        return major >= 5;
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        Package pkg2;
        Package pkg1 = cl1.getPackage();
        return pkg1 == (pkg2 = cl2.getPackage()) || pkg1 != null && pkg1.equals(pkg2);
    }

    private static Method getInheritableMethod(final Class<?> cl, final String name, final Class<?> returnType, final Class<?> ... argTypes) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class defCl;
                Method meth = null;
                for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
                    try {
                        meth = defCl.getDeclaredMethod(name, argTypes);
                        break;
                    }
                    catch (NoSuchMethodException ex) {
                        continue;
                    }
                }
                if (meth == null || meth.getReturnType() != returnType) {
                    return null;
                }
                meth.setAccessible(true);
                int mods = meth.getModifiers();
                if ((mods & 0x408) != 0) {
                    return null;
                }
                if ((mods & 5) != 0) {
                    return meth;
                }
                if ((mods & 2) != 0) {
                    return cl == defCl ? meth : null;
                }
                return ClassCopierOrdinaryImpl.packageEquals(cl, defCl) ? meth : null;
            }
        });
    }

    private Object resolve(Object obj) {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(obj, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return obj;
    }

    private static boolean useBCELCopier() {
        return Boolean.getBoolean("com.sun.corba.ee.ORBUseBCELReflectiveCopyobject");
    }

    private static synchronized ClassFieldCopier getClassFieldCopier(final Class<?> cls, final PipelineClassCopierFactory classCopierFactory) throws ReflectiveCopyException {
        ClassFieldCopier copier = classToClassFieldCopier.get(cls);
        if (copier == null) {
            try {
                copier = (ClassFieldCopier)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ReflectiveCopyException {
                        if (ClassCopierOrdinaryImpl.jdkSupportsUnsafe()) {
                            if (ClassCopierOrdinaryImpl.useBCELCopier()) {
                                return ClassCopierOrdinaryImpl.makeClassFieldCopierUnsafeBCELImpl(cls, classCopierFactory);
                            }
                            return new ClassFieldCopierUnsafeImpl(cls, classCopierFactory);
                        }
                        return new ClassFieldCopierReflectiveImpl(cls, classCopierFactory);
                    }
                });
            }
            catch (PrivilegedActionException exc) {
                throw (ReflectiveCopyException)exc.getException();
            }
            classToClassFieldCopier.put(cls, copier);
        }
        return copier;
    }

    private static synchronized ClassFieldCopier getSuperCopier(PipelineClassCopierFactory ccf, Class<?> cls) throws ReflectiveCopyException {
        Class<?> superClass = cls.getSuperclass();
        ClassFieldCopier superCopier = null;
        if (superClass != Object.class && superClass != null) {
            ClassCopier cachedCopier = ccf.lookupInCache(superClass);
            if (cachedCopier != null && !cachedCopier.isReflectiveClassCopier()) {
                throw new ReflectiveCopyException("Cannot create ClassFieldCopier for superclass " + superClass.getName() + ": This class already has a ClassCopier.");
            }
            if (!ccf.reflectivelyCopyable(superClass)) {
                throw new ReflectiveCopyException("Cannot create ClassFieldCopier for superclass " + superClass.getName() + ": This class cannot be copied.");
            }
            superCopier = ClassCopierOrdinaryImpl.getClassFieldCopier(superClass, ccf);
        }
        return superCopier;
    }

    private static synchronized ClassFieldCopier makeClassFieldCopierUnsafeBCELImpl(Class<?> cls, PipelineClassCopierFactory classCopierFactory) throws ReflectiveCopyException {
        Constructor cons = (Constructor)classToConstructor.get(cls);
        if (cons == null) {
            String className = "com.sun.corba.ee.impl.generated.copiers." + cls.getName() + "Copier";
            BCELCopierGenerator generator = new BCELCopierGenerator(className, cls);
            ProtectionDomain pd = cls.getProtectionDomain();
            Class copierClass = generator.create(pd, ORBClassLoader.getClassLoader());
            try {
                cons = copierClass.getDeclaredConstructor(PipelineClassCopierFactory.class, ClassFieldCopier.class);
            }
            catch (Exception exc) {
                ReflectiveCopyException rce = new ReflectiveCopyException("Could not access unsafe BCEL copier constructor");
                rce.initCause(exc);
                throw rce;
            }
            classToConstructor.put(cls, cons);
        }
        ClassFieldCopier copier = null;
        try {
            ClassFieldCopier superCopier = ClassCopierOrdinaryImpl.getSuperCopier(classCopierFactory, cls);
            Object[] args = new Object[]{classCopierFactory, superCopier};
            copier = (ClassFieldCopier)cons.newInstance(args);
        }
        catch (Exception exc) {
            ReflectiveCopyException rce = new ReflectiveCopyException("Could not create unsafe BCEL copier");
            rce.initCause(exc);
            throw rce;
        }
        return copier;
    }

    public ClassCopierOrdinaryImpl(PipelineClassCopierFactory ccf, Class<?> cls) throws ReflectiveCopyException {
        super(cls.getName(), true);
        this.classCopierFactory = ccf;
        this.classFieldCopier = ClassCopierOrdinaryImpl.getClassFieldCopier(cls, ccf);
        this.constructor = ConstructorFactory.makeConstructor(cls);
        this.readResolveMethod = ClassCopierOrdinaryImpl.getInheritableMethod(cls, "readResolve", Object.class, new Class[0]);
    }

    @Override
    public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Exception exc) {
            throw new ReflectiveCopyException("Failure in newInstance for constructor " + this.constructor, exc);
        }
    }

    @Override
    public Object doCopy(Map oldToNew, Object source, Object result, boolean debug) throws ReflectiveCopyException {
        this.classFieldCopier.copy(oldToNew, source, result, debug);
        return this.resolve(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassFieldCopierUnsafeImpl
    implements ClassFieldCopier {
        private Class<?> myClass;
        private long[] fieldOffsets;
        private UnsafeFieldCopier[] fieldCopiers;
        private PipelineClassCopierFactory classCopierFactory;
        private ClassFieldCopier superCopier;
        private static UnsafeFieldCopier byteUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                byte value = bridge.getByte(src, offset);
                bridge.putByte(dest, offset, value);
            }

            public String toString() {
                return "byteUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier charUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                char value = bridge.getChar(src, offset);
                bridge.putChar(dest, offset, value);
            }

            public String toString() {
                return "charUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier shortUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                short value = bridge.getShort(src, offset);
                bridge.putShort(dest, offset, value);
            }

            public String toString() {
                return "shortUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier intUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                int value = bridge.getInt(src, offset);
                bridge.putInt(dest, offset, value);
            }

            public String toString() {
                return "intUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier longUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                long value = bridge.getLong(src, offset);
                bridge.putLong(dest, offset, value);
            }

            public String toString() {
                return "longUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier booleanUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                boolean value = bridge.getBoolean(src, offset);
                bridge.putBoolean(dest, offset, value);
            }

            public String toString() {
                return "booleanUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier floatUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                float value = bridge.getFloat(src, offset);
                bridge.putFloat(dest, offset, value);
            }

            public String toString() {
                return "floatUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier doubleUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) {
                double value = bridge.getDouble(src, offset);
                bridge.putDouble(dest, offset, value);
            }

            public String toString() {
                return "doubleUnsafeFieldCopier";
            }
        };
        private UnsafeFieldCopier objectUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            private void debugCopy(Map oldToNew, long offset, Object src, Object dest) throws ReflectiveCopyException {
                System.out.println("START objectUnsafeFieldCopier: src = " + src);
                try {
                    Object obj = bridge.getObject(src, offset);
                    Object result = null;
                    if (obj != null) {
                        ClassCopier copier = ClassFieldCopierUnsafeImpl.this.classCopierFactory.getClassCopier(obj.getClass());
                        result = copier.copy(oldToNew, obj, true);
                    }
                    System.out.println("IN    objectUnsafeFieldCopier: src = " + src + " successful copy");
                    bridge.putObject(dest, offset, result);
                }
                catch (ReflectiveCopyException exc) {
                    System.out.println("IN    objectUnsafeFieldCopier: src = " + src + " Exception " + exc);
                    exc.printStackTrace();
                    throw exc;
                }
                finally {
                    System.out.println("END   objectUnsafeFieldCopier: src = " + src);
                }
            }

            private void noDebugCopy(Map oldToNew, long offset, Object src, Object dest) throws ReflectiveCopyException {
                Object obj = bridge.getObject(src, offset);
                Object result = null;
                if (obj != null) {
                    ClassCopier copier = ClassFieldCopierUnsafeImpl.this.classCopierFactory.getClassCopier(obj.getClass());
                    result = copier.copy(oldToNew, obj);
                }
                bridge.putObject(dest, offset, result);
            }

            public void copy(Map oldToNew, long offset, Object src, Object dest, boolean debug) throws ReflectiveCopyException {
                if (debug) {
                    this.debugCopy(oldToNew, offset, src, dest);
                } else {
                    this.noDebugCopy(oldToNew, offset, src, dest);
                }
            }

            public String toString() {
                return "objectUnsafeFieldCopier";
            }
        };

        private UnsafeFieldCopier getUnsafeFieldCopier(Field fld) {
            if (fld.getType().equals(Byte.TYPE)) {
                return byteUnsafeFieldCopier;
            }
            if (fld.getType().equals(Character.TYPE)) {
                return charUnsafeFieldCopier;
            }
            if (fld.getType().equals(Short.TYPE)) {
                return shortUnsafeFieldCopier;
            }
            if (fld.getType().equals(Integer.TYPE)) {
                return intUnsafeFieldCopier;
            }
            if (fld.getType().equals(Long.TYPE)) {
                return longUnsafeFieldCopier;
            }
            if (fld.getType().equals(Boolean.TYPE)) {
                return booleanUnsafeFieldCopier;
            }
            if (fld.getType().equals(Float.TYPE)) {
                return floatUnsafeFieldCopier;
            }
            if (fld.getType().equals(Double.TYPE)) {
                return doubleUnsafeFieldCopier;
            }
            return this.objectUnsafeFieldCopier;
        }

        private boolean fieldIsCopyable(Field field) {
            int modifiers = field.getModifiers();
            boolean result = !Modifier.isStatic(modifiers);
            return result;
        }

        public ClassFieldCopierUnsafeImpl(Class<?> cls, PipelineClassCopierFactory ccf) throws ReflectiveCopyException {
            this.myClass = cls;
            this.classCopierFactory = ccf;
            this.superCopier = ClassCopierOrdinaryImpl.getSuperCopier(ccf, cls);
            Field[] fields = cls.getDeclaredFields();
            int numFields = 0;
            for (int ctr = 0; ctr < fields.length; ++ctr) {
                if (!this.fieldIsCopyable(fields[ctr])) continue;
                ++numFields;
            }
            this.fieldOffsets = new long[numFields];
            this.fieldCopiers = new UnsafeFieldCopier[numFields];
            int pos = 0;
            for (int ctr = 0; ctr < fields.length; ++ctr) {
                Field fld = fields[ctr];
                if (!this.fieldIsCopyable(fld)) continue;
                this.fieldOffsets[pos] = bridge.objectFieldOffset(fld);
                this.fieldCopiers[pos] = this.getUnsafeFieldCopier(fld);
                ++pos;
            }
        }

        public String toString() {
            return "ClassFieldCopierUnsafeImpl[" + this.myClass.getName() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugCopy(Map oldToNew, Object source, Object result) throws ReflectiveCopyException {
            System.out.println("START " + this + " : source = " + source);
            try {
                if (this.superCopier != null) {
                    ((ClassFieldCopierUnsafeImpl)this.superCopier).debugCopy(oldToNew, source, result);
                }
                for (int ctr = 0; ctr < this.fieldOffsets.length; ++ctr) {
                    System.out.println("IN    " + this + " Field " + ctr + " to be copied by " + this.fieldCopiers[ctr]);
                    this.fieldCopiers[ctr].copy(oldToNew, this.fieldOffsets[ctr], source, result, true);
                }
            }
            finally {
                System.out.println("END   ClassFieldCopierUnsafeImpl(" + this.myClass.getName() + "): source = " + source);
            }
        }

        public void noDebugCopy(Map oldToNew, Object source, Object result) throws ReflectiveCopyException {
            if (this.superCopier != null) {
                ((ClassFieldCopierUnsafeImpl)this.superCopier).noDebugCopy(oldToNew, source, result);
            }
            for (int ctr = 0; ctr < this.fieldOffsets.length; ++ctr) {
                this.fieldCopiers[ctr].copy(oldToNew, this.fieldOffsets[ctr], source, result, false);
            }
        }

        @Override
        public void copy(Map oldToNew, Object source, Object result, boolean debug) throws ReflectiveCopyException {
            this.noDebugCopy(oldToNew, source, result);
        }

        private static abstract class UnsafeFieldCopier {
            private Bridge bridge;

            public UnsafeFieldCopier(Bridge bridge) {
                this.bridge = bridge;
            }

            abstract void copy(Map var1, long var2, Object var4, Object var5, boolean var6) throws ReflectiveCopyException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassFieldCopierReflectiveImpl
    implements ClassFieldCopier {
        private Class<?> myClass;
        private Field[] fields;
        private ReflectiveFieldCopier[] fieldCopiers;
        private final PipelineClassCopierFactory classCopierFactory;
        private ClassFieldCopier superCopier;
        private static ReflectiveFieldCopier booleanReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setBoolean(dest, fld.getBoolean(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier byteReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setByte(dest, fld.getByte(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier charReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setChar(dest, fld.getChar(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier shortReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setShort(dest, fld.getShort(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier intReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setInt(dest, fld.getInt(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier longReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setLong(dest, fld.getLong(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier floatReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setFloat(dest, fld.getFloat(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private static ReflectiveFieldCopier doubleReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                try {
                    fld.setDouble(dest, fld.getDouble(src));
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in accessing field " + fld, exc);
                }
            }
        };
        private ReflectiveFieldCopier objectReflectiveFieldCopier = new ReflectiveFieldCopier(){

            public void copy(Map oldToNew, Field fld, Object src, Object dest) throws ReflectiveCopyException {
                Object obj = null;
                try {
                    obj = fld.get(src);
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in reading field " + fld, exc);
                }
                Object result = null;
                if (obj != null) {
                    ClassCopier copier = ClassFieldCopierReflectiveImpl.this.classCopierFactory.getClassCopier(obj.getClass());
                    result = copier.copy(oldToNew, obj);
                }
                try {
                    fld.set(dest, result);
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("Error in writing field " + fld, exc);
                }
            }
        };

        private ReflectiveFieldCopier getReflectiveFieldCopier(Field fld) {
            if (fld.getType().equals(Byte.TYPE)) {
                return byteReflectiveFieldCopier;
            }
            if (fld.getType().equals(Character.TYPE)) {
                return charReflectiveFieldCopier;
            }
            if (fld.getType().equals(Short.TYPE)) {
                return shortReflectiveFieldCopier;
            }
            if (fld.getType().equals(Integer.TYPE)) {
                return intReflectiveFieldCopier;
            }
            if (fld.getType().equals(Long.TYPE)) {
                return longReflectiveFieldCopier;
            }
            if (fld.getType().equals(Boolean.TYPE)) {
                return booleanReflectiveFieldCopier;
            }
            if (fld.getType().equals(Float.TYPE)) {
                return floatReflectiveFieldCopier;
            }
            if (fld.getType().equals(Double.TYPE)) {
                return doubleReflectiveFieldCopier;
            }
            return this.objectReflectiveFieldCopier;
        }

        public ClassFieldCopierReflectiveImpl(Class<?> cls, PipelineClassCopierFactory ccf) throws ReflectiveCopyException {
            this.myClass = cls;
            this.classCopierFactory = ccf;
            this.superCopier = ClassCopierOrdinaryImpl.getSuperCopier(ccf, cls);
            Field[] classFields = cls.getDeclaredFields();
            int numFields = 0;
            for (int ctr = 0; ctr < classFields.length; ++ctr) {
                if (Modifier.isStatic(classFields[ctr].getModifiers())) continue;
                ++numFields;
            }
            this.fields = new Field[numFields];
            this.fieldCopiers = new ReflectiveFieldCopier[numFields];
            int pos = 0;
            for (int ctr = 0; ctr < classFields.length; ++ctr) {
                Field fld = classFields[ctr];
                if (Modifier.isStatic(fld.getModifiers())) continue;
                if (Modifier.isFinal(fld.getModifiers())) {
                    throw new ReflectiveCopyException("Cannot use reflective copier on object with non-static final field=" + fld);
                }
                fld.setAccessible(true);
                this.fields[pos] = fld;
                this.fieldCopiers[pos] = this.getReflectiveFieldCopier(fld);
                ++pos;
            }
        }

        @Override
        public void copy(Map oldToNew, Object source, Object result, boolean debug) throws ReflectiveCopyException {
            if (this.superCopier != null) {
                this.superCopier.copy(oldToNew, source, result, debug);
            }
            for (int ctr = 0; ctr < this.fields.length; ++ctr) {
                this.fieldCopiers[ctr].copy(oldToNew, this.fields[ctr], source, result);
            }
        }

        static interface ReflectiveFieldCopier {
            public void copy(Map var1, Field var2, Object var3, Object var4) throws ReflectiveCopyException;
        }
    }

    public static interface ClassFieldCopier {
        public void copy(Map var1, Object var2, Object var3, boolean var4) throws ReflectiveCopyException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ConstructorFactory {
        private ConstructorFactory() {
        }

        private static Constructor getExternalizableConstructor(Class<?> cl) {
            try {
                Constructor<?> cons = cl.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                return (cons.getModifiers() & 1) != 0 ? cons : null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Constructor getSerializableConstructor(Class<?> cl) {
            Class<?> initCl = cl;
            while (Serializable.class.isAssignableFrom(initCl)) {
                if ((initCl = initCl.getSuperclass()) != null) continue;
                return null;
            }
            try {
                Constructor cons = initCl.getDeclaredConstructor(new Class[0]);
                int mods = cons.getModifiers();
                if ((mods & 2) != 0 || (mods & 5) == 0 && !ClassCopierOrdinaryImpl.packageEquals(cl, initCl)) {
                    return null;
                }
                cons = bridge.newConstructorForSerialization(cl, cons);
                cons.setAccessible(true);
                return cons;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Constructor getDefaultConstructor(Class<?> cl) {
            Class<?> defCl;
            Constructor cons = null;
            for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
                try {
                    cons = defCl.getDeclaredConstructor(new Class[0]);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
            if (cons == null) {
                return null;
            }
            Constructor result = defCl == cl ? cons : bridge.newConstructorForSerialization(cl, cons);
            result.setAccessible(true);
            return result;
        }

        private static Constructor makeConstructor(final Class<?> cls) {
            return (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Constructor constructor = Externalizable.class.isAssignableFrom(cls) ? ConstructorFactory.getExternalizableConstructor(cls) : (Serializable.class.isAssignableFrom(cls) ? ConstructorFactory.getSerializableConstructor(cls) : ConstructorFactory.getDefaultConstructor(cls));
                    return constructor;
                }
            });
        }
    }
}

