/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi.bcel;

import com.sun.corba.ee.impl.presentation.rmi.StubFactoryDynamicBase;
import com.sun.corba.ee.impl.presentation.rmi.StubInvocationHandlerImpl;
import com.sun.corba.ee.impl.presentation.rmi.bcel.BCELStubBase;
import com.sun.corba.ee.impl.presentation.rmi.bcel.ProxyCreator;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import org.omg.CORBA.Object;

public class StubFactoryBCELImpl
extends StubFactoryDynamicBase {
    private static final boolean USE_BCEL = true;
    private static final String BCEL_KEY = "BCELStubClass";
    private final PresentationManager pm;

    public StubFactoryBCELImpl(PresentationManager pm, PresentationManager.ClassData classData, ClassLoader loader) {
        super(classData, loader);
        this.pm = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getStubClass() {
        Class<?> stubClass = null;
        PresentationManager.ClassData classData = this.classData;
        synchronized (classData) {
            Map dictionary = this.classData.getDictionary();
            stubClass = (Class<?>)dictionary.get(BCEL_KEY);
            if (stubClass == null) {
                final Class theClass = this.classData.getMyClass();
                String stubClassName = Utility.dynamicStubName(theClass.getName());
                String baseClassName = BCELStubBase.class.getName();
                Class[] interfaces = this.classData.getIDLNameTranslator().getInterfaces();
                Method[] methods = this.classData.getIDLNameTranslator().getMethods();
                ProtectionDomain pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                    public java.lang.Object run() {
                        return theClass.getProtectionDomain();
                    }
                });
                ProxyCreator gen = new ProxyCreator(stubClassName, baseClassName, interfaces, methods);
                stubClass = gen.create(pd, this.loader, false);
                dictionary.put(BCEL_KEY, stubClass);
            }
        }
        return stubClass;
    }

    public Object makeStub() {
        BCELStubBase stub;
        Class stubClass = this.getStubClass();
        try {
            stub = (BCELStubBase)stubClass.newInstance();
        }
        catch (Exception exc) {
            throw new RuntimeException("Could not instantiate stub class " + stubClass + "!", exc);
        }
        StubInvocationHandlerImpl handler = new StubInvocationHandlerImpl(this.pm, this.classData, (Object)stub);
        stub.initialize(this.classData, handler);
        return stub;
    }
}

