/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.SFSBTxCheckpointCoordinator;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

final class ContainerSynchronization
implements Synchronization {
    private static Logger _logger = null;
    private Vector beans = new Vector();
    private Vector pmSyncs = new Vector();
    private Hashtable timerSyncs = new Hashtable();
    private Transaction tx;
    private ContainerFactoryImpl containerFactory;
    private SFSBTxCheckpointCoordinator sfsbTxCoordinator;

    ContainerSynchronization(Transaction tx, ContainerFactoryImpl containerFactory) {
        this.tx = tx;
        this.containerFactory = containerFactory;
    }

    Vector getBeanList() {
        return this.beans;
    }

    void addBean(EJBContextImpl bean) {
        if (this.beans.contains(bean)) {
            return;
        }
        this.beans.add(bean);
    }

    void removeBean(EJBContextImpl bean) {
        this.beans.remove(bean);
    }

    void addPMSynchronization(Synchronization sync) {
        this.pmSyncs.add(sync);
    }

    void addTimerSynchronization(TimerPrimaryKey timerId, Synchronization sync) {
        this.timerSyncs.put(timerId, sync);
    }

    Synchronization getTimerSynchronization(TimerPrimaryKey timerId) {
        return (Synchronization)this.timerSyncs.get(timerId);
    }

    void removeTimerSynchronization(TimerPrimaryKey timerId) {
        this.timerSyncs.remove(timerId);
    }

    public void beforeCompletion() {
        int i;
        for (i = 0; i < this.beans.size(); ++i) {
            EJBContextImpl context = (EJBContextImpl)this.beans.elementAt(i);
            BaseContainer container = (BaseContainer)context.getContainer();
            try {
                if (container != null) {
                    if (container.isUndeployed()) {
                        _logger.log(Level.WARNING, "Marking Tx for rollback  because container for " + container + " is undeployed");
                        try {
                            this.tx.setRollbackOnly();
                        }
                        catch (SystemException sysEx) {
                            _logger.log(Level.FINE, "Error while trying to mark for rollback", sysEx);
                        }
                        continue;
                    }
                    container.beforeCompletion(context);
                    continue;
                }
                _logger.log(Level.FINE, "context with empty container in  ContainerSynchronization.beforeCompletion");
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", ex);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException e) {
                    _logger.log(Level.FINE, "", ex);
                }
                return;
            }
        }
        for (i = 0; i < this.pmSyncs.size(); ++i) {
            Synchronization sync = (Synchronization)this.pmSyncs.elementAt(i);
            try {
                sync.beforeCompletion();
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", ex);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException e) {
                    _logger.log(Level.FINE, "", ex);
                }
                return;
            }
        }
    }

    public void afterCompletion(int status) {
        int i;
        for (i = 0; i < this.pmSyncs.size(); ++i) {
            Synchronization sync = (Synchronization)this.pmSyncs.elementAt(i);
            try {
                sync.afterCompletion(status);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.after_completion_error", ex);
            }
        }
        for (i = 0; i < this.beans.size(); ++i) {
            EJBContextImpl context = (EJBContextImpl)this.beans.elementAt(i);
            BaseContainer container = (BaseContainer)context.getContainer();
            try {
                if (container != null) {
                    container.afterCompletion(context, status);
                    continue;
                }
                _logger.log(Level.FINE, "context with empty container in  ContainerSynchronization.afterCompletion");
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.after_completion_error", ex);
            }
        }
        if (this.sfsbTxCoordinator != null) {
            this.sfsbTxCoordinator.doTxCheckpoint();
        }
        for (Synchronization timerSync : this.timerSyncs.values()) {
            try {
                timerSync.afterCompletion(status);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.after_completion_error", ex);
            }
        }
        this.containerFactory.removeContainerSync(this.tx);
    }

    void registerForTxCheckpoint(SessionContextImpl sessionCtx) {
        if (this.sfsbTxCoordinator == null) {
            this.sfsbTxCoordinator = new SFSBTxCheckpointCoordinator();
        }
        this.sfsbTxCoordinator.registerContext(sessionCtx);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    }
}

