/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.builder;

import com.sun.ejb.containers.BaseContainer;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.util.logging.Logger;

public abstract class BaseContainerBuilder {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected EjbDescriptor ejbDescriptor;
    protected ClassLoader loader;
    protected BaseContainer baseContainer;
    private byte[] ipAddress;
    private int port;

    public final void buildContainer(EjbDescriptor ejbDescriptor, ClassLoader loader, ConfigContext dynamicConfigContext) throws Exception {
        this.ejbDescriptor = ejbDescriptor;
        this.loader = loader;
        this.readDescriptor();
        this.baseContainer = this.createContainer(ejbDescriptor, loader);
        this.buildComponents(dynamicConfigContext);
    }

    public final BaseContainer getContainer() {
        return this.baseContainer;
    }

    public final void postInitialize(SecurityManager sm) {
        boolean hasHome;
        boolean bl = hasHome = !(this.ejbDescriptor instanceof EjbMessageBeanDescriptor);
        if (hasHome) {
            // empty if block
        }
    }

    protected abstract BaseContainer createContainer(EjbDescriptor var1, ClassLoader var2) throws Exception;

    protected abstract void buildComponents(ConfigContext var1) throws Exception;

    protected byte[] getIPAddress() {
        return this.ipAddress;
    }

    protected int getPort() {
        return this.port;
    }

    private void readDescriptor() {
        this.ipAddress = new byte[4];
        try {
            this.ipAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception ex) {
            long val = (long)System.identityHashCode(this.ipAddress) + System.currentTimeMillis();
            Utility.longToBytes(val, this.ipAddress, 0);
        }
        this.port = 8080;
    }
}

