/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise;

import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.ConfigurationImpl;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerConfiguration {
    private static Logger _logger = null;
    public static final String JNDI_NAME = "ServerConfiguration";
    private static final boolean debug = false;
    private static ServerConfiguration serverconfig;
    private Configuration config;
    private boolean remote = true;

    public static ServerConfiguration getConfiguration() {
        if (serverconfig == null) {
            serverconfig = new ServerConfiguration();
        }
        return serverconfig;
    }

    public static J2EEResourceFactory getJ2EEResourceFactory() {
        return new IASJ2EEResourceFactoryImpl();
    }

    private ServerConfiguration() {
        try {
            this.config = (Configuration)Utility.lookupObject(JNDI_NAME, Configuration.class);
        }
        catch (Exception ne) {
            try {
                this.config = new ConfigurationImpl();
                this.remote = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getProperty(String key) {
        String val = null;
        try {
            val = this.config.getProperty(key);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.getpropertry_exception", e);
        }
        return val;
    }

    public String getProperty(String key, String defaultvalue) {
        String val = defaultvalue;
        try {
            val = this.config.getProperty(key);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.getpropertry_exception", e);
        }
        if (val != null) {
            return val;
        }
        return defaultvalue;
    }

    public void setProperty(String key, String value) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot set properties n local mode");
            }
            this.config.setProperty(key, value);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.setpropertry_exception", e);
        }
    }

    public Object getObject(String key) {
        Object obj = null;
        try {
            obj = this.config.getObject(key);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.getobject_exception", e);
        }
        return obj;
    }

    public void setObject(String key, Object obj) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot set objects in local mode");
            }
            this.config.setObject(key, obj);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.setobject_exception", e);
        }
    }

    public String[] getKeys(String index) {
        String[] keys = null;
        try {
            keys = this.config.getKeys(index);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.getkey_exception", e);
        }
        return keys;
    }

    public Properties getProperties(String index) {
        Properties props = new Properties();
        try {
            String[] keys = this.config.getKeys(index);
            for (int i = 0; i < keys.length; ++i) {
                props.put(keys[i], this.getProperty(keys[i]));
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.get_put_key_exception", e);
        }
        return props;
    }

    public void removeProperty(String key) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot remove properties in local mode");
            }
            this.config.removeProperty(key);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.remove_property_exception", e);
        }
    }

    public void removeObject(String key) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot remove objects in local mode");
            }
            this.config.removeObject(key);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.remove_object_exception", e);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        serverconfig = null;
    }
}

