/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.ObjectName;

public abstract class AdminTest {
    public static void main(String[] args) {
        int length = args.length;
        AdminTest.runAdminMbeanTests();
    }

    static void runAdminMbeanTests() {
        AdminTest.println("Start....!");
        try {
            MBeanRegistry registry = MBeanRegistryFactory.getMBeanRegistry("dtds/admin-mbeans-descriptors.xml");
            ConfigContext configContext = ConfigFactory.createConfigContext("/home/kravtch/domain.xml");
            registry.generateAndRegisterAllDottedNames(configContext, "abc.def.xyz");
            if (configContext != null) {
                return;
            }
            AdminTest.title("REGISTRY (in XPath value order)");
            registry.sortRegistryEntries(1);
            AdminTest.title("ejb-container INSTANTIATION");
            String[] location = new String[]{"testdomain", "server-config"};
            BaseAdminMBean mbean = registry.instantiateMBean("ejb-container", location, null, configContext);
            AdminTest.println("" + mbean.getAttribute("cache_resize_quantity"));
            AdminTest.title("ejb-container set steady_pool_size to 20");
            AdminTest.printAllAttributes("************BEFORE SET ******", "   ", mbean);
            mbean.setAttribute(new Attribute("steady_pool_size", "20"));
            AdminTest.printAllAttributes("\n************AFTER SET******", "   ", mbean);
            mbean.setAttribute(new Attribute("steady_pool_size", "2"));
            AdminTest.title("resources Instantiate()");
            location = new String[]{"testdomain"};
            mbean = registry.instantiateMBean("resources", location, null, configContext);
            AdminTest.title("resources-> getJdbcResource()");
            Object retObject = mbean.invoke("getJdbcResource", null, null);
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("jdbc-resource-> Instantiate(jdbc/PointBase)");
            mbean = registry.instantiateMBean("jdbc-resource", new String[]{"testdomain", "jdbc/__TimerPool"}, null, configContext);
            AdminTest.println("returned jdbc-resource[jdbc/PointBase] mbean:" + mbean);
            AdminTest.title("jdbc-resource[jdbc/PointBase]-> getAttributes()");
            AdminTest.title("resources Instantiate()");
            location = new String[]{"testdomain"};
            mbean = registry.instantiateMBean("resources", location, null, configContext);
            AdminTest.title("resources-> getCustomResource()");
            retObject = mbean.invoke("getCustomResource", null, null);
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("resources-> createCustomResource(testJndiName2/testResType2/testFactoryClass2)");
            AttributeList attrs = new AttributeList();
            attrs.add(new Attribute("jndi_name", "testJndiName2"));
            attrs.add(new Attribute("res_type", "testResType2"));
            attrs.add(new Attribute("factory_class", "testFactoryClass2"));
            AdminTest.printObj("Input Attributes:", "   ", attrs);
            retObject = mbean.invoke("createCustomResource", new Object[]{attrs}, new String[]{attrs.getClass().getName()});
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("resources-> getCustomResourceByJndiName(testJndiName2)");
            retObject = mbean.invoke("getCustomResourceByJndiName", new Object[]{"testJndiName2"}, new String[]{"java.lang.String"});
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("resources-> getCustomResource()");
            retObject = mbean.invoke("getCustomResource", null, null);
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("custom-resource-> Instantiate(testJndiName2)");
            mbean = registry.instantiateMBean("custom-resource", new String[]{"testdomain", "testJndiName2"}, null, configContext);
            AdminTest.printObj("returned custom-resource[testJndiName2] mbean:", mbean);
            AdminTest.title("custom-resource[testJndiName2]-> getAttributes()");
            AdminTest.printAllAttributes("Attributes:", "   ", mbean);
            AdminTest.title("custom-resource-> Instantiate(testJndiName2) using ObjectName");
            mbean = registry.instantiateConfigMBean(new ObjectName("testdomain:type=custom-resource,jndi-name=testJndiName2,category=config"), null, configContext);
            AdminTest.printObj("returned custom-resource[testJndiName2] mbean:", mbean);
            AdminTest.title("custom-resource[testJndiName2]-> getAttributes()");
            AdminTest.printAllAttributes("Attributes:", "   ", mbean);
            AdminTest.title("resources-> getCustomResource()");
            location = new String[]{"testdomain"};
            mbean = registry.instantiateMBean("resources", location, null, configContext);
            retObject = mbean.invoke("getCustomResource", null, null);
            AdminTest.printObj("Returned object:", "  ", retObject);
            AdminTest.title("resources-> removeCustomResourceByJndiName(testJndiName2)");
            retObject = mbean.invoke("removeCustomResourceByJndiName", new Object[]{"testJndiName2"}, new String[]{"java.lang.String"});
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("resources-> getCustomResource()");
            location = new String[]{"testdomain"};
            mbean = registry.instantiateMBean("resources", location, null, configContext);
            retObject = mbean.invoke("getCustomResource", null, null);
            AdminTest.printObj("Returned object:", "  ", retObject);
            AdminTest.title("applications-> Instantantiate()");
            location = new String[]{"testdomain"};
            mbean = registry.instantiateMBean("applications", location, null, configContext);
            AdminTest.title("thread-pools Instantiate()");
            location = new String[]{"testdomain", "server-config"};
            mbean = registry.instantiateMBean("thread-pools", location, null, configContext);
            AdminTest.printObj("Returned object:", "  ", mbean);
            AdminTest.title("thread-pools-> createThreadPool");
            attrs = new AttributeList();
            attrs.add(new Attribute("thread_pool_id", "mytestThreadPool"));
            attrs.add(new Attribute("min_thread_pool_size", "100"));
            attrs.add(new Attribute("max_thread_pool_size", "200"));
            attrs.add(new Attribute("num_work_queues", "12"));
            attrs.add(new Attribute("idle_thread_timeout_in_seconds", "50"));
            AdminTest.printObj("Input Attributes:", "   ", attrs);
            retObject = mbean.invoke("createThreadPool", new Object[]{attrs}, new String[]{attrs.getClass().getName()});
            AdminTest.printObj("Returned object:", "      ", retObject);
            AdminTest.title("jdbc-connection-pool[PointBasePool] Instantiate()");
            location = new String[]{"testdomain", "PointBasePool"};
            mbean = registry.instantiateMBean("jdbc-connection-pool", location, null, configContext);
            AdminTest.printObj("Returned object:", "  ", mbean);
            AdminTest.title("jdbc-connection-pool[PointBasePool] PrintAllAttributes");
            AdminTest.printAllAttributes("Attributes:", "   ", mbean);
            AdminTest.title("jdbc-connection-pool[PointBasePool] PrintAllProperties");
            AdminTest.printAllProperties("Properties:", "   ", mbean);
            AdminTest.title("set properties: 'testPropName1' and 'testPropName2'");
            AdminTest.setConfigMbeanProperty("testPropName1", "testPropValue1", mbean);
            AdminTest.setConfigMbeanProperty("testPropName2", "testPropValue2", mbean);
            AdminTest.title("jdbc-connection-pool[PointBasePool] PrintAllProperties");
            AdminTest.printAllProperties("Properties:", "   ", mbean);
            AdminTest.title("remove properties: 'testPropName1' and 'testPropName2'");
            AdminTest.setConfigMbeanProperty("testPropName1", null, mbean);
            AdminTest.setConfigMbeanProperty("testPropName2", null, mbean);
            AdminTest.title("jdbc-connection-pool[PointBasePool] PrintAllProperties");
            AdminTest.printAllProperties("Properties:", "   ", mbean);
            AdminTest.title("jdbc-connection-pool.getDefaultAttributeValue[max-pool-size]");
            AdminTest.println("Value:" + mbean.getAttribute("max_pool_size"));
            retObject = mbean.invoke("getDefaultAttributeValue", new Object[]{"max_pool_size"}, new String[]{"java.lang.String"});
            AdminTest.println("Default:" + retObject);
            AdminTest.title("thread-pools Instantiate()");
            location = new String[]{"testdomain", "server-config"};
            mbean = registry.instantiateMBean("java-config", location, null, configContext);
            AdminTest.printObj("Returned object:", "  ", mbean);
            AdminTest.title("jvm-options - String[] attribute test");
            AdminTest.printObj("Value:", "   ", mbean.getAttribute("jvm_options"));
            AdminTest.title("jvm-options - String[] SETattribute test");
            mbean.setAttribute(new Attribute("jvm_options", new String[]{"abc", "def", "xyz"}));
            AdminTest.printObj("Value:", "   ", mbean.getAttribute("jvm_options"));
            AdminTest.title("auth-realm['file'] Instantiate()");
            location = new String[]{"testdomain", "server-config", "file"};
            mbean = registry.instantiateMBean("auth-realm", location, null, configContext);
            AdminTest.printObj("Returned object:", "  ", mbean);
            AdminTest.title("auth-realm['file']-> getProperties()");
            AdminTest.printAllProperties("Properties:", "      ", mbean);
            AdminTest.title("auth-realm['file']-> AddUser()");
            String[] groups = new String[]{"testGroup1", "testGroup2", "testGroup3"};
            retObject = mbean.invoke("updateUser", new Object[]{"testUser", "testPassword", groups}, new String[]{"java.lang.String", "java.lang.String", groups.getClass().getName()});
            AdminTest.printObj("updateUser:Returned object:", "      ", retObject);
            retObject = mbean.invoke("getUserGroupNames", new Object[]{"testUser"}, new String[]{"java.lang.String"});
            AdminTest.printObj("getUserGroupNames:Returned object:", "      ", retObject);
            retObject = mbean.invoke("getGroupNames", new Object[0], new String[0]);
            AdminTest.printObj("getGroupNames:Returned object:", "      ", retObject);
            retObject = mbean.invoke("getUserNames", new Object[0], new String[0]);
            AdminTest.printObj("getUserNames:Returned object:", "      ", retObject);
            AdminTest.title("resources-> getCustomResource()");
            AdminTest.title("domain Instantiate()");
            location = new String[]{"testdomain"};
            mbean = registry.instantiateMBean("domain", location, null, configContext);
            AdminTest.printObj("Returned object:", "  ", retObject);
            AdminTest.title("domain-> removeResources");
            retObject = mbean.invoke("removeResources", null, null);
            AdminTest.printObj("Returned object:", "      ", retObject);
        }
        catch (MBeanException mbe) {
            Exception e = mbe.getTargetException();
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                AdminTest.println(t.getMessage());
                t.printStackTrace();
            } else {
                AdminTest.println(e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                AdminTest.println(t.getMessage());
                t.printStackTrace();
            } else {
                AdminTest.println(e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            AdminTest.println(t.getMessage());
            t.printStackTrace();
        }
        AdminTest.println("Bye....!");
    }

    static void runRuntimeMbeanTests() {
        AdminTest.println("Start....!");
        try {
            MBeanRegistry registry = MBeanRegistryFactory.getMBeanRegistry("dtds/runtime-mbeans-descriptors.xml");
            ConfigContext configContext = ConfigFactory.createConfigContext("/home/kravtch/domain.xml");
            AdminTest.title("REGISTRY");
            AdminTest.println(registry.toString());
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                AdminTest.println(t.getMessage());
                t.printStackTrace();
            } else {
                AdminTest.println(e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            AdminTest.println(t.getMessage());
            t.printStackTrace();
        }
        AdminTest.println("Bye....!");
    }

    private static void title(String str) {
        System.out.println("\n\n************* " + str + " *******************");
    }

    private static void println(String str) {
        System.out.println(str);
    }

    private static void printObj(String title, String pref, Object obj) {
        AdminTest.println(title);
        AdminTest.printObj(pref, obj);
    }

    private static void printObj(String pref, Object obj) {
        if (pref == null) {
            pref = "";
        }
        if (obj == null) {
            AdminTest.println(pref + "null");
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs.length == 0) {
                AdminTest.println(pref + "array.length = 0");
            }
            for (int i = 0; i < objs.length; ++i) {
                AdminTest.printObj(pref + " [" + i + "] -> ", objs[i]);
            }
        } else if (obj instanceof ArrayList) {
            ArrayList objs = (ArrayList)obj;
            if (objs.size() == 0) {
                AdminTest.println(pref + "list.size() = 0");
            }
            for (int i = 0; i < objs.size(); ++i) {
                AdminTest.printObj(pref, objs.get(i));
            }
        } else if (obj instanceof Attribute) {
            AdminTest.println(pref + ((Attribute)obj).getName() + "=" + ((Attribute)obj).getValue());
        } else {
            AdminTest.println(pref + obj);
        }
    }

    private static void printAllAttributes(String title, String pref, DynamicMBean mbean) {
        AdminTest.printObj(title, pref, mbean.getAttributes(new String[]{""}));
    }

    private static void printAllProperties(String title, String pref, DynamicMBean mbean) throws Exception {
        Object ret = mbean.invoke("getProperties", null, null);
        AdminTest.printObj(title, pref, ret);
    }

    private static Object getConfigMbeanProperty(String name, DynamicMBean mbean) throws Exception {
        return mbean.invoke("getPropertyValue", new Object[]{name}, new String[]{"java.lang.String"});
    }

    private static void setConfigMbeanProperty(String name, Object value, DynamicMBean mbean) throws Exception {
        Object ret = mbean.invoke("setProperty", new Object[]{new Attribute(name, value)}, new String[]{"javax.management.Attribute"});
    }
}

