/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFRuntimeException;
import com.sun.enterprise.admin.common.exception.AFRuntimeStoreException;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.server.core.jmx.AppServerMBeanServerFactory;
import com.sun.enterprise.admin.server.core.jmx.InitException;
import com.sun.enterprise.admin.server.core.jmx.storage.MBeanManufacturer;
import com.sun.enterprise.admin.server.core.jmx.storage.PersistenceChecker;
import com.sun.enterprise.admin.util.proxy.ProxyFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ondemand.entry.EntryPoint;
import com.sun.enterprise.server.ondemand.entry.ServerEntryHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class SunoneInterceptor
implements MBeanServer,
EntryPoint {
    public static final String HOT_CONFIG_METHOD_NAME = "canApplyConfigChanges";
    public static final String FORCE_APPLY_METHOD_NAME = "overwriteConfigChanges";
    public static final String APPLY_METHOD_NAME = "applyConfigChanges";
    public static final String USE_MANUAL_METHOD_NAME = "useManualConfigChanges";
    public static final String GET_HOST_AND_PORT_METHOD_NAME = "getHostAndPort";
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager localStrings = StringManager.getManager(SunoneInterceptor.class);
    private static AdminContext adminContext;
    private MBeanServer realMBeanServer;
    private static final String DottedMBeansIniterClassName = "com.sun.enterprise.admin.mbeans.DottedNameMBeansIniter";
    private static boolean _alreadyCalled;

    SunoneInterceptor(String defaultDomainName) throws InitException {
    }

    void setJmxMBeanServer(MBeanServer jmxMBS) throws InitException {
        this.realMBeanServer = (MBeanServer)ProxyFactory.createProxy(MBeanServer.class, jmxMBS, adminContext.getMBeanServerInterceptor());
        this.logMBeanServerInfo();
        this.initialize();
    }

    SunoneInterceptor() throws InitException {
        this("DefaultDomain");
    }

    public static MBeanServer getMBeanServerInstance() throws InitException {
        return AppServerMBeanServerFactory.getMBeanServerInstance();
    }

    public static void setAdminContext(AdminContext ctx) {
        adminContext = ctx;
    }

    private void initialize() throws InitException {
        try {
            ObjectName controllerObjectName = ObjectNames.getControllerObjectName();
            ObjectName configObjectName = ObjectNames.getGenericConfiguratorObjectName();
            ObjectName[] objectNames = new ObjectName[]{controllerObjectName, configObjectName};
            String controllerClassName = "com.sun.enterprise.admin.server.core.mbean.config.ServerController";
            String configClassName = "com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator";
            String[] clNames = new String[]{controllerClassName, configClassName};
            for (int i = 0; i < clNames.length; ++i) {
                this.createAndRegister(clNames[i], objectNames[i]);
            }
            this.registerDottedNameSupport();
        }
        catch (Exception e) {
            throw new InitException(e.getMessage(), e.getCause());
        }
    }

    private void registerDottedNameSupport() throws Exception {
        Class<?> initerClass = Class.forName(DottedMBeansIniterClassName);
        Class[] signature = new Class[]{MBeanServer.class};
        Constructor<?> constructor = initerClass.getConstructor(signature);
        constructor.newInstance(this);
    }

    private ObjectInstance createAndRegister(String className, ObjectName objectName) throws Exception {
        try {
            Class<?> mbeanClass = Class.forName(className);
            Object mbeanImpl = mbeanClass.newInstance();
            ObjectInstance mbeanInstance = this.registerMBean(mbeanImpl, objectName);
            sLogger.log(Level.FINE, "core.system_mbean_init_ok", objectName.toString());
            return mbeanInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.realMBeanServer.registerMBean(object, objectName);
    }

    public void generateEntryContext(Object obj) {
        ServerEntryHelper.generateMbeanEntryContext((ObjectName)obj);
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        this.generateEntryContext(objectName);
        if (this.isInstanceMBean(objectName) && this.isConfigCheckRequired(operationName)) {
            this.checkHotConfigChanges(objectName);
        }
        if (FORCE_APPLY_METHOD_NAME.equals(operationName)) {
            String instanceName = ObjectNameHelper.getServerInstanceName(objectName);
            AdminEventCache cache = AdminEventCache.getInstance(instanceName);
            cache.setRestartNeeded(true);
        }
        this.registerWithPersistenceCheck(objectName);
        Object actualResult = this.realMBeanServer.invoke(objectName, operationName, params, signature);
        return actualResult;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        this.registerWithPersistenceCheck(objectName);
        Object value = this.realMBeanServer.getAttribute(objectName, attributeName);
        return value;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        this.registerWithPersistenceCheck(objectName);
        this.realMBeanServer.setAttribute(objectName, attribute);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        this.checkHotConfigChanges(objectName);
        this.registerWithPersistenceCheck(objectName);
        return this.realMBeanServer.getAttributes(objectName, attrNames);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        this.registerWithPersistenceCheck(objectName);
        return this.realMBeanServer.setAttributes(objectName, attributeList);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.realMBeanServer.unregisterMBean(objectName);
    }

    public Integer getMBeanCount() {
        return this.realMBeanServer.getMBeanCount();
    }

    public Set queryMBeans(ObjectName name, QueryExp exp) {
        this.registerConfigMBeans();
        return this.realMBeanServer.queryMBeans(name, exp);
    }

    public MBeanInfo getMBeanInfo(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.registerWithPersistenceCheck(objName);
        return this.realMBeanServer.getMBeanInfo(objName);
    }

    public boolean isRegistered(ObjectName name) {
        return this.realMBeanServer.isRegistered(name);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        this.realMBeanServer.addNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        this.realMBeanServer.addNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.realMBeanServer.createMBean(str, objectName);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.realMBeanServer.createMBean(str, objectName, objectName2);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.realMBeanServer.createMBean(str, objectName, obj, str3);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.realMBeanServer.createMBean(str, objectName, objectName2, obj, str4);
    }

    public ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        return this.realMBeanServer.deserialize(str, values);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        return this.realMBeanServer.deserialize(objectName, values);
    }

    public ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.realMBeanServer.deserialize(str, objectName, values);
    }

    public String getDefaultDomain() {
        return this.realMBeanServer.getDefaultDomain();
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return this.realMBeanServer.getObjectInstance(objectName);
    }

    public Object instantiate(String str) throws ReflectionException, MBeanException {
        return this.realMBeanServer.instantiate(str);
    }

    public Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.realMBeanServer.instantiate(str, objectName);
    }

    public Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        return this.realMBeanServer.instantiate(str, obj, str2);
    }

    public Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.realMBeanServer.instantiate(str, objectName, obj, str3);
    }

    public boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        return this.realMBeanServer.isInstanceOf(objectName, str);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        this.registerConfigMBeans();
        return this.realMBeanServer.queryNames(objectName, queryExp);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        this.realMBeanServer.removeNotificationListener(objectName, objectName1);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.realMBeanServer.removeNotificationListener(objectName, notificationListener);
    }

    private void checkHotConfigChanges(ObjectName mbeanName) {
        try {
            String instanceName = ApplicationServer.getServerContext().getInstanceName();
            ObjectName instanceObjectName = ObjectNames.getServerInstanceObjectName(instanceName);
            Object canApply = this.invoke(instanceObjectName, HOT_CONFIG_METHOD_NAME, null, null);
            if (canApply.equals(Boolean.FALSE)) {
                String msg = localStrings.getString("admin.server.core.jmx.configuration_changed_apply_changes", instanceName);
                throw new AFRuntimeStoreException(msg);
            }
        }
        catch (AFRuntimeStoreException af) {
            throw af;
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.jmx.bad_server_configuration");
            sLogger.log(Level.INFO, msg, e);
            throw new AFRuntimeException(msg, e);
        }
    }

    private boolean isInstanceMBean(ObjectName mbeanName) {
        return ObjectNameHelper.getServerInstanceName(mbeanName) != null;
    }

    private boolean isConfigCheckRequired(String operationName) {
        if (GET_HOST_AND_PORT_METHOD_NAME.equals(operationName)) {
            return false;
        }
        if (FORCE_APPLY_METHOD_NAME.equals(operationName)) {
            return false;
        }
        if (USE_MANUAL_METHOD_NAME.equals(operationName)) {
            return false;
        }
        if (HOT_CONFIG_METHOD_NAME.equals(operationName)) {
            return false;
        }
        return !"getMBeanInfo".equals(operationName);
    }

    private MBeanServer getRealMBeanServerAndInstantiate(ObjectName objectName) throws InstanceNotFoundException {
        this.registerWithPersistenceCheck(objectName);
        return this.realMBeanServer;
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.getRealMBeanServerAndInstantiate(objectName).getClassLoader(objectName);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.getRealMBeanServerAndInstantiate(objectName).getClassLoaderFor(objectName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.realMBeanServer.getClassLoaderRepository();
    }

    public String[] getDomains() {
        return this.realMBeanServer.getDomains();
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        this.realMBeanServer.removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        this.realMBeanServer.removeNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    private void logMBeanServerInfo() {
        try {
            String name = "JMImplementation:type=MBeanServerDelegate";
            ObjectName oName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            sLogger.log(Level.FINE, "core.mbs_info");
            String attrName = "ImplementationName";
            String result = (String)this.realMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.mbs_implementation", result);
            attrName = "ImplementationVendor";
            result = (String)this.realMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.mbs_vendor", result);
            attrName = "ImplementationVersion";
            result = (String)this.realMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.jmx_impl_version", result);
            attrName = "MBeanServerId";
            result = (String)this.realMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.mbs_id", result);
            result = this.realMBeanServer.getClass().getName();
            sLogger.log(Level.FINE, "core_mbs_classname", result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void manufactureAndRegisterMBean(ObjectName oName) throws Exception {
        if (this.realMBeanServer.isRegistered(oName)) {
            return;
        }
        Object product = this.manufactureMBean(oName);
        if (product == null) {
            String msg = localStrings.getString("admin.server.core.jmx.lazybean_not_found", oName.toString());
            throw new InstanceNotFoundException(msg);
        }
        this.registerMBean(product, oName);
        sLogger.log(Level.FINE, "core.create_and_register", oName);
    }

    private void registerWithPersistenceCheck(ObjectName oName) throws InstanceNotFoundException {
        if (!this.realMBeanServer.isRegistered(oName)) {
            try {
                this.manufactureAndRegisterMBean(oName);
            }
            catch (InstanceNotFoundException infe) {
                throw infe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Object manufactureMBean(ObjectName oName) throws InstanceNotFoundException {
        PersistenceChecker checker = new PersistenceChecker();
        checker.setAdminContext(adminContext);
        Object storedObject = checker.findElement(oName);
        Object match = null;
        if (storedObject != null) {
            MBeanManufacturer producer = new MBeanManufacturer(oName, storedObject);
            producer.setAdminContext(adminContext);
            match = producer.createMBeanInstance();
        } else {
            sLogger.log(Level.FINEST, "core.not_in_config", oName);
        }
        return match;
    }

    public void shutdown() {
        MBeanServerFactory.releaseMBeanServer(this.realMBeanServer);
        sLogger.log(Level.FINE, "core.release_mbs");
    }

    private void logMBeanInfo(ObjectName oName) {
        if (!sLogger.isLoggable(Level.FINEST)) {
            return;
        }
        MBeanInfo info = null;
        try {
            info = this.realMBeanServer.getMBeanInfo(oName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        sLogger.log(Level.FINEST, "\nCLASSNAME: \t" + info.getClassName());
        sLogger.log(Level.FINEST, "\nDESCRIPTION: \t" + info.getDescription());
        sLogger.log(Level.FINEST, "\nATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                sLogger.log(Level.FINEST, " ** NAME: \t" + attrInfo[i].getName());
                sLogger.log(Level.FINEST, "    DESCR: \t" + attrInfo[i].getDescription());
                sLogger.log(Level.FINEST, "    TYPE: \t" + attrInfo[i].getType() + "\tREAD: " + attrInfo[i].isReadable() + "\tWRITE: " + attrInfo[i].isWritable());
            }
        } else {
            sLogger.log(Level.FINEST, " ** No attributes **");
        }
        sLogger.log(Level.FINEST, "\nCONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        for (int i = 0; i < constrInfo.length; ++i) {
            sLogger.log(Level.FINEST, " ** NAME: \t" + constrInfo[i].getName());
            sLogger.log(Level.FINEST, "    DESCR: \t" + constrInfo[i].getDescription());
            sLogger.log(Level.FINEST, "    PARAM: \t" + constrInfo[i].getSignature().length + " parameter(s)");
        }
        sLogger.log(Level.FINEST, "\nOPERATIONS");
        MBeanOperationInfo[] opInfo = info.getOperations();
        if (opInfo.length > 0) {
            for (int i = 0; i < opInfo.length; ++i) {
                sLogger.log(Level.FINEST, " ** NAME: \t" + opInfo[i].getName());
                sLogger.log(Level.FINEST, "    DESCR: \t" + opInfo[i].getDescription());
                sLogger.log(Level.FINEST, "    PARAM: \t" + opInfo[i].getSignature().length + " parameter(s)");
            }
        } else {
            sLogger.log(Level.FINEST, " ** No operations ** ");
        }
        sLogger.log(Level.FINEST, "\nNOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                sLogger.log(Level.FINEST, " ** NAME: \t" + notifInfo[i].getName());
                sLogger.log(Level.FINEST, "    DESCR: \t" + notifInfo[i].getDescription());
            }
        } else {
            sLogger.log(Level.FINEST, " ** No notifications **");
        }
    }

    private void registerConfigMBeans() {
        if (!_alreadyCalled) {
            this.registerConfigMBeansSynchro();
        }
    }

    private synchronized void registerConfigMBeansSynchro() {
        if (_alreadyCalled) {
            return;
        }
        try {
            MBeanRegistry mr = MBeanRegistryFactory.getAdminMBeanRegistry();
            mr.instantiateAndRegisterAllConfigMBeans(adminContext.getAdminConfigContext(), ApplicationServer.getServerContext().getDefaultDomainName());
        }
        catch (Throwable t) {
            sLogger.log(Level.FINE, "Error in registering configMBeans", t);
        }
        _alreadyCalled = true;
    }

    static {
        _alreadyCalled = false;
    }
}

