/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.EntityStatus;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.J2EEApplicationException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.ModulesXMLHelper;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;

public class ManagedJ2EEApplication
extends ConfigMBeanBase
implements ConfigAttributeName.J2EEApplication {
    private static final String[][] MAPLIST = new String[][]{{"name", "@name"}, {"location", "@location"}, {"virtualServers", "@virtual-servers"}, {"description", "@description"}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "location, String,     RW", "virtualServers, String,     RW", "description, String,     RW"};
    private static final String[] OPERATIONS = new String[]{"getModules(), INFO", "getEjbModules(), INFO", "getWebModules(), INFO", "getStatus(), INFO", "enable(), ACTION", "disable(), ACTION", "start(),     ACTION", "stop(),      ACTION", "getState(),   INFO"};

    public ManagedJ2EEApplication() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedJ2EEApplication(String instanceName, String appName) throws MBeanConfigException {
        this(instanceName, appName, null);
    }

    public ManagedJ2EEApplication(String instanceName, String appName, AdminContext adminContext) throws MBeanConfigException {
        this();
        this.setAdminContext(adminContext);
        this.initialize("application", new String[]{instanceName, appName});
    }

    public String[] getModules() throws J2EEApplicationException {
        return this.getModulesByType(255);
    }

    public String[] getEjbModules() throws J2EEApplicationException {
        return this.getModulesByType(1);
    }

    public String[] getWebModules() throws J2EEApplicationException {
        return this.getModulesByType(2);
    }

    private String[] getModulesByType(int moduleTypes) throws J2EEApplicationException {
        try {
            String location = (String)this.getAttribute("location");
            return ModulesXMLHelper.getModulesFromApplicationLocation(location, moduleTypes);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getModulesByType", e);
            throw new J2EEApplicationException(e.getMessage());
        }
    }

    public EntityStatus getStatus() throws J2EEApplicationException {
        EntityStatus status = null;
        try {
            boolean isAppEnabled = true;
            status = new EntityStatus();
            if (isAppEnabled) {
                status.setEnabled();
            } else {
                status.setDisabled();
            }
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getStatus", e);
            throw new J2EEApplicationException(e.getMessage());
        }
        return status;
    }

    public void disable() throws J2EEApplicationException {
    }

    public void stop() throws J2EEApplicationException {
        try {
            String appName = (String)this.getAttribute("name");
            this.multicastAdminEvent(appName, "disable");
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "stop", e);
            throw new J2EEApplicationException(e.getMessage());
        }
    }

    public Integer getState() throws J2EEApplicationException {
        try {
            ServerContext serverContext = ApplicationServer.getServerContext();
            String namePattern = serverContext.getDefaultDomainName() + ":" + "j2eeType=J2EEApplication," + "name=" + (String)this.getAttribute("name") + "," + "J2EEServer=" + serverContext.getInstanceName() + "," + "*";
            Integer intObj = Switch.getSwitch().getManagementObjectManager().getState(namePattern);
            return intObj;
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getState", e);
            throw new J2EEApplicationException(e.getMessage());
        }
    }

    public void enable() throws J2EEApplicationException {
    }

    public void start() throws J2EEApplicationException {
        try {
            String appName = (String)this.getAttribute("name");
            this.multicastAdminEvent(appName, "enable");
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "start", e);
            throw new J2EEApplicationException(e.getMessage());
        }
    }

    public static final void main(String[] args) throws Exception {
        System.setProperty("com.sun.aas.instanceRoot", "e:\\tmp");
        ManagedJ2EEApplication appMBean = new ManagedJ2EEApplication("adminapp", "admserv");
        EntityStatus status = appMBean.getStatus();
        sLogger.info("======== Status = " + status.getStatusString());
        if (status.isDisabled()) {
            sLogger.info("======== Enabling app");
            appMBean.enable();
            status = appMBean.getStatus();
            sLogger.info("======== Status = " + status.getStatusString());
        } else {
            sLogger.info("======== Disabling app");
            appMBean.disable();
            status = appMBean.getStatus();
            sLogger.info("======== Status = " + status.getStatusString());
        }
    }

    private void multicastAdminEvent(String entityName, String actionCode) throws J2EEApplicationException {
        String instanceName = super.getServerInstanceName();
        InstanceEnvironment instEnv = new InstanceEnvironment(instanceName);
        try {
            instEnv.applyServerXmlChanges(false);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getAttr", e);
            throw new J2EEApplicationException(e.getMessage());
        }
        ApplicationDeployEvent event = new ApplicationDeployEvent(instanceName, entityName, actionCode);
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(instanceName);
        if (serverInstancePinger.getInstanceStatusCode() != 0) {
            return;
        }
        AdminEventResult multicastResult = AdminEventMulticaster.multicastEvent(event);
        if (!"success".equals(multicastResult.getResultCode())) {
            AdminEventCache cache = AdminEventCache.getInstance(instanceName);
            cache.setRestartNeeded(true);
        }
    }
}

