/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;

public class DeployableObjectType {
    public static final DeployableObjectType APP;
    public static final DeployableObjectType EJB;
    public static final DeployableObjectType WEB;
    public static final DeployableObjectType CONN;
    public static final DeployableObjectType CAR;
    public static final DeployableObjectType LCM;
    public static final DeployableObjectType CMB;
    private final String name;
    private final String ddName;
    private final String runtimeDD;
    private final String extension;
    private final ModuleType jsr88Type;
    private static StringManager localStrings;
    private static List allTypes;

    public boolean isEJB() {
        return this == EJB;
    }

    public boolean isWEB() {
        return this == WEB;
    }

    public boolean isAPP() {
        return this == APP;
    }

    public boolean isCONN() {
        return this == CONN;
    }

    public boolean isCAR() {
        return this == CAR;
    }

    public boolean isLCM() {
        return this == LCM;
    }

    public boolean isCMB() {
        return this == CMB;
    }

    public String toString() {
        return this.name;
    }

    public ModuleType getModuleType() {
        return this.jsr88Type;
    }

    private DeployableObjectType(String theName, String theDDName, String theRuntimeDD, String ext, ModuleType type) {
        this.name = theName;
        this.ddName = theDDName;
        this.runtimeDD = theRuntimeDD;
        this.extension = ext;
        this.jsr88Type = type;
        allTypes.add(this);
    }

    public static void main(String[] args) {
        String[] files = new String[]{"pkgingEApp.ear", "foof.rar", "hello.war", "foo.jar", "nothere", "junk.ear", "ear", "ejb", "rar", "war"};
        for (int i = 0; i < files.length; ++i) {
            File f = new File("C:/ias8samples/" + files[i]);
        }
    }

    static {
        localStrings = StringManager.getManager(DeployableObjectType.class);
        allTypes = new ArrayList(7);
        APP = new DeployableObjectType("Application", "META-INF/application.xml", "META-INF/sun-application.xml", ".ear", ModuleType.EAR);
        WEB = new DeployableObjectType("Web Module", "WEB-INF/web.xml", "WEB-INF/sun-web.xml", ".war", ModuleType.WAR);
        CONN = new DeployableObjectType("Connector Module", "META-INF/ra.xml", "META-INF/sun-ra.xml", ".rar", ModuleType.RAR);
        CAR = new DeployableObjectType("AppClient Module", "META-INF/application-client.xml", "META-INF/sun-application-client.xml", ".jar", ModuleType.CAR);
        EJB = new DeployableObjectType("EJB Module", "META-INF/ejb-jar.xml", "META-INF/sun-ejb-jar.xml", ".jar", ModuleType.EJB);
        LCM = new DeployableObjectType("Lifecycle Module", null, null, ".jar", XModuleType.LCM);
        CMB = new DeployableObjectType("Custom MBean Module", null, null, ".jar", XModuleType.CMB);
    }
}

