/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceAdapterStartPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(ResourceAdapterStartPhase.class);

    public ResourceAdapterStartPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "raStart";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean success;
        String type = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        if (target == null) {
            String msg = localStrings.getString("enterprise.deployment.phasing.start.targetnotspecified");
            sLogger.log(Level.FINEST, msg);
            status.setStageStatus(2);
            return;
        }
        boolean containsRar = false;
        if (req.isApplication()) {
            type = null;
            Application app = DeploymentServiceUtils.getInstanceManager(DeployableObjectType.APP).getRegisteredDescriptor(req.getName());
            if (app != null && app.getRarComponentCount() != 0) {
                containsRar = true;
            }
        } else {
            type = DeploymentServiceUtils.getModuleTypeString(req.getType());
            if (req.isConnectorModule()) {
                containsRar = true;
            }
        }
        if (!containsRar) {
            status.setStageStatus(2);
            return;
        }
        this.prePhaseNotify(this.getPrePhaseEvent(req));
        int actionCode = req.getActionCode();
        try {
            success = target.sendStartEvent(actionCode, req.getName(), type, req.isForced(), 2);
        }
        catch (DeploymentTargetException dte) {
            status.setStageStatus(1);
            if (dte.getCause() != null) {
                status.setStageStatusMessage(dte.getMessage());
            }
            return;
        }
        if (success) {
            status.setStageStatus(2);
        } else {
            status.setStageStatus(1);
            status.setStageStatusMessage("Application failed to load");
        }
        this.postPhaseNotify(this.getPostPhaseEvent(req));
    }

    private DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(11, new DeploymentEventInfo(req));
    }

    private DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(12, new DeploymentEventInfo(req));
    }
}

