/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.runtime;

import com.sun.enterprise.deployment.Descriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public abstract class RuntimeDescriptor
extends Descriptor {
    protected PropertyChangeSupport propListeners = new PropertyChangeSupport(this);

    public RuntimeDescriptor(RuntimeDescriptor other) {
        super(other);
    }

    public RuntimeDescriptor() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propListeners.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String n, PropertyChangeListener l) {
        this.propListeners.addPropertyChangeListener(n, l);
    }

    public void removePropertyChangeListener(String n, PropertyChangeListener l) {
        this.propListeners.removePropertyChangeListener(n, l);
    }

    public void setValue(String name, Object value) {
        Object oldValue = this.getExtraAttribute(name);
        this.addExtraAttribute(name, value);
        this.propListeners.firePropertyChange(name, oldValue, value);
    }

    public Object getValue(String name) {
        return this.getExtraAttribute(name);
    }

    protected void setValue(String name, int index, Object value) {
        List list = this.getIndexedProperty(name);
        list.set(index, value);
        this.setValue(name, list);
    }

    protected Object getValue(String name, int index) {
        List list = this.getIndexedProperty(name);
        return list.get(index);
    }

    protected int addValue(String name, Object value) {
        List list = this.getIndexedProperty(name);
        list.add(value);
        this.setValue(name, list);
        return list.indexOf(value);
    }

    protected int removeValue(String name, Object value) {
        List list = this.getIndexedProperty(name);
        int index = list.indexOf(value);
        list.remove(index);
        return index;
    }

    protected void removeValue(String name, int index) {
        List list = this.getIndexedProperty(name);
        list.remove(index);
    }

    protected void setValues(String name, Object[] values) {
        List list = this.getIndexedProperty(name);
        int i = 0;
        while (i < values.length) {
            list.add(values[i]);
        }
    }

    protected Object[] getValues(String name) {
        List list = (List)this.getValue(name);
        if (list != null && list.size() > 0) {
            Class<?> c = list.get(0).getClass();
            Object array = Array.newInstance(c, list.size());
            return list.toArray((Object[])array);
        }
        return null;
    }

    protected int size(String name) {
        List list = (List)this.getValue(name);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    private List getIndexedProperty(String name) {
        Object o = this.getValue(name);
        if (o == null) {
            return new ArrayList();
        }
        return (List)o;
    }

    public void setAttributeValue(String elementName, String attributeName, Object value) {
        int index = 0;
        while (this.getValue(elementName + "-" + index + "-" + attributeName) != null) {
            ++index;
        }
        if (index == 0) {
            this.setValue(elementName + "-0-" + attributeName, value);
        } else {
            this.setValue(elementName + "-" + (index + 1) + "-" + attributeName, value);
        }
    }

    public String getAttributeValue(String elementName, String attributeName) {
        return this.getAttributeValue(elementName, 0, attributeName);
    }

    public void setAttributeValue(String attributeName, String value) {
        this.setValue(attributeName, value);
    }

    public String getAttributeValue(String attributeName) {
        return (String)this.getValue(attributeName);
    }

    public void setAttributeValue(String elementName, int index, String attributeName, Object value) {
        this.setValue(elementName + "-" + index + "-" + attributeName, value);
    }

    public String getAttributeValue(String elementName, int index, String attributeName) {
        return (String)this.getValue(elementName + "-" + index + "-" + attributeName);
    }
}

