/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Constants;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.xml.sax.SAXParseException;

public class DomainXMLVerificationCollector
implements Collector {
    private String xmlFile;
    private String destFolder;

    public DomainXMLVerificationCollector(String repository, String destFolder) {
        this.destFolder = destFolder;
        this.xmlFile = repository + Constants.DOMAIN_XML;
    }

    public Data capture() throws DiagnosticException {
        if (this.destFolder != null) {
            File destFolderObj = new File(this.destFolder);
            String destFile = this.destFolder + Defaults.DOMAIN_XML_VERIFICATION_OUTPUT;
            PrintStream out = System.out;
            if (!destFolderObj.exists()) {
                destFolderObj.mkdirs();
            }
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(destFile)), true);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(" File Not Found Exception ");
                fnfe.printStackTrace();
            }
            try {
                String className = "com.sun.enterprise.config.serverbeans.validation.DomainXmlVerifier";
                Class<?> classObj = Class.forName(className);
                Constructor<?>[] constructors = classObj.getDeclaredConstructors();
                constructors = classObj.getConstructors();
                Constructor<?> constructor = classObj.getConstructor(String.class, PrintStream.class);
                Object obj = constructor.newInstance(this.xmlFile, out);
                Method method = classObj.getMethod("invokeConfigValidator", null);
                method.invoke(obj, (Object[])null);
                FileData fileData = new FileData(new File(destFile).getName(), "domain validation details");
                return fileData;
            }
            catch (Exception ce) {
                Throwable cause;
                for (cause = ce.getCause(); cause != null && !(cause instanceof SAXParseException); cause = cause.getCause()) {
                }
                if (cause != null) {
                    out.println("XML: " + cause.getMessage());
                } else {
                    ce.printStackTrace();
                }
                throw new DiagnosticException(ce.getMessage());
            }
            finally {
                out.flush();
                out.close();
            }
        }
        return null;
    }
}

