/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.collect.WritableData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableDataImpl
implements WritableData {
    protected List<Data> children;
    protected List<String> values;
    protected List<List<String>> table;
    protected String source;
    protected String type;
    private static int INITIAL_CAPACITY = 5;

    public WritableDataImpl() {
        this("", "container");
    }

    public WritableDataImpl(String type) {
        this("", type);
    }

    public WritableDataImpl(String source, String type) {
        this(source, type, 5, 20);
    }

    public WritableDataImpl(String source, String type, int initialValuesCapacity) {
        this(source, type, INITIAL_CAPACITY, initialValuesCapacity);
    }

    public WritableDataImpl(String source, String type, int initialChildrenCapacity, int initialValuesCapacity) {
        this(source, type, initialChildrenCapacity, initialValuesCapacity, INITIAL_CAPACITY);
    }

    public WritableDataImpl(String source, String type, int initialChildrenCapacity, int initialValuesCapacity, int initialTableCapacity) {
        this.source = source;
        this.type = type;
        this.children = new ArrayList<Data>(initialChildrenCapacity);
        this.values = new ArrayList<String>(initialValuesCapacity);
        this.table = new ArrayList<List<String>>(initialTableCapacity);
    }

    @Override
    public void addChild(Data dataObj) {
        if (dataObj != null) {
            this.children.add(dataObj);
        }
    }

    @Override
    public void addValue(String value) {
        this.values.add(value);
    }

    @Override
    public void addRow(List<String> list) {
        if (list != null) {
            this.table.add(list);
        }
    }

    @Override
    public Iterator<Data> getChildren() {
        return this.children.iterator();
    }

    @Override
    public Iterator<String> getValues() {
        return this.values.iterator();
    }

    @Override
    public Iterator<Iterator<String>> getTable() {
        ArrayList<Iterator<String>> listOfIterators = new ArrayList<Iterator<String>>();
        for (List<String> row : this.table) {
            listOfIterators.add(row.iterator());
        }
        return listOfIterators.iterator();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

