/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.launcher;

import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.org.apache.commons.launcher.LaunchCommand;
import com.sun.org.apache.commons.launcher.LaunchFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.helpers.DefaultHandler;

public class PELaunchFilter
implements LaunchFilter {
    public static final String DEBUG_OPTIONS = "com.sun.aas.jdwpOptions";
    public static final String LOCALE = "locale";
    ArrayList jvmArgsList = null;
    HashMap sysProps = null;
    String serverModeOrClientMode = null;

    public static String getDebugProperty(String debug_options, String name) {
        int nameIndex = debug_options.indexOf(name);
        if (nameIndex != -1) {
            String value = debug_options.substring(nameIndex + name.length() + 1);
            int commaIndex = value.indexOf(",");
            if (commaIndex != -1) {
                value = value.substring(0, commaIndex);
            }
            return value;
        }
        return null;
    }

    public void filter(LaunchCommand command) throws BuildException {
        try {
            Element profilerElement;
            String profilerEnabled;
            Element serversElement;
            NodeList server;
            ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
            reader.setSystemProperties();
            this.serverModeOrClientMode = null;
            boolean stopOperation = false;
            boolean waitForChild = command.getWaitforchild();
            boolean debugOption = false;
            ArrayList argsList = command.getArgs();
            String[] args = argsList.toArray(new String[argsList.size()]);
            for (int ar = 0; ar < args.length; ++ar) {
                if ("stop".equals(args[ar])) {
                    stopOperation = true;
                    waitForChild = true;
                    debugOption = false;
                    break;
                }
                if ("debug".equals(args[ar])) {
                    debugOption = true;
                    continue;
                }
                if (!"verbose".equals(args[ar])) continue;
                waitForChild = true;
            }
            this.jvmArgsList = command.getJvmargs();
            if (this.jvmArgsList == null) {
                this.jvmArgsList = new ArrayList();
            }
            if (waitForChild) {
                this.jvmArgsList.add("-Dcom.sun.aas.verboseMode=true");
            }
            this.sysProps = command.getSysproperties();
            if (this.sysProps == null) {
                System.out.println("[FATAL ERROR] System properties with S1AS installation values doesn't present");
                System.out.println("Please check <installtionDir>/lib/launcher.xml");
                System.out.println("Exiting out");
                System.exit(1);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            String instanceRoot = (String)this.sysProps.get("com.sun.aas.instanceRoot");
            String serverName = (String)this.sysProps.get("com.sun.aas.instanceName");
            if (serverName == null) {
                serverName = "server";
            }
            String domainConfigFilePath = instanceRoot + File.separator + "config" + File.separator + "domain.xml";
            Document doc = db.parse(domainConfigFilePath);
            Element root = doc.getDocumentElement();
            this.handleSystemProperties(root);
            if (root.hasAttribute(LOCALE)) {
                String locale = root.getAttribute(LOCALE);
                if (locale != null && !"".equals(locale)) {
                    this.sysProps.put("com.sun.aas.defaultLocale", locale);
                }
            } else {
                this.sysProps.put("com.sun.aas.defaultLocale", System.getProperty("com.sun.aas.defaultLocale"));
            }
            NodeList servers = root.getElementsByTagName("servers");
            if (servers.getLength() < 1) {
                System.out.println("[FATAL ERROR]  domain.xml doesn't have servers element");
                System.exit(1);
            }
            if ((server = (serversElement = (Element)servers.item(0)).getElementsByTagName("server")).getLength() < 1) {
                System.out.println("[FATAL ERROR]  domain.xml doesn't have server element");
                System.exit(1);
            }
            Element serverElement = null;
            boolean foundMatchingServer = false;
            for (int i = 0; i < server.getLength(); ++i) {
                serverElement = (Element)server.item(i);
                if (!serverElement.getAttribute("name").equals(serverName)) continue;
                foundMatchingServer = true;
                break;
            }
            if (!foundMatchingServer) {
                System.out.println("[FATAL ERROR]  domain.xml doesn't have the server element named: " + serverName);
                System.exit(1);
            }
            String configRef = serverElement.getAttribute("config-ref");
            this.sysProps.put("com.sun.aas.configName", configRef);
            System.setProperty("com.sun.aas.configName", configRef);
            NodeList logServices = this.getNodeList(root, configRef, "log-service");
            Element logServiceElement = null;
            String logFileName = null;
            String logToConsole = null;
            for (int ls = 0; ls < logServices.getLength(); ++ls) {
                logServiceElement = (Element)logServices.item(ls);
                logFileName = RelativePathResolver.resolvePath(logServiceElement.getAttribute("file"));
                logToConsole = logServiceElement.getAttribute("log-to-console");
            }
            if (logToConsole != null && logToConsole.equals("true")) {
                waitForChild = true;
                this.jvmArgsList.add("-Dcom.sun.aas.verboseMode=true");
            } else if (logFileName != null) {
                command.setOutput(new File(logFileName));
            }
            command.setWaitforchild(waitForChild);
            NodeList javaConfigs = this.getNodeList(root, configRef, "java-config");
            Element javaConfigElement = null;
            String debug_enabled = null;
            String debug_options = null;
            String rmic_options = null;
            String javac_options = null;
            String java_home = null;
            String classpath_prefix = null;
            String server_classpath = null;
            String classpath_suffix = null;
            String native_library_path_prefix = null;
            String native_library_path_suffix = null;
            String bytecode_preprocessors = null;
            String env_classpath_ignored = "true";
            for (int jc = 0; jc < javaConfigs.getLength(); ++jc) {
                javaConfigElement = (Element)javaConfigs.item(jc);
                debug_enabled = javaConfigElement.getAttribute("debug-enabled");
                debug_options = javaConfigElement.getAttribute("debug-options");
                rmic_options = javaConfigElement.getAttribute("rmic-options");
                javac_options = javaConfigElement.getAttribute("javac-options");
                java_home = OS.isDarwin() ? RelativePathResolver.resolvePath(javaConfigElement.getAttribute("java-home")) : RelativePathResolver.resolvePath(javaConfigElement.getAttribute("java-home") + File.separator + "jre");
                classpath_prefix = RelativePathResolver.resolvePath(javaConfigElement.getAttribute("classpath-prefix"));
                server_classpath = RelativePathResolver.resolvePath(javaConfigElement.getAttribute("server-classpath"));
                classpath_suffix = RelativePathResolver.resolvePath(javaConfigElement.getAttribute("classpath-suffix"));
                native_library_path_prefix = javaConfigElement.getAttribute("native-library-path-prefix");
                native_library_path_suffix = javaConfigElement.getAttribute("native-library-path-suffix");
                bytecode_preprocessors = javaConfigElement.getAttribute("bytecode-preprocessors");
                env_classpath_ignored = javaConfigElement.getAttribute("env-classpath-ignored");
            }
            if (java_home != null) {
                System.setProperty("java.home", java_home);
            }
            String profilerClasspath = null;
            String profilerNativeLibraryPath = null;
            NodeList profilers = javaConfigElement.getElementsByTagName("profiler");
            int numberOfProfilerElements = profilers.getLength();
            if (numberOfProfilerElements > 0 && (profilerEnabled = (profilerElement = (Element)profilers.item(0)).getAttribute("enabled")) != null && profilerEnabled.equals("true")) {
                String profilerName = profilerElement.getAttribute("name");
                if (profilerName == null) {
                    System.err.println("ERROR : Profiler is enabled. But Name is null");
                    System.err.println("Profiler settings are ignored");
                } else {
                    profilerClasspath = profilerElement.getAttribute("classpath");
                    profilerNativeLibraryPath = profilerElement.getAttribute("native-library-path");
                    this.handleJvmOptions(profilerElement);
                    this.handleProperties(profilerElement);
                }
            }
            String requestedClasspath = server_classpath;
            String originalClasspath = command.getClasspath();
            if (originalClasspath != null) {
                requestedClasspath = originalClasspath + File.pathSeparator + requestedClasspath;
            }
            if (classpath_prefix != null && !classpath_prefix.trim().equals("")) {
                requestedClasspath = classpath_prefix + File.pathSeparator + requestedClasspath;
            }
            if (classpath_suffix != null && !classpath_suffix.trim().equals("")) {
                requestedClasspath = requestedClasspath + File.pathSeparator + classpath_suffix;
            }
            if (profilerClasspath != null && !profilerClasspath.trim().equals("")) {
                requestedClasspath = requestedClasspath + File.pathSeparator + profilerClasspath;
            }
            String envClasspath = (String)this.sysProps.get("user.classpath");
            this.sysProps.remove("user.classpath");
            if (env_classpath_ignored != null && env_classpath_ignored.equals("false") && !envClasspath.equals("${env.CLASSPATH}")) {
                requestedClasspath = requestedClasspath + File.pathSeparator + envClasspath;
            }
            command.setClasspath(requestedClasspath);
            this.handleJvmOptions(javaConfigElement);
            if (debug_enabled != null && debug_enabled.equals("true")) {
                debugOption = true;
            }
            if (debugOption && !stopOperation) {
                this.jvmArgsList.add("-Xdebug");
                debug_options = debug_options.trim();
                if (debug_options.startsWith("-Xdebug")) {
                    debug_options = debug_options.substring("-Xdebug".length()).trim();
                }
                String transport = PELaunchFilter.getDebugProperty(debug_options, "transport");
                String addr = PELaunchFilter.getDebugProperty(debug_options, "address");
                if (transport == null || transport.equals("")) {
                    throw new BuildException("Cannot start server in debug mode: no transport specified in debug-options in domain.xml.");
                }
                if (transport.equals("dt_socket") && (addr == null || addr.equals(""))) {
                    int port = NetUtils.getFreePort();
                    if (port == 0) {
                        throw new BuildException("Cannot start server in debug mode: unable to obtain a free port for transport dt_socket.");
                    }
                    addr = String.valueOf(port);
                    debug_options = debug_options + ",address=" + addr;
                }
                this.jvmArgsList.add(debug_options);
                String jdwpOptions = debug_options.substring(debug_options.indexOf("-Xrunjdwp:") + "-Xrunjdwp:".length());
                this.jvmArgsList.add("-Dcom.sun.aas.jdwpOptions=" + jdwpOptions);
            }
            String javaLibPath = System.getProperty("java.library.path");
            if (native_library_path_prefix != null && !native_library_path_prefix.trim().equals("")) {
                javaLibPath = javaLibPath != null ? native_library_path_prefix + File.pathSeparator + javaLibPath : native_library_path_prefix;
            }
            if (native_library_path_suffix != null && !native_library_path_suffix.trim().equals("")) {
                javaLibPath = javaLibPath != null ? javaLibPath + File.pathSeparator + native_library_path_suffix : native_library_path_suffix;
            }
            if (profilerNativeLibraryPath != null && !profilerNativeLibraryPath.trim().equals("")) {
                javaLibPath = javaLibPath != null ? javaLibPath + File.pathSeparator + profilerNativeLibraryPath : profilerNativeLibraryPath;
            }
            javaLibPath = this.normalize(javaLibPath);
            this.sysProps.put("java.library.path", javaLibPath);
            System.setProperty("java.library.path", javaLibPath);
            if (this.serverModeOrClientMode != null) {
                this.jvmArgsList.add(0, "-" + this.serverModeOrClientMode);
            }
            this.handleSystemProperties(this.getConfigElement(root, configRef));
            this.handleSystemProperties(serverElement);
            command.setSysproperties(this.sysProps);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException();
        }
    }

    private String normalize(String path) {
        path = path.replaceAll("\"", "");
        path = path.replaceAll("'", "");
        return path;
    }

    private void handleJvmOptions(Element element) {
        NodeList jvmoptions = element.getChildNodes();
        Element tmpElement = null;
        Node tmpNode = null;
        String systemProperty = null;
        String property = null;
        String value = null;
        for (int i = 0; i < jvmoptions.getLength(); ++i) {
            Node varNode = jvmoptions.item(i);
            if (varNode.getNodeType() != 1 || !varNode.getNodeName().equals("jvm-options") || (tmpNode = (tmpElement = (Element)varNode).getFirstChild()) == null || tmpNode instanceof Text && tmpNode.getNodeValue().equals("")) continue;
            systemProperty = tmpNode.getNodeValue().trim();
            StringTokenizer stk = new StringTokenizer(systemProperty, "-");
            String currentToken = null;
            String option = null;
            int tokenCount = 0;
            int numOfTokens = stk.countTokens();
            while (stk.hasMoreTokens()) {
                if (!(currentToken = currentToken != null ? currentToken + "-" + stk.nextToken() : stk.nextToken()).endsWith(" ") && ++tokenCount < numOfTokens) continue;
                option = currentToken.trim();
                currentToken = null;
                if (option.startsWith("D")) {
                    int indexOfEqual = (option = option.substring(1, option.length())).indexOf("=");
                    if (indexOfEqual > 0) {
                        property = option.substring(0, indexOfEqual);
                        value = option.substring(indexOfEqual + 1);
                        this.sysProps.put(property, RelativePathResolver.resolvePath(value));
                        continue;
                    }
                    property = option;
                    this.jvmArgsList.add("-D" + property);
                    continue;
                }
                if (option.equals("client") || option.equals("server")) {
                    this.serverModeOrClientMode = option;
                    continue;
                }
                this.jvmArgsList.add("-" + option);
            }
        }
    }

    private void handleSystemProperties(Element element) {
        this.handleProperties(element, "system-property");
    }

    private void handleProperties(Element element) {
        this.handleProperties(element, "property");
    }

    private void handleProperties(Element element, String elementName) {
        NodeList properties = element.getChildNodes();
        Element propertyElement = null;
        Object tmpNode = null;
        Object systemProperty = null;
        Object property = null;
        Object value = null;
        for (int i = 0; i < properties.getLength(); ++i) {
            Node varNode = properties.item(i);
            if (varNode.getNodeType() != 1 || !varNode.getNodeName().equals(elementName)) continue;
            propertyElement = (Element)varNode;
            String propertyName = propertyElement.getAttribute("name");
            String propertyValue = propertyElement.getAttribute("value");
            this.sysProps.put(propertyName, propertyValue);
        }
    }

    private Element getConfigElement(Element root, String configRef) {
        Element configsElement;
        NodeList config;
        Element configElement = null;
        NodeList configs = root.getElementsByTagName("configs");
        if (configs.getLength() < 1) {
            System.out.println("[FATAL ERROR]  domain.xml doesn't have configs element");
            System.exit(1);
        }
        if ((config = (configsElement = (Element)configs.item(0)).getElementsByTagName("config")).getLength() < 1) {
            System.out.println("[FATAL ERROR]  domain.xml doesn't have config element");
            System.exit(1);
        }
        for (int j = 0; j < config.getLength(); ++j) {
            configElement = (Element)config.item(j);
            if (!configElement.getAttribute("name").equals(configRef)) continue;
            return configElement;
        }
        System.out.println("[FATAL ERROR]  domain.xml doesn't have config element matching " + configRef);
        System.exit(1);
        return null;
    }

    private NodeList getNodeList(Element root, String configRef, String nlName) {
        Element configElement = this.getConfigElement(root, configRef);
        return configElement.getElementsByTagName(nlName);
    }
}

