/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import sun.security.x509.X500Name;

public final class CertificateRealm
extends IASRealm {
    public static final String AUTH_TYPE = "certificate";
    public static final String PARAM_GROUPS = "assign-groups";
    private static final String GROUPS_SEP = ",";
    private Vector defaultGroups = null;
    private Group[] groupsAsPrincipals = null;

    protected void init(Properties props) {
        this.defaultGroups = new Vector();
        String groupList = props.getProperty(PARAM_GROUPS);
        if (groupList != null) {
            _logger.fine("CertificateRealm : groups: " + groupList);
            StringTokenizer st = new StringTokenizer(groupList, GROUPS_SEP);
            while (st.hasMoreTokens()) {
                String grp = st.nextToken();
                this.defaultGroups.add(grp);
            }
            int groups = this.defaultGroups.size();
            this.groupsAsPrincipals = new Group[groups];
            for (int i = 0; i < groups; ++i) {
                this.groupsAsPrincipals[i] = new Group((String)this.defaultGroups.get(i));
            }
        } else {
            this.groupsAsPrincipals = new Group[0];
        }
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String username) throws NoSuchUserException, InvalidOperationException {
        return this.defaultGroups.elements();
    }

    public String getJAASContext() {
        _logger.warning("certrealm.nojaas");
        return null;
    }

    public void authenticate(Subject subject, X500Name x500name) {
        String name = x500name.getName();
        _logger.finest("Certificate realm setting up security context for: " + name);
        int gsize = this.groupsAsPrincipals.length;
        Set<Principal> principalSet = subject.getPrincipals();
        for (int i = 0; i < gsize; ++i) {
            principalSet.add(this.groupsAsPrincipals[i]);
        }
        SecurityContext securityContext = new SecurityContext(name, subject);
        SecurityContext.setCurrent(securityContext);
    }
}

