/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.naming.SerialInitContextFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.TomcatServices;
import com.sun.enterprise.server.ondemand.OnDemandServices;
import com.sun.enterprise.server.ondemand.ServerEntryListenerImpl;
import com.sun.enterprise.server.ondemand.ServiceGroup;
import com.sun.enterprise.server.ondemand.ServiceGroupBuilder;
import com.sun.enterprise.server.ondemand.SystemAppLoader;
import com.sun.enterprise.server.ondemand.entry.EntryPoint;
import com.sun.enterprise.server.ondemand.entry.ServerEntryHelper;
import com.sun.enterprise.server.ondemand.entry.ServerEntryListener;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.server.ss.ASLazyKernel;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OnDemandServer
extends ApplicationServer
implements EntryPoint {
    private static boolean onDemandStartup = true;
    private static ServerEntryListener listener = null;
    private static SystemAppLoader systemAppLoader = null;
    private ServiceGroup sg = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public void onInitialization(ServerContext context) throws ServerLifecycleException {
        listener = new ServerEntryListenerImpl(this);
        ServiceGroupBuilder builder = new ServiceGroupBuilder();
        this.sg = builder.buildServiceGroup(this);
        try {
            super.setServerContext(context);
            PluggableFeatureFactory pff = context.getPluggableFeatureFactory();
            ASLazyKernel lazyStartupKernel = pff.getASLazyKernel();
            onDemandStartup = lazyStartupKernel.startASSocketServices(context);
        }
        catch (Exception e) {
            onDemandStartup = false;
        }
        SerialInitContextFactory.setInitializeOrbManager(false);
        super.onInitialization(context);
        try {
            systemAppLoader = new SystemAppLoader();
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    public void onStartup() throws ServerLifecycleException {
        this.generateEntryContext(new Boolean(onDemandStartup));
        super.onStartup();
    }

    public void onShutdown() throws ServerLifecycleException {
        super.onShutdown();
        try {
            this.sg.stop(null);
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    public void generateEntryContext(Object event) {
        ServerEntryHelper.generateStartUpEntryContext((Boolean)event);
    }

    protected ArrayList instantiateRuntimeServices() throws ServerLifecycleException {
        if (onDemandStartup) {
            TomcatServices services = new TomcatServices();
            OnDemandServices ondemandservices = new OnDemandServices();
            String[][] servicesByName = services.getServicesByName();
            String[][] odsByName = ondemandservices.getServicesByName();
            if (servicesByName == null) {
                _logger.log(Level.SEVERE, "services.null");
                throw new ServerLifecycleException();
            }
            ArrayList serviceList = new ArrayList();
            block2: for (String[] service : servicesByName) {
                for (String[] ods : odsByName) {
                    if (service[0].equals(ods[0])) continue block2;
                }
                try {
                    Class<?> c = Class.forName(service[1]);
                    Object o = c.newInstance();
                    serviceList.add(o);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "server.exception", ex);
                    throw new ServerLifecycleException(ex.getMessage());
                }
            }
            return serviceList;
        }
        return super.instantiateRuntimeServices();
    }

    public static ServerEntryListener getServerEntryListener() {
        return listener;
    }

    public static SystemAppLoader getSystemAppLoader() {
        return systemAppLoader;
    }

    public ServiceGroup getServiceGroup() {
        return this.sg;
    }

    public static boolean isOnDemandOff() {
        return !onDemandStartup;
    }
}

