/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.runtime.common.ResourceRef;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class ASResourceRefName
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean notApp = false;
        try {
            ResourceRef[] resRefs = descriptor.getSunDescriptor().getResourceRef();
            if (resRefs != null && resRefs.length > 0) {
                for (int rep = 0; rep < resRefs.length; ++rep) {
                    String resrefName = resRefs[rep].getResRefName();
                    if (this.validResRefName(resrefName, descriptor)) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB sun-web-app] resource-ref name [ {0} ] properly defined in the war file.", new Object[]{resrefName}));
                    } else {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB sun-web-app] resource-ref name [ {0} ] is not valid, either empty or not defined in web.xml.", new Object[]{resrefName}));
                    }
                    DefaultResourcePrincipal defPrincipal = resRefs[rep].getDefaultResourcePrincipal();
                    if (defPrincipal == null) continue;
                    boolean defResourcePrincipalValid = true;
                    String defaultname = defPrincipal.getName();
                    String defaultpassword = defPrincipal.getPassword();
                    if (defaultname == null || defaultname.length() == 0) {
                        oneFailed = true;
                        defResourcePrincipalValid = false;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB resource-ref] name field in DefaultResourcePrincipal of ResourceRef [ {0} ] is not specified or is an empty string.", new Object[]{resrefName}));
                    }
                    if (defaultpassword == null || defaultpassword.length() == 0) {
                        oneFailed = true;
                        defResourcePrincipalValid = false;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB resource-ref] password field in DefaultResourcePrincipal of ResourceRef [ {0} ] is not specified or is an empty string.", new Object[]{resrefName}));
                    }
                    if (!defResourcePrincipalValid) continue;
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-WEB resource-ref]  DefaultResourcePrincipal of ResourceRef [ {0} ] properly defined", new Object[]{resrefName}));
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] resource-ref element not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB sun-web-app] resource-ref element(s) are valid within the web archive [ {0} ] .", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "FAILED [AS-WEB resource-env-ref] Could not create the resource-ref"));
        }
        return result;
    }

    boolean validResRefName(String name, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (name != null && name.length() != 0) {
            try {
                descriptor.getResourceReferenceByName(name);
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }
}

