/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.WebClosureCompiler;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Random;

public class WebVerifier
extends BaseVerifier {
    private WebBundleDescriptor webd = null;
    private String classPath;
    private boolean isASMode = false;
    private File jspOutDir = null;

    public WebVerifier(FrameworkContext frameworkContext, WebBundleDescriptor webd) {
        this.frameworkContext = frameworkContext;
        this.webd = webd;
        this.isASMode = !frameworkContext.isPortabilityMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.frameworkContext.isWeb()) && this.areTestsNotRequired(this.frameworkContext.isWebServices()) && this.areTestsNotRequired(this.frameworkContext.isWebServicesClient()) && this.areTestsNotRequired(this.frameworkContext.isPersistenceUnits())) {
            return;
        }
        this.jspOutDir = this.getJspOutDir();
        try {
            this.preVerification();
            this.context.setOutDir(this.jspOutDir);
            this.createClosureCompiler();
            this.verify(this.webd, new WebCheckMgrImpl(this.frameworkContext));
        }
        finally {
            if (this.frameworkContext.getJspOutDir() == null) {
                FileUtil.deleteDir(this.jspOutDir);
            }
        }
    }

    public Descriptor getDescriptor() {
        return this.webd;
    }

    protected ClassLoader createClassLoader() throws IOException {
        EJBClassLoader ejbClassLoader = new EJBClassLoader(this.webd.getClassLoader());
        ejbClassLoader.appendURL(this.jspOutDir);
        return ejbClassLoader;
    }

    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFileName(this.webd.getModuleDescriptor().getArchiveUri());
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"WEB-INF/sun-web.xml", "WEB-INF/web.xml", "WEB-INF/webservices.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.isASMode) {
            this.classPath = this.getClassPath(this.frameworkContext.getClassPath()) + File.pathSeparator + this.jspOutDir.getAbsolutePath();
            return this.classPath;
        }
        if (!this.webd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.frameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert (ear.isDirectory());
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = this.webd.getApplication().getLibraryDirectory();
            if (libdir != null) {
                earCP = this.getLibdirClasspath(ear_uri, libdir) + earCP;
            }
            String module_uri = this.webd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            assert (module.isFile() && !module.isAbsolute());
            File explodedModuleDir = new File(ear_uri, FileUtils.makeFriendlyFileName(module_uri));
            String moduleCP = ClassPathBuilder.buildClassPathForWar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.frameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert (module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForWar(module);
        }
        String as_lib_root = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
        if (this.frameworkContext.getJavaEEVersion().compareTo("5") >= 0) {
            cp = cp + File.pathSeparator + as_lib_root + "jsf-impl.jar" + File.pathSeparator + as_lib_root + "appserv-jstl.jar" + File.pathSeparator;
        }
        this.classPath = cp = cp + File.pathSeparator + this.jspOutDir.getAbsolutePath();
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getWebAppVersion(this.frameworkContext.getJavaEEVersion());
        Object arg = this.isASMode ? this.context.getClassLoader() : this.getClassPath();
        WebClosureCompiler cc = new WebClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        this.context.setClosureCompiler(cc);
    }

    private File getJspOutDir() {
        float f;
        String outDirPath;
        File out;
        File jspOutDir = this.frameworkContext.getJspOutDir();
        if (jspOutDir != null) {
            ModuleDescriptor moduleDescriptor = this.webd.getModuleDescriptor();
            if (moduleDescriptor.isStandalone()) {
                return jspOutDir;
            }
            return new File(jspOutDir, FileUtils.makeFriendlyFilename(moduleDescriptor.getArchiveUri()));
        }
        Random random = new Random();
        String prefix = System.getProperty("java.io.tmpdir") + File.separator + ".jspc";
        do {
            f = random.nextFloat();
        } while (!(out = new File(outDirPath = new String(prefix + f))).mkdirs());
        return out;
    }
}

