/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.threadpool;

import com.sun.enterprise.util.MonitorTask;
import com.sun.enterprise.util.collection.QueueClosedException;
import com.sun.enterprise.util.collection.TooManyTasksException;
import com.sun.enterprise.util.threadpool.Servicable;
import com.sun.enterprise.util.threadpool.TaskFactory;
import com.sun.enterprise.util.threadpool.TaskQueue;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastThreadPool {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected boolean bDebug = false;
    private PoolProperties poolProps;
    private TaskQueue taskQueue;
    private int waitCount = 0;
    private int totalThreadCreatedCount = 0;
    private int totalThreadDestroyedCount = 0;
    private int numMessages = 0;

    public FastThreadPool(String threadGroupName, int minThreadCount, int maxThreadCount, long maxIdleTime, int queueLimit, TaskFactory factory) {
        this(new ThreadGroup(threadGroupName), minThreadCount, maxThreadCount, maxIdleTime, new TaskQueue(queueLimit, factory));
    }

    public FastThreadPool(ThreadGroup threadGroup, int minThreadCount, int maxThreadCount, long maxIdleTime, int queueLimit, TaskFactory factory) {
        this(threadGroup, minThreadCount, maxThreadCount, maxIdleTime, new TaskQueue(queueLimit, factory));
    }

    public FastThreadPool(ThreadGroup threadGroup, int minThreadCount, int maxThreadCount, long maxIdleTime, TaskQueue queue) {
        this.taskQueue = queue;
        this.poolProps = new PoolProperties(minThreadCount, maxThreadCount, maxIdleTime, this.taskQueue, threadGroup);
    }

    public void start() {
        this.poolProps.createdCount = this.poolProps.minThreadCount;
        for (int i = 0; i < this.poolProps.minThreadCount; ++i) {
            new ThreadPoolThread(this.poolProps);
        }
        MonitorTask.addORBMonitorable(this);
    }

    public TaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    public boolean setTaskQueue(TaskQueue bq) {
        if (this.taskQueue != null) {
            return false;
        }
        this.taskQueue = bq;
        return true;
    }

    public void addFirst(Servicable servicable) throws TooManyTasksException, QueueClosedException {
        this.taskQueue.addFirst(servicable);
    }

    public void addLast(Servicable servicable) throws TooManyTasksException, QueueClosedException {
        this.taskQueue.addLast(servicable);
    }

    public void add(int index, Servicable servicable) throws TooManyTasksException, QueueClosedException {
        this.taskQueue.add(index, servicable);
    }

    public void shutdown() {
        this.taskQueue.shutdown();
    }

    public void abort() {
        this.taskQueue.abort();
    }

    public int getPoolSize() {
        return this.poolProps != null ? this.poolProps.createdCount : -1;
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMonitoredValues() {
        PoolProperties poolProperties = this.poolProps;
        synchronized (poolProperties) {
            int[] ret = new int[]{this.poolProps != null ? this.poolProps.createdCount : -1, this.waitCount};
            return ret;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FastThreadPool [CS=").append(this.poolProps.createdCount);
        sb.append(", TC=").append(this.totalThreadCreatedCount);
        sb.append(", TD=").append(this.totalThreadDestroyedCount);
        sb.append(", Min=").append(this.poolProps.minThreadCount);
        sb.append(", Max=").append(this.poolProps.maxThreadCount);
        sb.append(", MaxIdle=").append(this.poolProps.maxIdleTime);
        sb.append(", Msgs=").append(this.numMessages);
        sb.append("]");
        return sb.toString();
    }

    private class ThreadPoolThread
    implements Runnable {
        PoolProperties poolProps;

        ThreadPoolThread(PoolProperties poolProps) {
            this.poolProps = poolProps;
            Thread thread = new Thread(poolProps.threadGroup, this);
            if (poolProps.threadGroup != null && poolProps.threadGroup.isDaemon()) {
                thread.setDaemon(true);
            }
            thread.start();
            FastThreadPool.this.totalThreadCreatedCount++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Servicable task = null;
            try {
                while (true) {
                    boolean canCreateBuddy = false;
                    do {
                        PoolProperties poolProperties = this.poolProps;
                        synchronized (poolProperties) {
                            FastThreadPool.this.waitCount++;
                        }
                        task = null;
                        task = (Servicable)FastThreadPool.this.taskQueue.remove(this.poolProps.maxIdleTime);
                        poolProperties = this.poolProps;
                        synchronized (poolProperties) {
                            FastThreadPool.this.waitCount--;
                            if (task == null) {
                                if (this.poolProps.createdCount > this.poolProps.minThreadCount) {
                                    --this.poolProps.createdCount;
                                    FastThreadPool.this.totalThreadDestroyedCount++;
                                    return;
                                }
                                continue;
                            }
                            boolean bl = canCreateBuddy = FastThreadPool.this.waitCount == 0 && this.poolProps.createdCount < this.poolProps.maxThreadCount;
                            if (canCreateBuddy) {
                                ++this.poolProps.createdCount;
                            }
                            FastThreadPool.this.numMessages++;
                        }
                        if (canCreateBuddy) {
                            new ThreadPoolThread(this.poolProps);
                        }
                        try {
                            task.prolog();
                            task.service();
                            task.epilog();
                        }
                        catch (Throwable th) {
                            _logger.log(Level.SEVERE, "iplanet_util.generic_exception", th);
                        }
                    } while (task != null);
                }
            }
            catch (QueueClosedException qcEx) {
                _logger.log(Level.FINE, "Queue closed. Exitting....");
                PoolProperties poolProperties = this.poolProps;
                synchronized (poolProperties) {
                    --this.poolProps.createdCount;
                }
                FastThreadPool.this.totalThreadDestroyedCount++;
                return;
            }
            catch (InterruptedException inEx) {
                _logger.log(Level.SEVERE, "iplanet_util.generic_exception", inEx);
                PoolProperties poolProperties = this.poolProps;
                synchronized (poolProperties) {
                    --this.poolProps.createdCount;
                }
                FastThreadPool.this.totalThreadDestroyedCount++;
                return;
            }
        }
    }

    private class PoolProperties {
        int minThreadCount;
        int maxThreadCount;
        long maxIdleTime;
        TaskQueue taskQueue;
        ThreadGroup threadGroup;
        int createdCount;

        PoolProperties(int minThreadCount, int maxThreadCount, long maxIdleTime, TaskQueue taskQueue, ThreadGroup threadGroup) {
            this.minThreadCount = minThreadCount;
            this.maxThreadCount = maxThreadCount;
            this.maxIdleTime = maxIdleTime;
            this.taskQueue = taskQueue;
            this.threadGroup = threadGroup;
            this.createdCount = 0;
        }
    }
}

