/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.uuid;

import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.SecureRandom;

public class UuidUtil {
    static final String _inetAddr = UuidUtil.initInetAddr();
    private static SecureRandom _seeder = new SecureRandom();

    public static String generateUuidMM() {
        return new StringBuffer(new UID().toString()).reverse().append(':').append(_inetAddr).toString();
    }

    public static String generateUuid() {
        return UuidUtil.generateUuid(new Object());
    }

    public static String generateUuid(Object obj) {
        long presentTime = System.currentTimeMillis();
        int presentTimeLow = (int)presentTime & 0xFFFFFFFF;
        String presentTimeStringLow = UuidUtil.formatHexString(presentTimeLow);
        String nextRandom = UuidUtil.getNextRandomString();
        StringBuffer sb = new StringBuffer(50);
        sb.append(presentTimeStringLow);
        sb.append(UuidUtil.getIdentityHashCode(obj));
        sb.append(UuidUtil.addRandomTo(_inetAddr));
        sb.append(UuidUtil.getNextRandomString());
        return sb.toString();
    }

    private static String initInetAddr() {
        try {
            byte[] bytes = InetAddress.getLocalHost().getAddress();
            StringBuffer b = new StringBuffer();
            String s = null;
            for (int i = 0; i < bytes.length; ++i) {
                s = Integer.toHexString(bytes[i]);
                if (bytes[i] < 0) {
                    b.append(s.substring(s.length() - 2));
                    continue;
                }
                b.append(s);
            }
            return b.toString();
        }
        catch (Exception ex) {
            return "a48eb993";
        }
    }

    private static String addRandomTo(String hexString) {
        long hexAsLong = UuidUtil.convertToLong(hexString);
        int nextRandom = UuidUtil.getNextInt();
        long resultInt = hexAsLong + (long)nextRandom;
        String result = Long.toHexString(resultInt);
        return result;
    }

    private static String getIdentityHashCode(Object obj) {
        Object result = null;
        try {
            int hc = System.identityHashCode(obj);
            return UuidUtil.formatHexString(hc);
        }
        catch (Exception ex) {
            return "8AF5182";
        }
    }

    private static String formatHexString(int inputInt) {
        String result = null;
        String s = Integer.toHexString(inputInt);
        result = s.length() < 8 ? s : s.substring(0, 7);
        return result;
    }

    private static synchronized int getNextInt() {
        return _seeder.nextInt();
    }

    private static String getNextRandomString() {
        int nextInt = UuidUtil.getNextInt();
        return UuidUtil.formatHexString(nextInt);
    }

    private static long convertToLong(String hexString) {
        long result = 0L;
        try {
            result = Long.valueOf(hexString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(UuidUtil.generateUuidMM());
        System.out.println(UuidUtil.generateUuid());
        System.out.println(UuidUtil.generateUuid(new Object()));
    }
}

