/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import java.util.concurrent.ThreadFactory;

public class GrizzlyThreadFactory
implements ThreadFactory {
    protected String name;
    protected int port;
    protected int threadCount;
    protected int priority;
    private static final ThreadGroup threadGroup = new ThreadGroup("Grizzly");

    public GrizzlyThreadFactory(String name, int port, int priority) {
        this.name = name;
        this.port = port;
        this.priority = priority;
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(threadGroup, r);
        t.setName(this.name + "WorkerThread-" + this.port + "-" + this.threadCount);
        t.setPriority(this.priority);
        t.setDaemon(true);
        ++this.threadCount;
        return t;
    }

    public ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public boolean interruptThread(long threadID) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || thread.getId() != threadID || Thread.State.RUNNABLE == thread.getState()) continue;
            try {
                thread.interrupt();
                return true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return false;
    }
}

