/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.monitor.impl;

import com.sun.enterprise.web.monitor.PwcWebModuleStats;
import com.sun.enterprise.web.monitor.impl.MonitorUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class PwcWebModuleStatsImpl
implements PwcWebModuleStats {
    private static final String WEB_MODULE_PREFIX = "//";
    private static final String LIST_SESSION_IDS = "listSessionIds";
    private static final String GET_SESSION = "getSession";
    private static final String[] STRING_PARAM = new String[]{"java.lang.String"};
    private static final Integer ZERO_INTEGER = new Integer(0);
    private ObjectName jspMonitorObjName;
    private ObjectName sessionManagerObjName;
    private ObjectName ctxObjName;
    private transient MBeanServer server;

    public PwcWebModuleStatsImpl(String ctxObjNameStr, String ctxPath, String domain, String vsId, String appName, String serverName) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        if ("".equals(ctxPath)) {
            ctxPath = "/";
        }
        try {
            this.ctxObjName = new ObjectName(ctxObjNameStr);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.objectNameCreationError", new Object[]{ctxObjNameStr}, t);
        }
        String objNameStr = domain + ":type=JspMonitor" + ",WebModule=" + WEB_MODULE_PREFIX + vsId + ctxPath + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        try {
            this.jspMonitorObjName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.objectNameCreationError", new Object[]{objNameStr}, t);
        }
        objNameStr = domain + ":type=Manager,path=" + ctxPath + ",host=" + vsId;
        try {
            this.sessionManagerObjName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.objectNameCreationError", new Object[]{objNameStr}, t);
        }
    }

    public int getJspCount() {
        return this.queryJspStatistic(this.jspMonitorObjName, "jspCount");
    }

    public int getJspReloadCount() {
        return this.queryJspStatistic(this.jspMonitorObjName, "jspReloadCount");
    }

    public int getJspErrorCount() {
        return this.queryJspStatistic(this.jspMonitorObjName, "jspErrorCount");
    }

    public int getSessionsTotal() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "sessionCount"));
    }

    public int getActiveSessionsCurrent() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "activeSessions"));
    }

    public int getActiveSessionsHigh() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "maxActive"));
    }

    public int getRejectedSessionsTotal() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "rejectedSessions"));
    }

    public int getExpiredSessionsTotal() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "expiredSessions"));
    }

    public int getSessionMaxAliveTimeSeconds() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "sessionMaxAliveTimeSeconds"));
    }

    public int getSessionAverageAliveTimeSeconds() {
        return this.getIntValue(this.queryStatistic(this.sessionManagerObjName, "sessionAverageAliveTimeSeconds"));
    }

    public long getStartTimeMillis() {
        return this.getLongValue(this.queryStatistic(this.ctxObjName, "startTimeMillis"));
    }

    public long getServletProcessingTimesMillis() {
        return this.getLongValue(this.queryStatistic(this.ctxObjName, "processingTimeMillis"));
    }

    public String getSessionIds() {
        Object resultObj = null;
        try {
            resultObj = this.server.invoke(this.sessionManagerObjName, LIST_SESSION_IDS, null, null);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.actionInvocationError", new Object[]{LIST_SESSION_IDS, this.sessionManagerObjName}, t);
        }
        return (String)resultObj;
    }

    public HashMap getSession(String id) {
        Object resultObj;
        block2: {
            resultObj = null;
            try {
                resultObj = this.server.invoke(this.sessionManagerObjName, GET_SESSION, new Object[]{id}, STRING_PARAM);
            }
            catch (Throwable t) {
                if (t instanceof IllegalStateException) break block2;
                MonitorUtil.log(Level.SEVERE, "pwc.monitoring.actionInvocationError", new Object[]{GET_SESSION, this.sessionManagerObjName}, t);
            }
        }
        return (HashMap)resultObj;
    }

    public void reset() {
        this.resetStatistic(this.jspMonitorObjName, "jspReloadCount");
    }

    private int queryJspStatistic(ObjectName on, String attrName) {
        int result = 0;
        Set<ObjectName> jspMonitorONs = this.server.queryNames(on, null);
        for (ObjectName jspMonitorON : jspMonitorONs) {
            Object obj = this.queryStatistic(jspMonitorON, attrName);
            if (obj == null) continue;
            result += this.getIntValue(obj);
        }
        return result;
    }

    private Object queryStatistic(ObjectName on, String attrName) {
        Object resultObj = null;
        try {
            resultObj = this.server.getAttribute(on, attrName);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.queryError", new Object[]{attrName, on}, t);
        }
        return resultObj;
    }

    private void resetStatistic(ObjectName on, String attrName) {
        Attribute attr = new Attribute(attrName, ZERO_INTEGER);
        try {
            this.server.setAttribute(on, attr);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.resetError", new Object[]{attrName, on}, t);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
    }

    private long getLongValue(Object resultObj) {
        long result = 0L;
        if (resultObj != null) {
            Long countObj = (Long)resultObj;
            result = countObj;
        }
        return result;
    }

    private int getIntValue(Object resultObj) {
        int result = 0;
        if (resultObj != null) {
            Integer countObj = (Integer)resultObj;
            result = countObj;
        }
        return result;
    }
}

