/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSHttpListenerEvent;
import com.sun.enterprise.admin.event.http.HSHttpListenerEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.web.PEWebContainer;
import java.util.ArrayList;

public class HttpListenerReconfig
implements HSHttpListenerEventListener {
    private static PEWebContainer webContainer = (PEWebContainer)PEWebContainer.getInstance();

    public void handleCreate(HSHttpListenerEvent event) throws AdminEventListenerException {
        if (webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigAdd configAdd = null;
            ArrayList configChangeList = event.getConfigChangeList();
            HttpListener httpBean = null;
            String xpath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                ConfigBean object;
                Object configObject = configChangeList.get(i);
                if (!(configObject instanceof ConfigAdd) || (xpath = (configAdd = (ConfigAdd)configObject).getXPath()) == null || !((object = configContext.exactLookup(xpath)) instanceof HttpListener)) continue;
                httpBean = (HttpListener)object;
                webContainer.createConnector(httpBean, config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleUpdate(HSHttpListenerEvent event) throws AdminEventListenerException {
        if (webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigChange configChange = null;
            ArrayList configChangeList = event.getConfigChangeList();
            HttpListener httpBean = null;
            String xpath = null;
            ElementProperty elementProperty = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configChange = (ConfigChange)configChangeList.get(i);
                xpath = configChange.getXPath();
                if (xpath == null) continue;
                ConfigBean object = configContext.exactLookup(xpath);
                if (object instanceof HttpListener) {
                    httpBean = (HttpListener)object;
                    webContainer.updateConnector(httpBean, config.getHttpService());
                    continue;
                }
                if (!(object instanceof ElementProperty)) continue;
                xpath = xpath.substring(0, xpath.lastIndexOf("/"));
                httpBean = (HttpListener)configContext.exactLookup(xpath);
                elementProperty = (ElementProperty)object;
                webContainer.updateConnectorProperty(httpBean, elementProperty.getName(), elementProperty.getValue());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(HSHttpListenerEvent event) throws AdminEventListenerException {
        if (webContainer == null) {
            return;
        }
        try {
            if (event != null) {
                ConfigContext configContext = event.getConfigContext();
                Config config = ServerBeansFactory.getConfigBean(configContext);
                if (config == null) {
                    return;
                }
                webContainer.deleteConnector(config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }
}

