/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.webservice.EjbMessageDispatcher;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.EndpointImpl;
import com.sun.enterprise.webservice.monitoring.HttpResponseInfoImpl;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WSRtObjectFactory;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.handler.MessageContext;

public class Ejb3MessageDispatcher
implements EjbMessageDispatcher {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static WsUtil wsUtil = new WsUtil();
    private static Tie tie = new Tie();
    private static WSRtObjectFactory rpcFactory = WSRtObjectFactory.newInstance();
    private WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();

    public void invoke(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JAXWS WebServiceDispatcher " + req.getMethod() + " entering for " + req.getRequestURI() + " and query string " + req.getQueryString());
        }
        String method = req.getMethod();
        try {
            if (method.equals("POST")) {
                this.handlePost(req, resp, endpointInfo);
            } else if (method.equals("GET")) {
                this.handleGet(req, resp, endpointInfo);
            } else {
                String errorMessage = "Unsupported method request = [" + method + "] for endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri();
                logger.warning(errorMessage);
                wsUtil.writeInvalidMethodType(resp, errorMessage);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb endpoint exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePost(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        EndpointImpl endpoint = null;
        String messageID = null;
        try {
            try {
                RuntimeEndpointInfo jaxwsInfo = endpointInfo.prepareInvocation(true);
                if (jaxwsInfo != null) {
                    endpoint = (EndpointImpl)endpointInfo.getEndpoint().getExtraAttribute("MONITORING_ENDPOINT");
                    if (endpoint != null) {
                        if (this.wsEngine.hasGlobalMessageListener()) {
                            messageID = this.wsEngine.preProcessRequest(endpoint);
                        }
                    } else {
                        logger.fine("Missing internal monitoring info to trace " + req.getRequestURI());
                    }
                    WSConnection connection = rpcFactory.createWSConnection(req, resp);
                    WebServiceContext wsCtxt = jaxwsInfo.getWebServiceContext();
                    MessageContext msgCtxt = wsCtxt.getMessageContext();
                    msgCtxt.put((Object)"javax.xml.ws.servlet.request", (Object)req);
                    msgCtxt.setScope("javax.xml.ws.servlet.request", MessageContext.Scope.APPLICATION);
                    msgCtxt.put((Object)"javax.xml.ws.servlet.response", (Object)resp);
                    msgCtxt.setScope("javax.xml.ws.servlet.response", MessageContext.Scope.APPLICATION);
                    msgCtxt.put((Object)"javax.xml.ws.http.request.method", (Object)req.getMethod());
                    msgCtxt.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
                    if (req.getQueryString() != null) {
                        msgCtxt.put((Object)"javax.xml.ws.http.request.querystring", (Object)req.getQueryString());
                        msgCtxt.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
                    }
                    if (req.getPathInfo() != null) {
                        msgCtxt.put((Object)"javax.xml.ws.http.request.pathinfo", (Object)req.getPathInfo());
                        msgCtxt.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
                    }
                    msgCtxt.put((Object)"javax.xml.ws.http.request.headers", (Object)connection.getHeaders());
                    msgCtxt.setScope("javax.xml.ws.http.request.headers", MessageContext.Scope.APPLICATION);
                    msgCtxt.put((Object)"MONITORING_MESSAGE_ID", (Object)messageID);
                    tie.handle(connection, jaxwsInfo);
                }
            }
            finally {
                endpointInfo.releaseImplementor();
            }
        }
        catch (Throwable e) {
            String errorMessage = "invocation error on ejb endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri() + " : " + e.getMessage();
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
        if (messageID != null) {
            HttpResponseInfoImpl response = new HttpResponseInfoImpl(resp);
            this.wsEngine.postProcessResponse(messageID, response);
        }
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        wsUtil.handleGet(req, resp, endpointInfo.getEndpoint());
    }
}

