/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Vote;

public class XATerminatorImpl
implements XATerminator {
    private static void check(Xid xid) throws XAException {
        if (xid == null || xid.getFormatId() == 0 || xid.getBranchQualifier() == null || xid.getGlobalTransactionId() == null) {
            throw new XAException(-4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XATerminatorImpl.check(xid);
        GlobalTID tid = new GlobalTID(xid);
        if (!RecoveryManager.readAndUpdateTxMap(tid)) {
            throw new XAException(-6);
        }
        boolean exceptionFlag = false;
        int errorCode = -6;
        try {
            RecoveryManager.waitForRecovery();
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
            if (coord == null) {
                errorCode = -6;
                throw new XAException(errorCode);
            }
            TopCoordinator topCoordinator = coord;
            synchronized (topCoordinator) {
                if (onePhase) {
                    coord.beforeCompletion();
                    if (coord.getParticipantCount() == 1) {
                        coord.commitOnePhase();
                    } else {
                        Vote vote = Vote.VoteRollback;
                        try {
                            vote = coord.prepare();
                        }
                        catch (HeuristicMixed exc) {
                            errorCode = 8;
                            throw new XAException(errorCode);
                        }
                        if (vote == Vote.VoteCommit) {
                            coord.commit();
                        } else if (vote == Vote.VoteRollback) {
                            coord.rollback(true);
                        }
                    }
                } else {
                    coord.commit();
                }
            }
        }
        catch (Throwable exc) {
            exceptionFlag = true;
            XAException xaExc = new XAException(errorCode);
            xaExc.initCause(exc);
            throw xaExc;
        }
        finally {
            Thread thread = RecoveryManager.removeFromTxMap(tid);
            if (!(thread != null && thread == Thread.currentThread() || exceptionFlag)) {
                throw new XAException(-3);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int prepare(Xid xid) throws XAException {
        int errorCode;
        boolean exceptionFlag;
        GlobalTID tid;
        block15: {
            Vote vote;
            block16: {
                XATerminatorImpl.check(xid);
                tid = new GlobalTID(xid);
                if (!RecoveryManager.readAndUpdateTxMap(tid)) {
                    throw new XAException(-6);
                }
                exceptionFlag = false;
                errorCode = -6;
                RecoveryManager.waitForRecovery();
                TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
                if (coord == null) {
                    errorCode = -6;
                    throw new XAException(errorCode);
                }
                TopCoordinator topCoordinator = coord;
                // MONITORENTER : topCoordinator
                coord.beforeCompletion();
                vote = coord.prepare();
                if (vote == Vote.VoteRollback) {
                    errorCode = 100;
                    break block15;
                }
                if (vote != Vote.VoteCommit) break block16;
                int n = 0;
                // MONITOREXIT : topCoordinator
                Thread thread = RecoveryManager.removeFromTxMap(tid);
                if (thread != null) {
                    if (thread == Thread.currentThread()) return n;
                }
                if (exceptionFlag) return n;
                throw new XAException(-3);
            }
            if (vote != Vote.VoteReadOnly) break block15;
            int n = 3;
            // MONITOREXIT : topCoordinator
            {
                catch (Throwable exc) {
                    exceptionFlag = true;
                    XAException xaExc = new XAException(errorCode);
                    xaExc.initCause(exc);
                    throw xaExc;
                }
            }
            Thread thread = RecoveryManager.removeFromTxMap(tid);
            if (thread != null) {
                if (thread == Thread.currentThread()) return n;
            }
            if (exceptionFlag) return n;
            throw new XAException(-3);
        }
        try {
            throw new XAException(errorCode);
        }
        catch (Throwable throwable) {
            Thread thread = RecoveryManager.removeFromTxMap(tid);
            if (thread != null) {
                if (thread == Thread.currentThread()) throw throwable;
            }
            if (exceptionFlag) throw throwable;
            throw new XAException(-3);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        RecoveryManager.waitForResync();
        return TimeoutManager.getInDoubtXids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        XATerminatorImpl.check(xid);
        GlobalTID tid = new GlobalTID(xid);
        if (!RecoveryManager.readAndUpdateTxMap(tid)) {
            throw new XAException(-6);
        }
        boolean exceptionFlag = false;
        int errorCode = -6;
        try {
            RecoveryManager.waitForRecovery();
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
            if (coord == null) {
                errorCode = -6;
                throw new XAException(errorCode);
            }
            TopCoordinator topCoordinator = coord;
            synchronized (topCoordinator) {
                coord.rollback(true);
            }
        }
        catch (Throwable exc) {
            exceptionFlag = true;
            XAException xaExc = new XAException(errorCode);
            xaExc.initCause(exc);
            throw xaExc;
        }
        finally {
            Thread thread = RecoveryManager.removeFromTxMap(tid);
            if (!(thread != null && thread == Thread.currentThread() || exceptionFlag)) {
                throw new XAException(-3);
            }
        }
    }
}

